package software.amazon.awscdk.integtests;

/**
 * (experimental) A request to make an assertion that the actual value matches the expected.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.integtests.*;
 * Object actual;
 * Object expected;
 * AssertionRequest assertionRequest = AssertionRequest.builder()
 *         .actual(actual)
 *         .expected(expected)
 *         // the properties below are optional
 *         .failDeployment(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.904Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.AssertionRequest")
@software.amazon.jsii.Jsii.Proxy(AssertionRequest.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AssertionRequest extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The actual value received.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Object getActual();

    /**
     * (experimental) The expected value to assert.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Object getExpected();

    /**
     * (experimental) Set this to true if a failed assertion should result in a CloudFormation deployment failure.
     * <p>
     * This is only necessary if assertions are being
     * executed outside of <code>integ-runner</code>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFailDeployment() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AssertionRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssertionRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AssertionRequest> {
        java.lang.Object actual;
        java.lang.Object expected;
        java.lang.Boolean failDeployment;

        /**
         * Sets the value of {@link AssertionRequest#getActual}
         * @param actual The actual value received. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actual(java.lang.Object actual) {
            this.actual = actual;
            return this;
        }

        /**
         * Sets the value of {@link AssertionRequest#getExpected}
         * @param expected The expected value to assert. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expected(java.lang.Object expected) {
            this.expected = expected;
            return this;
        }

        /**
         * Sets the value of {@link AssertionRequest#getFailDeployment}
         * @param failDeployment Set this to true if a failed assertion should result in a CloudFormation deployment failure.
         *                       This is only necessary if assertions are being
         *                       executed outside of <code>integ-runner</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder failDeployment(java.lang.Boolean failDeployment) {
            this.failDeployment = failDeployment;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssertionRequest}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AssertionRequest build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssertionRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssertionRequest {
        private final java.lang.Object actual;
        private final java.lang.Object expected;
        private final java.lang.Boolean failDeployment;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actual = software.amazon.jsii.Kernel.get(this, "actual", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.expected = software.amazon.jsii.Kernel.get(this, "expected", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.failDeployment = software.amazon.jsii.Kernel.get(this, "failDeployment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actual = java.util.Objects.requireNonNull(builder.actual, "actual is required");
            this.expected = java.util.Objects.requireNonNull(builder.expected, "expected is required");
            this.failDeployment = builder.failDeployment;
        }

        @Override
        public final java.lang.Object getActual() {
            return this.actual;
        }

        @Override
        public final java.lang.Object getExpected() {
            return this.expected;
        }

        @Override
        public final java.lang.Boolean getFailDeployment() {
            return this.failDeployment;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actual", om.valueToTree(this.getActual()));
            data.set("expected", om.valueToTree(this.getExpected()));
            if (this.getFailDeployment() != null) {
                data.set("failDeployment", om.valueToTree(this.getFailDeployment()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.integ_tests.AssertionRequest"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssertionRequest.Jsii$Proxy that = (AssertionRequest.Jsii$Proxy) o;

            if (!actual.equals(that.actual)) return false;
            if (!expected.equals(that.expected)) return false;
            return this.failDeployment != null ? this.failDeployment.equals(that.failDeployment) : that.failDeployment == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actual.hashCode();
            result = 31 * result + (this.expected.hashCode());
            result = 31 * result + (this.failDeployment != null ? this.failDeployment.hashCode() : 0);
            return result;
        }
    }
}
