package software.amazon.awscdk.integtests;

/**
 * (experimental) A AWS JavaScript SDK V2 request.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.integtests.*;
 * Object parameters;
 * AwsApiCallRequest awsApiCallRequest = AwsApiCallRequest.builder()
 *         .api("api")
 *         .service("service")
 *         // the properties below are optional
 *         .flattenResponse("flattenResponse")
 *         .parameters(parameters)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.912Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.AwsApiCallRequest")
@software.amazon.jsii.Jsii.Proxy(AwsApiCallRequest.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AwsApiCallRequest extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The AWS api call to make i.e. getBucketLifecycle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getApi();

    /**
     * (experimental) The AWS service i.e. S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getService();

    /**
     * (experimental) Whether or not to flatten the response from the api call.
     * <p>
     * Valid values are 'true' or 'false' as strings
     * <p>
     * Typically when using an SdkRequest you will be passing it as the
     * <code>actual</code> value to an assertion provider so this would be set
     * to 'false' (you want the actual response).
     * <p>
     * If you are using the SdkRequest to perform more of a query to return
     * a single value to use, then this should be set to 'true'. For example,
     * you could make a StepFunctions.startExecution api call and retreive the
     * <code>executionArn</code> from the response.
     * <p>
     * Default: 'false'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getFlattenResponse() {
        return null;
    }

    /**
     * (experimental) Any parameters to pass to the api call.
     * <p>
     * Default: - no parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsApiCallRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsApiCallRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AwsApiCallRequest> {
        java.lang.String api;
        java.lang.String service;
        java.lang.String flattenResponse;
        java.lang.Object parameters;

        /**
         * Sets the value of {@link AwsApiCallRequest#getApi}
         * @param api The AWS api call to make i.e. getBucketLifecycle. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder api(java.lang.String api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link AwsApiCallRequest#getService}
         * @param service The AWS service i.e. S3. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link AwsApiCallRequest#getFlattenResponse}
         * @param flattenResponse Whether or not to flatten the response from the api call.
         *                        Valid values are 'true' or 'false' as strings
         *                        <p>
         *                        Typically when using an SdkRequest you will be passing it as the
         *                        <code>actual</code> value to an assertion provider so this would be set
         *                        to 'false' (you want the actual response).
         *                        <p>
         *                        If you are using the SdkRequest to perform more of a query to return
         *                        a single value to use, then this should be set to 'true'. For example,
         *                        you could make a StepFunctions.startExecution api call and retreive the
         *                        <code>executionArn</code> from the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder flattenResponse(java.lang.String flattenResponse) {
            this.flattenResponse = flattenResponse;
            return this;
        }

        /**
         * Sets the value of {@link AwsApiCallRequest#getParameters}
         * @param parameters Any parameters to pass to the api call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsApiCallRequest}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AwsApiCallRequest build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AwsApiCallRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsApiCallRequest {
        private final java.lang.String api;
        private final java.lang.String service;
        private final java.lang.String flattenResponse;
        private final java.lang.Object parameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flattenResponse = software.amazon.jsii.Kernel.get(this, "flattenResponse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.api = java.util.Objects.requireNonNull(builder.api, "api is required");
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.flattenResponse = builder.flattenResponse;
            this.parameters = builder.parameters;
        }

        @Override
        public final java.lang.String getApi() {
            return this.api;
        }

        @Override
        public final java.lang.String getService() {
            return this.service;
        }

        @Override
        public final java.lang.String getFlattenResponse() {
            return this.flattenResponse;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("api", om.valueToTree(this.getApi()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getFlattenResponse() != null) {
                data.set("flattenResponse", om.valueToTree(this.getFlattenResponse()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.integ_tests.AwsApiCallRequest"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsApiCallRequest.Jsii$Proxy that = (AwsApiCallRequest.Jsii$Proxy) o;

            if (!api.equals(that.api)) return false;
            if (!service.equals(that.service)) return false;
            if (this.flattenResponse != null ? !this.flattenResponse.equals(that.flattenResponse) : that.flattenResponse != null) return false;
            return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.api.hashCode();
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.flattenResponse != null ? this.flattenResponse.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            return result;
        }
    }
}
