package software.amazon.awscdk.integtests;

/**
 * (experimental) The type of invocation.
 * <p>
 * Default is REQUEST_RESPONE
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app;
 * Stack stack;
 * Queue queue;
 * IFunction fn;
 * IntegTest integ = IntegTest.Builder.create(app, "Integ")
 *         .testCases(List.of(stack))
 *         .build();
 * integ.assertions.invokeFunction(LambdaInvokeFunctionProps.builder()
 *         .functionName(fn.getFunctionName())
 *         .invocationType(InvocationType.EVENT)
 *         .payload(JSON.stringify(Map.of("status", "OK")))
 *         .build());
 * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage", Map.of(
 *         "QueueUrl", queue.getQueueUrl(),
 *         "WaitTimeSeconds", 20));
 * message.assertAtPath("Messages.0.Body", ExpectedResult.objectLike(Map.of(
 *         "requestContext", Map.of(
 *                 "condition", "Success"),
 *         "requestPayload", Map.of(
 *                 "status", "OK"),
 *         "responseContext", Map.of(
 *                 "statusCode", 200),
 *         "responsePayload", "success")));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.954Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.InvocationType")
public enum InvocationType {
    /**
     * (experimental) Invoke the function asynchronously.
     * <p>
     * Send events that fail multiple times to the function's
     * dead-letter queue (if it's configured).
     * The API response only includes a status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EVENT,
    /**
     * (experimental) Invoke the function synchronously.
     * <p>
     * Keep the connection open until the function returns a response or times out.
     * The API response includes the function response and additional data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    REQUEST_RESPONE,
    /**
     * (experimental) Validate parameter values and verify that the user or role has permission to invoke the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DRY_RUN,
}
