package software.amazon.awscdk.integtests;

/**
 * (experimental) Options to pass to the Lambda invokeFunction API call.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IFunction lambdaFunction;
 * App app;
 * Stack stack = new Stack(app, "cdk-integ-lambda-bundling");
 * IntegTest integ = IntegTest.Builder.create(app, "IntegTest")
 *         .testCases(List.of(stack))
 *         .build();
 * IAwsApiCall invoke = integ.assertions.invokeFunction(LambdaInvokeFunctionProps.builder()
 *         .functionName(lambdaFunction.getFunctionName())
 *         .build());
 * invoke.expect(ExpectedResult.objectLike(Map.of(
 *         "Payload", "200")));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.957Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.LambdaInvokeFunctionProps")
@software.amazon.jsii.Jsii.Proxy(LambdaInvokeFunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LambdaInvokeFunctionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The name of the function to invoke.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

    /**
     * (experimental) The type of invocation to use.
     * <p>
     * Default: InvocationType.REQUEST_RESPONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.integtests.InvocationType getInvocationType() {
        return null;
    }

    /**
     * (experimental) Whether to return the logs as part of the response.
     * <p>
     * Default: LogType.NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.integtests.LogType getLogType() {
        return null;
    }

    /**
     * (experimental) Payload to send as part of the invoke.
     * <p>
     * Default: - no payload
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPayload() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaInvokeFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaInvokeFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaInvokeFunctionProps> {
        java.lang.String functionName;
        software.amazon.awscdk.integtests.InvocationType invocationType;
        software.amazon.awscdk.integtests.LogType logType;
        java.lang.String payload;

        /**
         * Sets the value of {@link LambdaInvokeFunctionProps#getFunctionName}
         * @param functionName The name of the function to invoke. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeFunctionProps#getInvocationType}
         * @param invocationType The type of invocation to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder invocationType(software.amazon.awscdk.integtests.InvocationType invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeFunctionProps#getLogType}
         * @param logType Whether to return the logs as part of the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logType(software.amazon.awscdk.integtests.LogType logType) {
            this.logType = logType;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeFunctionProps#getPayload}
         * @param payload Payload to send as part of the invoke.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder payload(java.lang.String payload) {
            this.payload = payload;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaInvokeFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LambdaInvokeFunctionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaInvokeFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaInvokeFunctionProps {
        private final java.lang.String functionName;
        private final software.amazon.awscdk.integtests.InvocationType invocationType;
        private final software.amazon.awscdk.integtests.LogType logType;
        private final java.lang.String payload;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.invocationType = software.amazon.jsii.Kernel.get(this, "invocationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.InvocationType.class));
            this.logType = software.amazon.jsii.Kernel.get(this, "logType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.LogType.class));
            this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            this.invocationType = builder.invocationType;
            this.logType = builder.logType;
            this.payload = builder.payload;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final software.amazon.awscdk.integtests.InvocationType getInvocationType() {
            return this.invocationType;
        }

        @Override
        public final software.amazon.awscdk.integtests.LogType getLogType() {
            return this.logType;
        }

        @Override
        public final java.lang.String getPayload() {
            return this.payload;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionName", om.valueToTree(this.getFunctionName()));
            if (this.getInvocationType() != null) {
                data.set("invocationType", om.valueToTree(this.getInvocationType()));
            }
            if (this.getLogType() != null) {
                data.set("logType", om.valueToTree(this.getLogType()));
            }
            if (this.getPayload() != null) {
                data.set("payload", om.valueToTree(this.getPayload()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.integ_tests.LambdaInvokeFunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaInvokeFunctionProps.Jsii$Proxy that = (LambdaInvokeFunctionProps.Jsii$Proxy) o;

            if (!functionName.equals(that.functionName)) return false;
            if (this.invocationType != null ? !this.invocationType.equals(that.invocationType) : that.invocationType != null) return false;
            if (this.logType != null ? !this.logType.equals(that.logType) : that.logType != null) return false;
            return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionName.hashCode();
            result = 31 * result + (this.invocationType != null ? this.invocationType.hashCode() : 0);
            result = 31 * result + (this.logType != null ? this.logType.hashCode() : 0);
            result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
            return result;
        }
    }
}
