package software.amazon.awscdk.pipelines;

/**
 * (experimental) Configuration options for a CodeCommit source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.pipelines.*;
 * Role role;
 * CodeCommitSourceOptions codeCommitSourceOptions = CodeCommitSourceOptions.builder()
 *         .codeBuildCloneOutput(false)
 *         .eventRole(role)
 *         .trigger(CodeCommitTrigger.NONE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:13.084Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.pipelines.CodeCommitSourceOptions")
@software.amazon.jsii.Jsii.Proxy(CodeCommitSourceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CodeCommitSourceOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) If this is set, the next CodeBuild job clones the repository (instead of CodePipeline downloading the files).
     * <p>
     * This provides access to repository history, and retains symlinks (symlinks would otherwise be
     * removed by CodePipeline).
     * <p>
     * <strong>Note</strong>: if this option is true, only CodeBuild jobs can use the output artifact.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeCommit.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeCommit.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCodeBuildCloneOutput() {
        return null;
    }

    /**
     * (experimental) Role to be used by on commit event rule.
     * <p>
     * Used only when trigger value is CodeCommitTrigger.EVENTS.
     * <p>
     * Default: a new role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getEventRole() {
        return null;
    }

    /**
     * (experimental) How should CodePipeline detect source changes for this Action.
     * <p>
     * Default: CodeCommitTrigger.EVENTS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger getTrigger() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeCommitSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeCommitSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CodeCommitSourceOptions> {
        java.lang.Boolean codeBuildCloneOutput;
        software.amazon.awscdk.services.iam.IRole eventRole;
        software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger trigger;

        /**
         * Sets the value of {@link CodeCommitSourceOptions#getCodeBuildCloneOutput}
         * @param codeBuildCloneOutput If this is set, the next CodeBuild job clones the repository (instead of CodePipeline downloading the files).
         *                             This provides access to repository history, and retains symlinks (symlinks would otherwise be
         *                             removed by CodePipeline).
         *                             <p>
         *                             <strong>Note</strong>: if this option is true, only CodeBuild jobs can use the output artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeBuildCloneOutput(java.lang.Boolean codeBuildCloneOutput) {
            this.codeBuildCloneOutput = codeBuildCloneOutput;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceOptions#getEventRole}
         * @param eventRole Role to be used by on commit event rule.
         *                  Used only when trigger value is CodeCommitTrigger.EVENTS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder eventRole(software.amazon.awscdk.services.iam.IRole eventRole) {
            this.eventRole = eventRole;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceOptions#getTrigger}
         * @param trigger How should CodePipeline detect source changes for this Action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder trigger(software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeCommitSourceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CodeCommitSourceOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeCommitSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeCommitSourceOptions {
        private final java.lang.Boolean codeBuildCloneOutput;
        private final software.amazon.awscdk.services.iam.IRole eventRole;
        private final software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger trigger;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.codeBuildCloneOutput = software.amazon.jsii.Kernel.get(this, "codeBuildCloneOutput", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.eventRole = software.amazon.jsii.Kernel.get(this, "eventRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.codeBuildCloneOutput = builder.codeBuildCloneOutput;
            this.eventRole = builder.eventRole;
            this.trigger = builder.trigger;
        }

        @Override
        public final java.lang.Boolean getCodeBuildCloneOutput() {
            return this.codeBuildCloneOutput;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getEventRole() {
            return this.eventRole;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger getTrigger() {
            return this.trigger;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCodeBuildCloneOutput() != null) {
                data.set("codeBuildCloneOutput", om.valueToTree(this.getCodeBuildCloneOutput()));
            }
            if (this.getEventRole() != null) {
                data.set("eventRole", om.valueToTree(this.getEventRole()));
            }
            if (this.getTrigger() != null) {
                data.set("trigger", om.valueToTree(this.getTrigger()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.pipelines.CodeCommitSourceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeCommitSourceOptions.Jsii$Proxy that = (CodeCommitSourceOptions.Jsii$Proxy) o;

            if (this.codeBuildCloneOutput != null ? !this.codeBuildCloneOutput.equals(that.codeBuildCloneOutput) : that.codeBuildCloneOutput != null) return false;
            if (this.eventRole != null ? !this.eventRole.equals(that.eventRole) : that.eventRole != null) return false;
            return this.trigger != null ? this.trigger.equals(that.trigger) : that.trigger == null;
        }

        @Override
        public final int hashCode() {
            int result = this.codeBuildCloneOutput != null ? this.codeBuildCloneOutput.hashCode() : 0;
            result = 31 * result + (this.eventRole != null ? this.eventRole.hashCode() : 0);
            result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
            return result;
        }
    }
}
