package software.amazon.awscdk.pipelines;

/**
 * (experimental) A generic CDK Pipelines pipeline.
 * <p>
 * Different deployment systems will provide subclasses of <code>Pipeline</code> that generate
 * the deployment infrastructure necessary to deploy CDK apps, specific to that system.
 * <p>
 * This library comes with the <code>CodePipeline</code> class, which uses AWS CodePipeline
 * to deploy CDK apps.
 * <p>
 * The actual pipeline infrastructure is constructed (by invoking the engine)
 * when <code>buildPipeline()</code> is called, or when <code>app.synth()</code> is called (whichever
 * happens first).
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:13.130Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.pipelines.PipelineBase")
public abstract class PipelineBase extends software.amazon.awscdk.core.Construct {

    protected PipelineBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PipelineBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected PipelineBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.PipelineBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Deploy a single Stage by itself.
     * <p>
     * Add a Stage to the pipeline, to be deployed in sequence with other
     * Stages added to the pipeline. All Stacks in the stage will be deployed
     * in an order automatically determined by their relative dependencies.
     * <p>
     * @param stage This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.AddStageOpts options) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), options });
    }

    /**
     * (experimental) Deploy a single Stage by itself.
     * <p>
     * Add a Stage to the pipeline, to be deployed in sequence with other
     * Stages added to the pipeline. All Stacks in the stage will be deployed
     * in an order automatically determined by their relative dependencies.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stage stage) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * (experimental) Add a Wave to the pipeline, for deploying multiple Stages in parallel.
     * <p>
     * Use the return object of this method to deploy multiple stages in parallel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * CodePipeline pipeline;
     * Wave wave = pipeline.addWave("MyWave");
     * wave.addStage(new MyApplicationStage(this, "Stage1"));
     * wave.addStage(new MyApplicationStage(this, "Stage2"));
     * </pre></blockquote>
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Wave addWave(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.WaveOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addWave", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Wave.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Add a Wave to the pipeline, for deploying multiple Stages in parallel.
     * <p>
     * Use the return object of this method to deploy multiple stages in parallel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * CodePipeline pipeline;
     * Wave wave = pipeline.addWave("MyWave");
     * wave.addStage(new MyApplicationStage(this, "Stage1"));
     * wave.addStage(new MyApplicationStage(this, "Stage2"));
     * </pre></blockquote>
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Wave addWave(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addWave", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Wave.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Send the current pipeline definition to the engine, and construct the pipeline.
     * <p>
     * It is not possible to modify the pipeline after calling this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void buildPipeline() {
        software.amazon.jsii.Kernel.call(this, "buildPipeline", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Implemented by subclasses to do the actual pipeline construction.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected abstract void doBuildPipeline();

    /**
     * (experimental) The FileSet tha contains the cloud assembly.
     * <p>
     * This is the primary output of the synth step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.FileSet getCloudAssemblyFileSet() {
        return software.amazon.jsii.Kernel.get(this, "cloudAssemblyFileSet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSet.class));
    }

    /**
     * (experimental) The build step that produces the CDK Cloud Assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.IFileSetProducer getSynth() {
        return software.amazon.jsii.Kernel.get(this, "synth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IFileSetProducer.class));
    }

    /**
     * (experimental) The waves in this pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Wave> getWaves() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "waves", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Wave.class))));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.pipelines.PipelineBase implements software.amazon.awscdk.core.IConstruct.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Implemented by subclasses to do the actual pipeline construction.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        protected final void doBuildPipeline() {
            software.amazon.jsii.Kernel.call(this, "doBuildPipeline", software.amazon.jsii.NativeType.VOID);
        }
    }
}
