package software.amazon.awscdk.services.accessanalyzer;

/**
 * Properties for defining a `CfnAnalyzer`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.accessanalyzer.*;
 * CfnAnalyzerProps cfnAnalyzerProps = CfnAnalyzerProps.builder()
 *         .type("type")
 *         // the properties below are optional
 *         .analyzerName("analyzerName")
 *         .archiveRules(List.of(ArchiveRuleProperty.builder()
 *                 .filter(List.of(FilterProperty.builder()
 *                         .property("property")
 *                         // the properties below are optional
 *                         .contains(List.of("contains"))
 *                         .eq(List.of("eq"))
 *                         .exists(false)
 *                         .neq(List.of("neq"))
 *                         .build()))
 *                 .ruleName("ruleName")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.670Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_accessanalyzer.CfnAnalyzerProps")
@software.amazon.jsii.Jsii.Proxy(CfnAnalyzerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAnalyzerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type represents the zone of trust for the analyzer.
     * <p>
     * <em>Allowed Values</em> : ACCOUNT | ORGANIZATION
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The name of the analyzer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAnalyzerName() {
        return null;
    }

    /**
     * Specifies the archive rules to add for the analyzer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getArchiveRules() {
        return null;
    }

    /**
     * The tags to apply to the analyzer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAnalyzerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAnalyzerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAnalyzerProps> {
        java.lang.String type;
        java.lang.String analyzerName;
        java.lang.Object archiveRules;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAnalyzerProps#getType}
         * @param type The type represents the zone of trust for the analyzer. This parameter is required.
         *             <em>Allowed Values</em> : ACCOUNT | ORGANIZATION
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getAnalyzerName}
         * @param analyzerName The name of the analyzer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyzerName(java.lang.String analyzerName) {
            this.analyzerName = analyzerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getArchiveRules}
         * @param archiveRules Specifies the archive rules to add for the analyzer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveRules(software.amazon.awscdk.core.IResolvable archiveRules) {
            this.archiveRules = archiveRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getArchiveRules}
         * @param archiveRules Specifies the archive rules to add for the analyzer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveRules(java.util.List<? extends java.lang.Object> archiveRules) {
            this.archiveRules = archiveRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getTags}
         * @param tags The tags to apply to the analyzer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAnalyzerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAnalyzerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAnalyzerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAnalyzerProps {
        private final java.lang.String type;
        private final java.lang.String analyzerName;
        private final java.lang.Object archiveRules;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.analyzerName = software.amazon.jsii.Kernel.get(this, "analyzerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.archiveRules = software.amazon.jsii.Kernel.get(this, "archiveRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.analyzerName = builder.analyzerName;
            this.archiveRules = builder.archiveRules;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getAnalyzerName() {
            return this.analyzerName;
        }

        @Override
        public final java.lang.Object getArchiveRules() {
            return this.archiveRules;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getAnalyzerName() != null) {
                data.set("analyzerName", om.valueToTree(this.getAnalyzerName()));
            }
            if (this.getArchiveRules() != null) {
                data.set("archiveRules", om.valueToTree(this.getArchiveRules()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_accessanalyzer.CfnAnalyzerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAnalyzerProps.Jsii$Proxy that = (CfnAnalyzerProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.analyzerName != null ? !this.analyzerName.equals(that.analyzerName) : that.analyzerName != null) return false;
            if (this.archiveRules != null ? !this.archiveRules.equals(that.archiveRules) : that.archiveRules != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.analyzerName != null ? this.analyzerName.hashCode() : 0);
            result = 31 * result + (this.archiveRules != null ? this.archiveRules.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
