package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Auto branch creation configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp = App.Builder.create(this, "MyApp")
 *         .sourceCodeProvider(GitHubSourceCodeProvider.Builder.create()
 *                 .owner("&lt;user&gt;")
 *                 .repository("&lt;repo&gt;")
 *                 .oauthToken(SecretValue.secretsManager("my-github-token"))
 *                 .build())
 *         .autoBranchCreation(AutoBranchCreation.builder() // Automatically connect branches that match a pattern set
 *                 .patterns(List.of("feature/*", "test/*")).build())
 *         .autoBranchDeletion(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.813Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.AutoBranchCreation")
@software.amazon.jsii.Jsii.Proxy(AutoBranchCreation.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AutoBranchCreation extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Whether to enable auto building for the auto created branch.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoBuild() {
        return null;
    }

    /**
     * (experimental) The Basic Auth configuration.
     * <p>
     * Use this to set password protection for
     * the auto created branch.
     * <p>
     * Default: - no password protection
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.BasicAuth getBasicAuth() {
        return null;
    }

    /**
     * (experimental) Build spec for the auto created branch.
     * <p>
     * Default: - application build spec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
        return null;
    }

    /**
     * (experimental) Environment variables for the auto created branch.
     * <p>
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     * <p>
     * Default: - application environment variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
        return null;
    }

    /**
     * (experimental) Automated branch creation glob patterns.
     * <p>
     * Default: - all repository branches
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPatterns() {
        return null;
    }

    /**
     * (experimental) The dedicated backend environment for the pull request previews of the auto created branch.
     * <p>
     * Default: - automatically provision a temporary backend
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPullRequestEnvironmentName() {
        return null;
    }

    /**
     * (experimental) Whether to enable pull request preview for the auto created branch.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPullRequestPreview() {
        return null;
    }

    /**
     * (experimental) Stage for the auto created branch.
     * <p>
     * Default: - no stage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getStage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AutoBranchCreation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoBranchCreation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AutoBranchCreation> {
        java.lang.Boolean autoBuild;
        software.amazon.awscdk.services.amplify.BasicAuth basicAuth;
        software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        java.util.List<java.lang.String> patterns;
        java.lang.String pullRequestEnvironmentName;
        java.lang.Boolean pullRequestPreview;
        java.lang.String stage;

        /**
         * Sets the value of {@link AutoBranchCreation#getAutoBuild}
         * @param autoBuild Whether to enable auto building for the auto created branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoBuild(java.lang.Boolean autoBuild) {
            this.autoBuild = autoBuild;
            return this;
        }

        /**
         * Sets the value of {@link AutoBranchCreation#getBasicAuth}
         * @param basicAuth The Basic Auth configuration.
         *                  Use this to set password protection for
         *                  the auto created branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder basicAuth(software.amazon.awscdk.services.amplify.BasicAuth basicAuth) {
            this.basicAuth = basicAuth;
            return this;
        }

        /**
         * Sets the value of {@link AutoBranchCreation#getBuildSpec}
         * @param buildSpec Build spec for the auto created branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildSpec(software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link AutoBranchCreation#getEnvironmentVariables}
         * @param environmentVariables Environment variables for the auto created branch.
         *                             All environment variables that you add are encrypted to prevent rogue
         *                             access so you can use them to store secret information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link AutoBranchCreation#getPatterns}
         * @param patterns Automated branch creation glob patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder patterns(java.util.List<java.lang.String> patterns) {
            this.patterns = patterns;
            return this;
        }

        /**
         * Sets the value of {@link AutoBranchCreation#getPullRequestEnvironmentName}
         * @param pullRequestEnvironmentName The dedicated backend environment for the pull request previews of the auto created branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pullRequestEnvironmentName(java.lang.String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link AutoBranchCreation#getPullRequestPreview}
         * @param pullRequestPreview Whether to enable pull request preview for the auto created branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pullRequestPreview(java.lang.Boolean pullRequestPreview) {
            this.pullRequestPreview = pullRequestPreview;
            return this;
        }

        /**
         * Sets the value of {@link AutoBranchCreation#getStage}
         * @param stage Stage for the auto created branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stage(java.lang.String stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoBranchCreation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AutoBranchCreation build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AutoBranchCreation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoBranchCreation {
        private final java.lang.Boolean autoBuild;
        private final software.amazon.awscdk.services.amplify.BasicAuth basicAuth;
        private final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private final java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        private final java.util.List<java.lang.String> patterns;
        private final java.lang.String pullRequestEnvironmentName;
        private final java.lang.Boolean pullRequestPreview;
        private final java.lang.String stage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoBuild = software.amazon.jsii.Kernel.get(this, "autoBuild", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.basicAuth = software.amazon.jsii.Kernel.get(this, "basicAuth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.BasicAuth.class));
            this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.patterns = software.amazon.jsii.Kernel.get(this, "patterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.pullRequestEnvironmentName = software.amazon.jsii.Kernel.get(this, "pullRequestEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pullRequestPreview = software.amazon.jsii.Kernel.get(this, "pullRequestPreview", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoBuild = builder.autoBuild;
            this.basicAuth = builder.basicAuth;
            this.buildSpec = builder.buildSpec;
            this.environmentVariables = builder.environmentVariables;
            this.patterns = builder.patterns;
            this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
            this.pullRequestPreview = builder.pullRequestPreview;
            this.stage = builder.stage;
        }

        @Override
        public final java.lang.Boolean getAutoBuild() {
            return this.autoBuild;
        }

        @Override
        public final software.amazon.awscdk.services.amplify.BasicAuth getBasicAuth() {
            return this.basicAuth;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.util.List<java.lang.String> getPatterns() {
            return this.patterns;
        }

        @Override
        public final java.lang.String getPullRequestEnvironmentName() {
            return this.pullRequestEnvironmentName;
        }

        @Override
        public final java.lang.Boolean getPullRequestPreview() {
            return this.pullRequestPreview;
        }

        @Override
        public final java.lang.String getStage() {
            return this.stage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoBuild() != null) {
                data.set("autoBuild", om.valueToTree(this.getAutoBuild()));
            }
            if (this.getBasicAuth() != null) {
                data.set("basicAuth", om.valueToTree(this.getBasicAuth()));
            }
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getPatterns() != null) {
                data.set("patterns", om.valueToTree(this.getPatterns()));
            }
            if (this.getPullRequestEnvironmentName() != null) {
                data.set("pullRequestEnvironmentName", om.valueToTree(this.getPullRequestEnvironmentName()));
            }
            if (this.getPullRequestPreview() != null) {
                data.set("pullRequestPreview", om.valueToTree(this.getPullRequestPreview()));
            }
            if (this.getStage() != null) {
                data.set("stage", om.valueToTree(this.getStage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_amplify.AutoBranchCreation"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoBranchCreation.Jsii$Proxy that = (AutoBranchCreation.Jsii$Proxy) o;

            if (this.autoBuild != null ? !this.autoBuild.equals(that.autoBuild) : that.autoBuild != null) return false;
            if (this.basicAuth != null ? !this.basicAuth.equals(that.basicAuth) : that.basicAuth != null) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.patterns != null ? !this.patterns.equals(that.patterns) : that.patterns != null) return false;
            if (this.pullRequestEnvironmentName != null ? !this.pullRequestEnvironmentName.equals(that.pullRequestEnvironmentName) : that.pullRequestEnvironmentName != null) return false;
            if (this.pullRequestPreview != null ? !this.pullRequestPreview.equals(that.pullRequestPreview) : that.pullRequestPreview != null) return false;
            return this.stage != null ? this.stage.equals(that.stage) : that.stage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoBuild != null ? this.autoBuild.hashCode() : 0;
            result = 31 * result + (this.basicAuth != null ? this.basicAuth.hashCode() : 0);
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.patterns != null ? this.patterns.hashCode() : 0);
            result = 31 * result + (this.pullRequestEnvironmentName != null ? this.pullRequestEnvironmentName.hashCode() : 0);
            result = 31 * result + (this.pullRequestPreview != null ? this.pullRequestPreview.hashCode() : 0);
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            return result;
        }
    }
}
