package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Basic Auth configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp = App.Builder.create(this, "MyApp")
 *         .sourceCodeProvider(GitHubSourceCodeProvider.Builder.create()
 *                 .owner("&lt;user&gt;")
 *                 .repository("&lt;repo&gt;")
 *                 .oauthToken(SecretValue.secretsManager("my-github-token"))
 *                 .build())
 *         .basicAuth(BasicAuth.fromGeneratedPassword("username"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.815Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.BasicAuth")
public class BasicAuth extends software.amazon.jsii.JsiiObject {

    protected BasicAuth(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BasicAuth(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public BasicAuth(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.BasicAuthProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Creates a Basic Auth configuration from a username and a password.
     * <p>
     * @param username The username. This parameter is required.
     * @param password The password. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.BasicAuth fromCredentials(final @org.jetbrains.annotations.NotNull java.lang.String username, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue password) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.amplify.BasicAuth.class, "fromCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.BasicAuth.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required"), java.util.Objects.requireNonNull(password, "password is required") });
    }

    /**
     * (experimental) Creates a Basic Auth configuration with a password generated in Secrets Manager.
     * <p>
     * @param username The username. This parameter is required.
     * @param encryptionKey The encryption key to use to encrypt the password in Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.BasicAuth fromGeneratedPassword(final @org.jetbrains.annotations.NotNull java.lang.String username, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey encryptionKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.amplify.BasicAuth.class, "fromGeneratedPassword", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.BasicAuth.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required"), encryptionKey });
    }

    /**
     * (experimental) Creates a Basic Auth configuration with a password generated in Secrets Manager.
     * <p>
     * @param username The username. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.BasicAuth fromGeneratedPassword(final @org.jetbrains.annotations.NotNull java.lang.String username) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.amplify.BasicAuth.class, "fromGeneratedPassword", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.BasicAuth.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required") });
    }

    /**
     * (experimental) Binds this Basic Auth configuration to an App.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.BasicAuthConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.BasicAuthConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.amplify.BasicAuth}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplify.BasicAuth> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.amplify.BasicAuthProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.amplify.BasicAuthProps.Builder();
        }

        /**
         * (experimental) The username.
         * <p>
         * @return {@code this}
         * @param username The username. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * (experimental) The encryption key to use to encrypt the password when it's generated in Secrets Manager.
         * <p>
         * Default: - default master key
         * <p>
         * @return {@code this}
         * @param encryptionKey The encryption key to use to encrypt the password when it's generated in Secrets Manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * (experimental) The password.
         * <p>
         * Default: - A Secrets Manager generated password
         * <p>
         * @return {@code this}
         * @param password The password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder password(final software.amazon.awscdk.core.SecretValue password) {
            this.props.password(password);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.amplify.BasicAuth}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.amplify.BasicAuth build() {
            return new software.amazon.awscdk.services.amplify.BasicAuth(
                this.props.build()
            );
        }
    }
}
