package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Properties for a GitLab source code provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp = App.Builder.create(this, "MyApp")
 *         .sourceCodeProvider(GitLabSourceCodeProvider.Builder.create()
 *                 .owner("&lt;user&gt;")
 *                 .repository("&lt;repo&gt;")
 *                 .oauthToken(SecretValue.secretsManager("my-gitlab-token"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.880Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.GitLabSourceCodeProviderProps")
@software.amazon.jsii.Jsii.Proxy(GitLabSourceCodeProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GitLabSourceCodeProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A personal access token with the `repo` scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue getOauthToken();

    /**
     * (experimental) The user or organization owning the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getOwner();

    /**
     * (experimental) The name of the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getRepository();

    /**
     * @return a {@link Builder} of {@link GitLabSourceCodeProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitLabSourceCodeProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GitLabSourceCodeProviderProps> {
        software.amazon.awscdk.core.SecretValue oauthToken;
        java.lang.String owner;
        java.lang.String repository;

        /**
         * Sets the value of {@link GitLabSourceCodeProviderProps#getOauthToken}
         * @param oauthToken A personal access token with the `repo` scope. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder oauthToken(software.amazon.awscdk.core.SecretValue oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        /**
         * Sets the value of {@link GitLabSourceCodeProviderProps#getOwner}
         * @param owner The user or organization owning the repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link GitLabSourceCodeProviderProps#getRepository}
         * @param repository The name of the repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repository(java.lang.String repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitLabSourceCodeProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GitLabSourceCodeProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitLabSourceCodeProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitLabSourceCodeProviderProps {
        private final software.amazon.awscdk.core.SecretValue oauthToken;
        private final java.lang.String owner;
        private final java.lang.String repository;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.oauthToken = software.amazon.jsii.Kernel.get(this, "oauthToken", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.oauthToken = java.util.Objects.requireNonNull(builder.oauthToken, "oauthToken is required");
            this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
            this.repository = java.util.Objects.requireNonNull(builder.repository, "repository is required");
        }

        @Override
        public final software.amazon.awscdk.core.SecretValue getOauthToken() {
            return this.oauthToken;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.lang.String getRepository() {
            return this.repository;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("oauthToken", om.valueToTree(this.getOauthToken()));
            data.set("owner", om.valueToTree(this.getOwner()));
            data.set("repository", om.valueToTree(this.getRepository()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_amplify.GitLabSourceCodeProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitLabSourceCodeProviderProps.Jsii$Proxy that = (GitLabSourceCodeProviderProps.Jsii$Proxy) o;

            if (!oauthToken.equals(that.oauthToken)) return false;
            if (!owner.equals(that.owner)) return false;
            return this.repository.equals(that.repository);
        }

        @Override
        public final int hashCode() {
            int result = this.oauthToken.hashCode();
            result = 31 * result + (this.owner.hashCode());
            result = 31 * result + (this.repository.hashCode());
            return result;
        }
    }
}
