package software.amazon.awscdk.services.apigateway;

/**
 * (experimental) Options to add gateway response.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api = new RestApi(this, "books-api");
 * api.addGatewayResponse("test-response", GatewayResponseOptions.builder()
 *         .type(ResponseType.ACCESS_DENIED)
 *         .statusCode("500")
 *         .responseHeaders(Map.of(
 *                 "Access-Control-Allow-Origin", "test.com",
 *                 "test-key", "test-value"))
 *         .templates(Map.of(
 *                 "application/json", "{ \"message\": $context.error.messageString, \"statusCode\": \"488\", \"type\": \"$context.error.responseType\" }"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:52.374Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigateway.GatewayResponseOptions")
@software.amazon.jsii.Jsii.Proxy(GatewayResponseOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GatewayResponseOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Response type to associate with gateway response.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ResponseType getType();

    /**
     * (experimental) Custom headers parameters for response.
     * <p>
     * Default: - no headers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getResponseHeaders() {
        return null;
    }

    /**
     * (experimental) Http status code for response.
     * <p>
     * Default: - standard http status code for the response type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatusCode() {
        return null;
    }

    /**
     * (experimental) Custom templates to get mapped as response.
     * <p>
     * Default: - Response from api will be returned without applying any transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTemplates() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GatewayResponseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayResponseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayResponseOptions> {
        software.amazon.awscdk.services.apigateway.ResponseType type;
        java.util.Map<java.lang.String, java.lang.String> responseHeaders;
        java.lang.String statusCode;
        java.util.Map<java.lang.String, java.lang.String> templates;

        /**
         * Sets the value of {@link GatewayResponseOptions#getType}
         * @param type Response type to associate with gateway response. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(software.amazon.awscdk.services.apigateway.ResponseType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link GatewayResponseOptions#getResponseHeaders}
         * @param responseHeaders Custom headers parameters for response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responseHeaders(java.util.Map<java.lang.String, java.lang.String> responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        /**
         * Sets the value of {@link GatewayResponseOptions#getStatusCode}
         * @param statusCode Http status code for response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder statusCode(java.lang.String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Sets the value of {@link GatewayResponseOptions#getTemplates}
         * @param templates Custom templates to get mapped as response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder templates(java.util.Map<java.lang.String, java.lang.String> templates) {
            this.templates = templates;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayResponseOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GatewayResponseOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GatewayResponseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayResponseOptions {
        private final software.amazon.awscdk.services.apigateway.ResponseType type;
        private final java.util.Map<java.lang.String, java.lang.String> responseHeaders;
        private final java.lang.String statusCode;
        private final java.util.Map<java.lang.String, java.lang.String> templates;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
            this.responseHeaders = software.amazon.jsii.Kernel.get(this, "responseHeaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templates = software.amazon.jsii.Kernel.get(this, "templates", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.responseHeaders = builder.responseHeaders;
            this.statusCode = builder.statusCode;
            this.templates = builder.templates;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ResponseType getType() {
            return this.type;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getResponseHeaders() {
            return this.responseHeaders;
        }

        @Override
        public final java.lang.String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTemplates() {
            return this.templates;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getResponseHeaders() != null) {
                data.set("responseHeaders", om.valueToTree(this.getResponseHeaders()));
            }
            if (this.getStatusCode() != null) {
                data.set("statusCode", om.valueToTree(this.getStatusCode()));
            }
            if (this.getTemplates() != null) {
                data.set("templates", om.valueToTree(this.getTemplates()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apigateway.GatewayResponseOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayResponseOptions.Jsii$Proxy that = (GatewayResponseOptions.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.responseHeaders != null ? !this.responseHeaders.equals(that.responseHeaders) : that.responseHeaders != null) return false;
            if (this.statusCode != null ? !this.statusCode.equals(that.statusCode) : that.statusCode != null) return false;
            return this.templates != null ? this.templates.equals(that.templates) : that.templates == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.responseHeaders != null ? this.responseHeaders.hashCode() : 0);
            result = 31 * result + (this.statusCode != null ? this.statusCode.hashCode() : 0);
            result = 31 * result + (this.templates != null ? this.templates.hashCode() : 0);
            return result;
        }
    }
}
