package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Vpc vpc = new Vpc(this, "VPC");
 * NetworkLoadBalancer nlb = NetworkLoadBalancer.Builder.create(this, "NLB")
 *         .vpc(vpc)
 *         .build();
 * VpcLink link = VpcLink.Builder.create(this, "link")
 *         .targets(List.of(nlb))
 *         .build();
 * Integration integration = Integration.Builder.create()
 *         .type(IntegrationType.HTTP_PROXY)
 *         .options(IntegrationOptions.builder()
 *                 .connectionType(ConnectionType.VPC_LINK)
 *                 .vpcLink(link)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:52.419Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigateway.IntegrationType")
public enum IntegrationType {
    /**
     * (experimental) For integrating the API method request with an AWS service action, including the Lambda function-invoking action.
     * <p>
     * With the Lambda
     * function-invoking action, this is referred to as the Lambda custom
     * integration. With any other AWS service action, this is known as AWS
     * integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AWS,
    /**
     * (experimental) For integrating the API method request with the Lambda function-invoking action with the client request passed through as-is.
     * <p>
     * This integration is
     * also referred to as the Lambda proxy integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AWS_PROXY,
    /**
     * (experimental) For integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC.
     * <p>
     * This integration is also referred to
     * as the HTTP custom integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HTTP,
    /**
     * (experimental) For integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is.
     * <p>
     * This is also referred to as the HTTP proxy integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HTTP_PROXY,
    /**
     * (experimental) For integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MOCK,
}
