package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * // We define the JSON Schema for the transformed valid response
 * Model responseModel = api.addModel("ResponseModel", ModelOptions.builder()
 *         .contentType("application/json")
 *         .modelName("ResponseModel")
 *         .schema(JsonSchema.builder()
 *                 .schema(JsonSchemaVersion.DRAFT4)
 *                 .title("pollResponse")
 *                 .type(JsonSchemaType.OBJECT)
 *                 .properties(Map.of(
 *                         "state", JsonSchema.builder().type(JsonSchemaType.STRING).build(),
 *                         "greeting", JsonSchema.builder().type(JsonSchemaType.STRING).build()))
 *                 .build())
 *         .build());
 * // We define the JSON Schema for the transformed error response
 * Model errorResponseModel = api.addModel("ErrorResponseModel", ModelOptions.builder()
 *         .contentType("application/json")
 *         .modelName("ErrorResponseModel")
 *         .schema(JsonSchema.builder()
 *                 .schema(JsonSchemaVersion.DRAFT4)
 *                 .title("errorResponse")
 *                 .type(JsonSchemaType.OBJECT)
 *                 .properties(Map.of(
 *                         "state", JsonSchema.builder().type(JsonSchemaType.STRING).build(),
 *                         "message", JsonSchema.builder().type(JsonSchemaType.STRING).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:52.425Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigateway.JsonSchemaVersion")
public enum JsonSchemaVersion {
    /**
     * (experimental) In API Gateway models are defined using the JSON schema draft 4.
     * <p>
     * @see <a href="https://tools.ietf.org/html/draft-zyp-json-schema-04">https://tools.ietf.org/html/draft-zyp-json-schema-04</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DRAFT4,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DRAFT7,
}
