package software.amazon.awscdk.services.apigateway;

/**
 * (experimental) Options to integrate with various StepFunction API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * StateMachine stateMachine = StateMachine.Builder.create(this, "MyStateMachine")
 *         .stateMachineType(StateMachineType.EXPRESS)
 *         .definition(Chain.start(new Pass(this, "Pass")))
 *         .build();
 * RestApi api = RestApi.Builder.create(this, "Api")
 *         .restApiName("MyApi")
 *         .build();
 * api.root.addMethod("GET", StepFunctionsIntegration.startExecution(stateMachine));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:52.541Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigateway.StepFunctionsIntegration")
public class StepFunctionsIntegration extends software.amazon.jsii.JsiiObject {

    protected StepFunctionsIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StepFunctionsIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public StepFunctionsIntegration() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Integrates a Synchronous Express State Machine from AWS Step Functions to an API Gateway method.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * StateMachine stateMachine = StateMachine.Builder.create(this, "MyStateMachine")
     *         .stateMachineType(StateMachineType.EXPRESS)
     *         .definition(Chain.start(new Pass(this, "Pass")))
     *         .build();
     * RestApi api = RestApi.Builder.create(this, "Api")
     *         .restApiName("MyApi")
     *         .build();
     * api.root.addMethod("GET", StepFunctionsIntegration.startExecution(stateMachine));
     * </pre></blockquote>
     * <p>
     * @param stateMachine This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AwsIntegration startExecution(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.StepFunctionsExecutionIntegrationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.StepFunctionsIntegration.class, "startExecution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AwsIntegration.class), new Object[] { java.util.Objects.requireNonNull(stateMachine, "stateMachine is required"), options });
    }

    /**
     * (experimental) Integrates a Synchronous Express State Machine from AWS Step Functions to an API Gateway method.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * StateMachine stateMachine = StateMachine.Builder.create(this, "MyStateMachine")
     *         .stateMachineType(StateMachineType.EXPRESS)
     *         .definition(Chain.start(new Pass(this, "Pass")))
     *         .build();
     * RestApi api = RestApi.Builder.create(this, "Api")
     *         .restApiName("MyApi")
     *         .build();
     * api.root.addMethod("GET", StepFunctionsIntegration.startExecution(stateMachine));
     * </pre></blockquote>
     * <p>
     * @param stateMachine This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AwsIntegration startExecution(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.StepFunctionsIntegration.class, "startExecution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AwsIntegration.class), new Object[] { java.util.Objects.requireNonNull(stateMachine, "stateMachine is required") });
    }
}
