package software.amazon.awscdk.services.apigatewayv2;

/**
 * (experimental) Represents a Parameter Mapping.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpAlbIntegration;
 * ApplicationLoadBalancer lb;
 * ApplicationListener listener = lb.addListener("listener", BaseApplicationListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddApplicationTargetsProps.builder()
 *         .port(80)
 *         .build());
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpAlbIntegration.Builder.create("DefaultIntegration", listener)
 *                 .parameterMapping(new ParameterMapping().appendHeader("header2", MappingValue.requestHeader("header1")).removeHeader("header1"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:52.792Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigatewayv2.ParameterMapping")
public class ParameterMapping extends software.amazon.jsii.JsiiObject {

    protected ParameterMapping(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ParameterMapping(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ParameterMapping() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Creates a mapping from an object.
     * <p>
     * @param obj This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.ParameterMapping fromObject(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.apigatewayv2.MappingValue> obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class), new Object[] { java.util.Objects.requireNonNull(obj, "obj is required") });
    }

    /**
     * (experimental) Creates a mapping to append a header.
     * <p>
     * @param name This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.ParameterMapping appendHeader(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.MappingValue value) {
        return software.amazon.jsii.Kernel.call(this, "appendHeader", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Creates a mapping to append a query string.
     * <p>
     * @param name This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.ParameterMapping appendQueryString(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.MappingValue value) {
        return software.amazon.jsii.Kernel.call(this, "appendQueryString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Creates a custom mapping.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.ParameterMapping custom(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.Kernel.call(this, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Creates a mapping to overwrite a header.
     * <p>
     * @param name This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.ParameterMapping overwriteHeader(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.MappingValue value) {
        return software.amazon.jsii.Kernel.call(this, "overwriteHeader", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Creates a mapping to overwrite a path.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.ParameterMapping overwritePath(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.MappingValue value) {
        return software.amazon.jsii.Kernel.call(this, "overwritePath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Creates a mapping to overwrite a querystring.
     * <p>
     * @param name This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.ParameterMapping overwriteQueryString(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.MappingValue value) {
        return software.amazon.jsii.Kernel.call(this, "overwriteQueryString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Creates a mapping to remove a header.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.ParameterMapping removeHeader(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.Kernel.call(this, "removeHeader", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Creates a mapping to remove a querystring.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.ParameterMapping removeQueryString(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.Kernel.call(this, "removeQueryString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Represents all created parameter mappings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getMappings() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "mappings", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }
}
