package software.amazon.awscdk.services.apigatewayv2.authorizers;

/**
 * (experimental) Authorize HTTP API Routes with IAM.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.authorizers.HttpIamAuthorizer;
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegration;
 * AnyPrincipal principal;
 * HttpIamAuthorizer authorizer = new HttpIamAuthorizer();
 * HttpApi httpApi = HttpApi.Builder.create(this, "HttpApi")
 *         .defaultAuthorizer(authorizer)
 *         .build();
 * HttpRoute[] routes = httpApi.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.myproxy.internal"))
 *         .path("/books/{book}")
 *         .build());
 * routes[0].grantInvoke(principal);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:52.839Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigatewayv2_authorizers.HttpIamAuthorizer")
public class HttpIamAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer {

    protected HttpIamAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpIamAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpIamAuthorizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Bind this authorizer to a specified Http route.
     * <p>
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(_options, "_options is required") });
    }
}
