package software.amazon.awscdk.services.apigatewayv2.integrations;

/**
 * (experimental) The Network Load Balancer integration resource for HTTP API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegration;
 * Vpc vpc = new Vpc(this, "VPC");
 * NetworkLoadBalancer lb = NetworkLoadBalancer.Builder.create(this, "lb").vpc(vpc).build();
 * NetworkListener listener = lb.addListener("listener", BaseNetworkListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddNetworkTargetsProps.builder()
 *         .port(80)
 *         .build());
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(new HttpNlbIntegration("DefaultIntegration", listener))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:52.867Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigatewayv2_integrations.HttpNlbIntegration")
public class HttpNlbIntegration extends software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration {

    protected HttpNlbIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpNlbIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param listener the ELB network listener. This parameter is required.
     * @param props properties to configure the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpNlbIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener listener, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(listener, "listener is required"), props });
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param listener the ELB network listener. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpNlbIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener listener) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * (experimental) Bind this integration to the route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpConnectionType getConnectionType() {
        return software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpConnectionType.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setConnectionType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpConnectionType value) {
        software.amazon.jsii.Kernel.set(this, "connectionType", java.util.Objects.requireNonNull(value, "connectionType is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpMethod getHttpMethod() {
        return software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpMethod.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setHttpMethod(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpMethod value) {
        software.amazon.jsii.Kernel.set(this, "httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType getIntegrationType() {
        return software.amazon.jsii.Kernel.get(this, "integrationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setIntegrationType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType value) {
        software.amazon.jsii.Kernel.set(this, "integrationType", java.util.Objects.requireNonNull(value, "integrationType is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion getPayloadFormatVersion() {
        return software.amazon.jsii.Kernel.get(this, "payloadFormatVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setPayloadFormatVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion value) {
        software.amazon.jsii.Kernel.set(this, "payloadFormatVersion", java.util.Objects.requireNonNull(value, "payloadFormatVersion is required"));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id id of the underlying integration construct. This parameter is required.
         * @param listener the ELB network listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener listener) {
            return new Builder(id, listener);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener listener;
        private software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegrationProps.Builder props;

        private Builder(final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener listener) {
            this.id = id;
            this.listener = listener;
        }

        /**
         * (experimental) The HTTP method that must be used to invoke the underlying HTTP proxy.
         * <p>
         * Default: HttpMethod.ANY
         * <p>
         * @return {@code this}
         * @param method The HTTP method that must be used to invoke the underlying HTTP proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder method(final software.amazon.awscdk.services.apigatewayv2.HttpMethod method) {
            this.props().method(method);
            return this;
        }

        /**
         * (experimental) Specifies how to transform HTTP requests before sending them to the backend.
         * <p>
         * Default: undefined requests are sent to the backend unmodified
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterMapping(final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.props().parameterMapping(parameterMapping);
            return this;
        }

        /**
         * (experimental) Specifies the server name to verified by HTTPS when calling the backend integration.
         * <p>
         * Default: undefined private integration traffic will use HTTP protocol
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html</a>
         * @param secureServerName Specifies the server name to verified by HTTPS when calling the backend integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secureServerName(final java.lang.String secureServerName) {
            this.props().secureServerName(secureServerName);
            return this;
        }

        /**
         * (experimental) The vpc link to be used for the private integration.
         * <p>
         * Default: - a new VpcLink is created
         * <p>
         * @return {@code this}
         * @param vpcLink The vpc link to be used for the private integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcLink(final software.amazon.awscdk.services.apigatewayv2.IVpcLink vpcLink) {
            this.props().vpcLink(vpcLink);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegration build() {
            return new software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegration(
                this.id,
                this.listener,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegrationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegrationProps.Builder();
            }
            return this.props;
        }
    }
}
