package software.amazon.awscdk.services.applicationautoscaling;

/**
 * (experimental) One of the predefined autoscaling metrics.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Code code;
 * Function handler = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.PYTHON_3_7)
 *         .handler("index.handler")
 *         .code(code)
 *         .reservedConcurrentExecutions(2)
 *         .build();
 * Version fnVer = handler.getCurrentVersion();
 * ScalableTarget target = ScalableTarget.Builder.create(this, "ScalableTarget")
 *         .serviceNamespace(ServiceNamespace.LAMBDA)
 *         .maxCapacity(100)
 *         .minCapacity(10)
 *         .resourceId(String.format("function:%s:%s", handler.getFunctionName(), fnVer.getVersion()))
 *         .scalableDimension("lambda:function:ProvisionedConcurrency")
 *         .build();
 * target.scaleToTrackMetric("PceTracking", BasicTargetTrackingScalingPolicyProps.builder()
 *         .targetValue(0.9)
 *         .predefinedMetric(PredefinedMetric.LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.208Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_applicationautoscaling.PredefinedMetric")
public enum PredefinedMetric {
    /**
     * (experimental) Average percentage of instances in an AppStream fleet that are being used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    APPSTREAM_AVERAGE_CAPACITY_UTILIZATION,
    /**
     * (experimental) Percentage of provisioned read capacity units utilized by a Keyspaces table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CASSANDRA_READ_CAPACITY_UTILIZATION,
    /**
     * (experimental) Percentage of provisioned write capacity units utilized by a Keyspaces table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CASSANDRA_WRITE_CAPACITY_UTILIZATION,
    /**
     * (experimental) Percentage of provisioned inference units utilized by a Comprehend endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPREHEND_INFERENCE_UTILIZATION,
    /**
     * (experimental) Average CPU Utilization of read replica instances in a Neptune DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NEPTURE_READER_AVERAGE_CPU_UTILIZATION,
    /**
     * (experimental) Percentage of provisioned read capacity units consumed by a DynamoDB table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DYNAMODB_READ_CAPACITY_UTILIZATION,
    /**
     * (experimental) Percentage of provisioned write capacity units consumed by a DynamoDB table.
     * <p>
     * Suffix <code>dummy</code> is necessary due to jsii bug (https://github.com/aws/jsii/issues/2782).
     * Duplicate values will be dropped, so this suffix is added as a workaround.
     * The value will be replaced when this enum is used.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DYNAMODB_WRITE_CAPACITY_UTILIZATION,
    /**
     * (deprecated) DYANMODB_WRITE_CAPACITY_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     * @deprecated use `PredefinedMetric.DYNAMODB_WRITE_CAPACITY_UTILIZATION`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    DYANMODB_WRITE_CAPACITY_UTILIZATION,
    /**
     * (experimental) ALB_REQUEST_COUNT_PER_TARGET.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ALB_REQUEST_COUNT_PER_TARGET,
    /**
     * (experimental) RDS_READER_AVERAGE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    RDS_READER_AVERAGE_CPU_UTILIZATION,
    /**
     * (experimental) RDS_READER_AVERAGE_DATABASE_CONNECTIONS.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    RDS_READER_AVERAGE_DATABASE_CONNECTIONS,
    /**
     * (experimental) EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION,
    /**
     * (experimental) EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN,
    /**
     * (experimental) EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT,
    /**
     * (experimental) SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE,
    /**
     * (experimental) ECS_SERVICE_AVERAGE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ECS_SERVICE_AVERAGE_CPU_UTILIZATION,
    /**
     * (experimental) ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION,
    /**
     * (experimental) LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency">https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION,
    /**
     * (experimental) KAFKA_BROKER_STORAGE_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    KAFKA_BROKER_STORAGE_UTILIZATION,
    /**
     * (experimental) ELASTIC_CACHE_PRIMARY_ENGINE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION,
    /**
     * (experimental) ELASTIC_CACHE_REPLICA_ENGINE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ELASTICACHE_REPLICA_ENGINE_CPU_UTILIZATION,
    /**
     * (experimental) ELASTIC_CACHE_REPLICA_ENGINE_CPU_UTILIZATION.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ELASTICACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE,
}
