package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Represents a TLS certificate that is supported for mutual TLS authentication.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * VirtualNode node1 = VirtualNode.Builder.create(this, "node1")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.dns("node"))
 *         .listeners(List.of(VirtualNodeListener.grpc(GrpcVirtualNodeListenerOptions.builder()
 *                 .port(80)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.file("path/to/certChain", "path/to/privateKey"))
 *                         // Validate a file client certificates to enable mutual TLS authentication when a client provides a certificate.
 *                         .mutualTlsValidation(MutualTlsValidation.builder()
 *                                 .trust(TlsValidationTrust.file("path-to-certificate"))
 *                                 .build())
 *                         .build())
 *                 .build())))
 *         .build();
 * String certificateAuthorityArn = "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012";
 * VirtualNode node2 = VirtualNode.Builder.create(this, "node2")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.dns("node2"))
 *         .backendDefaults(BackendDefaults.builder()
 *                 .tlsClientPolicy(TlsClientPolicy.builder()
 *                         .ports(List.of(8080, 8081))
 *                         .validation(TlsValidation.builder()
 *                                 .subjectAlternativeNames(SubjectAlternativeNames.matchingExactly("mesh-endpoint.apps.local"))
 *                                 .trust(TlsValidationTrust.acm(List.of(CertificateAuthority.fromCertificateAuthorityArn(this, "certificate", certificateAuthorityArn))))
 *                                 .build())
 *                         // Provide a SDS client certificate when a server requests it and enable mutual TLS authentication.
 *                         .mutualTlsCertificate(TlsCertificate.sds("secret_certificate"))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.714Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.MutualTlsCertificate")
public abstract class MutualTlsCertificate extends software.amazon.awscdk.services.appmesh.TlsCertificate {

    protected MutualTlsCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MutualTlsCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected MutualTlsCertificate() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getDifferentiator() {
        return software.amazon.jsii.Kernel.get(this, "differentiator", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.MutualTlsCertificate {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Returns TLS certificate based provider.
         * <p>
         * @param _scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsCertificateConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsCertificateConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
        }
    }
}
