package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Properties of the image repository for `Source.fromAsset()`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * DockerImageAsset imageAsset = DockerImageAsset.Builder.create(this, "ImageAssets")
 *         .directory(join(__dirname, "./docker.assets"))
 *         .build();
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromAsset(AssetProps.builder()
 *                 .imageConfiguration(ImageConfiguration.builder().port(8000).build())
 *                 .asset(imageAsset)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.822Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.AssetProps")
@software.amazon.jsii.Jsii.Proxy(AssetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AssetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Represents the docker image asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAsset getAsset();

    /**
     * (experimental) The image configuration for the image built from the asset.
     * <p>
     * Default: - no image configuration will be passed. The default `port` will be 8080.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.ImageConfiguration getImageConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AssetProps> {
        software.amazon.awscdk.services.ecr.assets.DockerImageAsset asset;
        software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration;

        /**
         * Sets the value of {@link AssetProps#getAsset}
         * @param asset Represents the docker image asset. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder asset(software.amazon.awscdk.services.ecr.assets.DockerImageAsset asset) {
            this.asset = asset;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getImageConfiguration}
         * @param imageConfiguration The image configuration for the image built from the asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageConfiguration(software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AssetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetProps {
        private final software.amazon.awscdk.services.ecr.assets.DockerImageAsset asset;
        private final software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.asset = software.amazon.jsii.Kernel.get(this, "asset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.DockerImageAsset.class));
            this.imageConfiguration = software.amazon.jsii.Kernel.get(this, "imageConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.ImageConfiguration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.asset = java.util.Objects.requireNonNull(builder.asset, "asset is required");
            this.imageConfiguration = builder.imageConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.assets.DockerImageAsset getAsset() {
            return this.asset;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.ImageConfiguration getImageConfiguration() {
            return this.imageConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("asset", om.valueToTree(this.getAsset()));
            if (this.getImageConfiguration() != null) {
                data.set("imageConfiguration", om.valueToTree(this.getImageConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.AssetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetProps.Jsii$Proxy that = (AssetProps.Jsii$Proxy) o;

            if (!asset.equals(that.asset)) return false;
            return this.imageConfiguration != null ? this.imageConfiguration.equals(that.imageConfiguration) : that.imageConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.asset.hashCode();
            result = 31 * result + (this.imageConfiguration != null ? this.imageConfiguration.hashCode() : 0);
            return result;
        }
    }
}
