package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Describes the configuration that AWS App Runner uses to build and run an App Runner service from a source code repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * Runtime runtime;
 * CodeConfiguration codeConfiguration = CodeConfiguration.builder()
 *         .configurationSource(ConfigurationSourceType.REPOSITORY)
 *         // the properties below are optional
 *         .configurationValues(CodeConfigurationValues.builder()
 *                 .runtime(runtime)
 *                 // the properties below are optional
 *                 .buildCommand("buildCommand")
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .port("port")
 *                 .startCommand("startCommand")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.888Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.CodeConfiguration")
@software.amazon.jsii.Jsii.Proxy(CodeConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CodeConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The source of the App Runner configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.ConfigurationSourceType getConfigurationSource();

    /**
     * (experimental) The basic configuration for building and running the App Runner service.
     * <p>
     * Use it to quickly launch an App Runner service without providing a apprunner.yaml file in the
     * source code repository (or ignoring the file if it exists).
     * <p>
     * Default: - not specified. Use `apprunner.yaml` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CodeConfigurationValues getConfigurationValues() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CodeConfiguration> {
        software.amazon.awscdk.services.apprunner.ConfigurationSourceType configurationSource;
        software.amazon.awscdk.services.apprunner.CodeConfigurationValues configurationValues;

        /**
         * Sets the value of {@link CodeConfiguration#getConfigurationSource}
         * @param configurationSource The source of the App Runner configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configurationSource(software.amazon.awscdk.services.apprunner.ConfigurationSourceType configurationSource) {
            this.configurationSource = configurationSource;
            return this;
        }

        /**
         * Sets the value of {@link CodeConfiguration#getConfigurationValues}
         * @param configurationValues The basic configuration for building and running the App Runner service.
         *                            Use it to quickly launch an App Runner service without providing a apprunner.yaml file in the
         *                            source code repository (or ignoring the file if it exists).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configurationValues(software.amazon.awscdk.services.apprunner.CodeConfigurationValues configurationValues) {
            this.configurationValues = configurationValues;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CodeConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeConfiguration {
        private final software.amazon.awscdk.services.apprunner.ConfigurationSourceType configurationSource;
        private final software.amazon.awscdk.services.apprunner.CodeConfigurationValues configurationValues;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurationSource = software.amazon.jsii.Kernel.get(this, "configurationSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.ConfigurationSourceType.class));
            this.configurationValues = software.amazon.jsii.Kernel.get(this, "configurationValues", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.CodeConfigurationValues.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurationSource = java.util.Objects.requireNonNull(builder.configurationSource, "configurationSource is required");
            this.configurationValues = builder.configurationValues;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.ConfigurationSourceType getConfigurationSource() {
            return this.configurationSource;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.CodeConfigurationValues getConfigurationValues() {
            return this.configurationValues;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configurationSource", om.valueToTree(this.getConfigurationSource()));
            if (this.getConfigurationValues() != null) {
                data.set("configurationValues", om.valueToTree(this.getConfigurationValues()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.CodeConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeConfiguration.Jsii$Proxy that = (CodeConfiguration.Jsii$Proxy) o;

            if (!configurationSource.equals(that.configurationSource)) return false;
            return this.configurationValues != null ? this.configurationValues.equals(that.configurationValues) : that.configurationValues == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configurationSource.hashCode();
            result = 31 * result + (this.configurationValues != null ? this.configurationValues.hashCode() : 0);
            return result;
        }
    }
}
