package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Describes the basic configuration needed for building and running an AWS App Runner service.
 * <p>
 * This type doesn't support the full set of possible configuration options. Fur full configuration capabilities,
 * use a <code>apprunner.yaml</code> file in the source code repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromGitHub(GithubRepositoryProps.builder()
 *                 .repositoryUrl("https://github.com/aws-containers/hello-app-runner")
 *                 .branch("main")
 *                 .configurationSource(ConfigurationSourceType.API)
 *                 .codeConfigurationValues(CodeConfigurationValues.builder()
 *                         .runtime(Runtime.PYTHON_3)
 *                         .port("8000")
 *                         .startCommand("python app.py")
 *                         .buildCommand("yum install -y pycairo &amp;&amp; pip install -r requirements.txt")
 *                         .build())
 *                 .connection(GitHubConnection.fromConnectionArn("CONNECTION_ARN"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.889Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.CodeConfigurationValues")
@software.amazon.jsii.Jsii.Proxy(CodeConfigurationValues.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CodeConfigurationValues extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A runtime environment type for building and running an App Runner service.
     * <p>
     * It represents
     * a programming language runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.Runtime getRuntime();

    /**
     * (experimental) The command App Runner runs to build your application.
     * <p>
     * Default: - no build command.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBuildCommand() {
        return null;
    }

    /**
     * (experimental) The environment variables that are available to your running App Runner service.
     * <p>
     * Default: - no environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * (experimental) The port that your application listens to in the container.
     * <p>
     * Default: 8080
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
        return null;
    }

    /**
     * (experimental) The command App Runner runs to start your application.
     * <p>
     * Default: - no start command.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getStartCommand() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeConfigurationValues}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeConfigurationValues}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CodeConfigurationValues> {
        software.amazon.awscdk.services.apprunner.Runtime runtime;
        java.lang.String buildCommand;
        java.util.Map<java.lang.String, java.lang.String> environment;
        java.lang.String port;
        java.lang.String startCommand;

        /**
         * Sets the value of {@link CodeConfigurationValues#getRuntime}
         * @param runtime A runtime environment type for building and running an App Runner service. This parameter is required.
         *                It represents
         *                a programming language runtime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(software.amazon.awscdk.services.apprunner.Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link CodeConfigurationValues#getBuildCommand}
         * @param buildCommand The command App Runner runs to build your application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildCommand(java.lang.String buildCommand) {
            this.buildCommand = buildCommand;
            return this;
        }

        /**
         * Sets the value of {@link CodeConfigurationValues#getEnvironment}
         * @param environment The environment variables that are available to your running App Runner service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CodeConfigurationValues#getPort}
         * @param port The port that your application listens to in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.String port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CodeConfigurationValues#getStartCommand}
         * @param startCommand The command App Runner runs to start your application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder startCommand(java.lang.String startCommand) {
            this.startCommand = startCommand;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeConfigurationValues}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CodeConfigurationValues build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeConfigurationValues}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeConfigurationValues {
        private final software.amazon.awscdk.services.apprunner.Runtime runtime;
        private final java.lang.String buildCommand;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.String port;
        private final java.lang.String startCommand;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.Runtime.class));
            this.buildCommand = software.amazon.jsii.Kernel.get(this, "buildCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startCommand = software.amazon.jsii.Kernel.get(this, "startCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.runtime = java.util.Objects.requireNonNull(builder.runtime, "runtime is required");
            this.buildCommand = builder.buildCommand;
            this.environment = builder.environment;
            this.port = builder.port;
            this.startCommand = builder.startCommand;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.Runtime getRuntime() {
            return this.runtime;
        }

        @Override
        public final java.lang.String getBuildCommand() {
            return this.buildCommand;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getStartCommand() {
            return this.startCommand;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("runtime", om.valueToTree(this.getRuntime()));
            if (this.getBuildCommand() != null) {
                data.set("buildCommand", om.valueToTree(this.getBuildCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getStartCommand() != null) {
                data.set("startCommand", om.valueToTree(this.getStartCommand()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.CodeConfigurationValues"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeConfigurationValues.Jsii$Proxy that = (CodeConfigurationValues.Jsii$Proxy) o;

            if (!runtime.equals(that.runtime)) return false;
            if (this.buildCommand != null ? !this.buildCommand.equals(that.buildCommand) : that.buildCommand != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            return this.startCommand != null ? this.startCommand.equals(that.startCommand) : that.startCommand == null;
        }

        @Override
        public final int hashCode() {
            int result = this.runtime.hashCode();
            result = 31 * result + (this.buildCommand != null ? this.buildCommand.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.startCommand != null ? this.startCommand.hashCode() : 0);
            return result;
        }
    }
}
