package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Represents the App Runner connection that enables the App Runner service to connect to a source repository.
 * <p>
 * It's required for GitHub code repositories.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromGitHub(GithubRepositoryProps.builder()
 *                 .repositoryUrl("https://github.com/aws-containers/hello-app-runner")
 *                 .branch("main")
 *                 .configurationSource(ConfigurationSourceType.REPOSITORY)
 *                 .connection(GitHubConnection.fromConnectionArn("CONNECTION_ARN"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.899Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.GitHubConnection")
public class GitHubConnection extends software.amazon.jsii.JsiiObject {

    protected GitHubConnection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GitHubConnection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public GitHubConnection(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * (experimental) Using existing App Runner connection by specifying the connection ARN.
     * <p>
     * @return Connection
     * @param arn connection ARN. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.GitHubConnection fromConnectionArn(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apprunner.GitHubConnection.class, "fromConnectionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.GitHubConnection.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * (experimental) The ARN of the Connection for App Runner service to connect to the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectionArn() {
        return software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
