package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Represents the service source from a Github repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * GitHubConnection gitHubConnection;
 * Runtime runtime;
 * GithubSource githubSource = GithubSource.Builder.create()
 *         .configurationSource(ConfigurationSourceType.REPOSITORY)
 *         .connection(gitHubConnection)
 *         .repositoryUrl("repositoryUrl")
 *         // the properties below are optional
 *         .branch("branch")
 *         .codeConfigurationValues(CodeConfigurationValues.builder()
 *                 .runtime(runtime)
 *                 // the properties below are optional
 *                 .buildCommand("buildCommand")
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .port("port")
 *                 .startCommand("startCommand")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.902Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.GithubSource")
public class GithubSource extends software.amazon.awscdk.services.apprunner.Source {

    protected GithubSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GithubSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public GithubSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.GithubRepositoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.SourceConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.SourceConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apprunner.GithubSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apprunner.GithubSource> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.apprunner.GithubRepositoryProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.apprunner.GithubRepositoryProps.Builder();
        }

        /**
         * (experimental) The source of the App Runner configuration.
         * <p>
         * @return {@code this}
         * @param configurationSource The source of the App Runner configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configurationSource(final software.amazon.awscdk.services.apprunner.ConfigurationSourceType configurationSource) {
            this.props.configurationSource(configurationSource);
            return this;
        }

        /**
         * (experimental) ARN of the connection to Github.
         * <p>
         * Only required for Github source.
         * <p>
         * @return {@code this}
         * @param connection ARN of the connection to Github. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(final software.amazon.awscdk.services.apprunner.GitHubConnection connection) {
            this.props.connection(connection);
            return this;
        }

        /**
         * (experimental) The location of the repository that contains the source code.
         * <p>
         * @return {@code this}
         * @param repositoryUrl The location of the repository that contains the source code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repositoryUrl(final java.lang.String repositoryUrl) {
            this.props.repositoryUrl(repositoryUrl);
            return this;
        }

        /**
         * (experimental) The branch name that represents a specific version for the repository.
         * <p>
         * Default: main
         * <p>
         * @return {@code this}
         * @param branch The branch name that represents a specific version for the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder branch(final java.lang.String branch) {
            this.props.branch(branch);
            return this;
        }

        /**
         * (experimental) The code configuration values.
         * <p>
         * Will be ignored if configurationSource is <code>REPOSITORY</code>.
         * <p>
         * Default: - no values will be passed. The `apprunner.yaml` from the github reopsitory will be used instead.
         * <p>
         * @return {@code this}
         * @param codeConfigurationValues The code configuration values. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeConfigurationValues(final software.amazon.awscdk.services.apprunner.CodeConfigurationValues codeConfigurationValues) {
            this.props.codeConfigurationValues(codeConfigurationValues);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apprunner.GithubSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apprunner.GithubSource build() {
            return new software.amazon.awscdk.services.apprunner.GithubSource(
                this.props.build()
            );
        }
    }
}
