package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Represents the App Runner service source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * DockerImageAsset imageAsset = DockerImageAsset.Builder.create(this, "ImageAssets")
 *         .directory(join(__dirname, "./docker.assets"))
 *         .build();
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromAsset(AssetProps.builder()
 *                 .imageConfiguration(ImageConfiguration.builder().port(8000).build())
 *                 .asset(imageAsset)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.913Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.Source")
public abstract class Source extends software.amazon.jsii.JsiiObject {

    protected Source(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Source(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected Source() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Source from local assets.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.AssetSource fromAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.AssetProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apprunner.Source.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.AssetSource.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Source from the ECR repository.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.EcrSource fromEcr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.EcrProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apprunner.Source.class, "fromEcr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.EcrSource.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Source from the ECR Public repository.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.EcrPublicSource fromEcrPublic(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.EcrPublicProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apprunner.Source.class, "fromEcrPublic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.EcrPublicSource.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Source from the GitHub repository.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.GithubSource fromGitHub(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.GithubRepositoryProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apprunner.Source.class, "fromGitHub", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.GithubSource.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.SourceConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.apprunner.Source {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Called when the Job is initialized to allow this object to bind.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.SourceConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.SourceConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
