package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) The App Runner VPC Connector.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Vpc vpc = Vpc.Builder.create(this, "Vpc")
 *         .cidr("10.0.0.0/16")
 *         .build();
 * VpcConnector vpcConnector = VpcConnector.Builder.create(this, "VpcConnector")
 *         .vpc(vpc)
 *         .vpcSubnets(vpc.selectSubnets(SubnetSelection.builder().subnetType(SubnetType.PUBLIC).build()))
 *         .vpcConnectorName("MyVpcConnector")
 *         .build();
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromEcrPublic(EcrPublicProps.builder()
 *                 .imageConfiguration(ImageConfiguration.builder().port(8000).build())
 *                 .imageIdentifier("public.ecr.aws/aws-containers/hello-app-runner:latest")
 *                 .build()))
 *         .vpcConnector(vpcConnector)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.918Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.VpcConnector")
public class VpcConnector extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apprunner.IVpcConnector {

    protected VpcConnector(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcConnector(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public VpcConnector(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.VpcConnectorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import from VPC connector attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.IVpcConnector fromVpcConnectorAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.VpcConnectorAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apprunner.VpcConnector.class, "fromVpcConnectorAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.IVpcConnector.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Allows specifying security group connections for the VPC connector.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (experimental) The ARN of the VPC connector.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcConnectorArn() {
        return software.amazon.jsii.Kernel.get(this, "vpcConnectorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the VPC connector.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcConnectorName() {
        return software.amazon.jsii.Kernel.get(this, "vpcConnectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The revision of the VPC connector.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number getVpcConnectorRevision() {
        return software.amazon.jsii.Kernel.get(this, "vpcConnectorRevision", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apprunner.VpcConnector}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apprunner.VpcConnector> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apprunner.VpcConnectorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apprunner.VpcConnectorProps.Builder();
        }

        /**
         * (experimental) The VPC for the VPC Connector.
         * <p>
         * @return {@code this}
         * @param vpc The VPC for the VPC Connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * (experimental) A list of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets.
         * <p>
         * Default: - a new security group will be created in the specified VPC
         * <p>
         * @return {@code this}
         * @param securityGroups A list of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * (experimental) The name for the VpcConnector.
         * <p>
         * Default: - a name generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param vpcConnectorName The name for the VpcConnector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcConnectorName(final java.lang.String vpcConnectorName) {
            this.props.vpcConnectorName(vpcConnectorName);
            return this;
        }

        /**
         * (experimental) Where to place the VPC Connector within the VPC.
         * <p>
         * Default: - Private subnets.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the VPC Connector within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apprunner.VpcConnector}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apprunner.VpcConnector build() {
            return new software.amazon.awscdk.services.apprunner.VpcConnector(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
