package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Attributes for the App Runner VPC Connector.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * import software.amazon.awscdk.services.ec2.*;
 * SecurityGroup securityGroup;
 * VpcConnectorAttributes vpcConnectorAttributes = VpcConnectorAttributes.builder()
 *         .securityGroups(List.of(securityGroup))
 *         .vpcConnectorArn("vpcConnectorArn")
 *         .vpcConnectorName("vpcConnectorName")
 *         .vpcConnectorRevision(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.919Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.VpcConnectorAttributes")
@software.amazon.jsii.Jsii.Proxy(VpcConnectorAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface VpcConnectorAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The security groups associated with the VPC connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups();

    /**
     * (experimental) The ARN of the VPC connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcConnectorArn();

    /**
     * (experimental) The name of the VPC connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcConnectorName();

    /**
     * (experimental) The revision of the VPC connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getVpcConnectorRevision();

    /**
     * @return a {@link Builder} of {@link VpcConnectorAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcConnectorAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<VpcConnectorAttributes> {
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.lang.String vpcConnectorArn;
        java.lang.String vpcConnectorName;
        java.lang.Number vpcConnectorRevision;

        /**
         * Sets the value of {@link VpcConnectorAttributes#getSecurityGroups}
         * @param securityGroups The security groups associated with the VPC connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link VpcConnectorAttributes#getVpcConnectorArn}
         * @param vpcConnectorArn The ARN of the VPC connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcConnectorArn(java.lang.String vpcConnectorArn) {
            this.vpcConnectorArn = vpcConnectorArn;
            return this;
        }

        /**
         * Sets the value of {@link VpcConnectorAttributes#getVpcConnectorName}
         * @param vpcConnectorName The name of the VPC connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcConnectorName(java.lang.String vpcConnectorName) {
            this.vpcConnectorName = vpcConnectorName;
            return this;
        }

        /**
         * Sets the value of {@link VpcConnectorAttributes#getVpcConnectorRevision}
         * @param vpcConnectorRevision The revision of the VPC connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcConnectorRevision(java.lang.Number vpcConnectorRevision) {
            this.vpcConnectorRevision = vpcConnectorRevision;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcConnectorAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public VpcConnectorAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcConnectorAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConnectorAttributes {
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.lang.String vpcConnectorArn;
        private final java.lang.String vpcConnectorName;
        private final java.lang.Number vpcConnectorRevision;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.vpcConnectorArn = software.amazon.jsii.Kernel.get(this, "vpcConnectorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcConnectorName = software.amazon.jsii.Kernel.get(this, "vpcConnectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcConnectorRevision = software.amazon.jsii.Kernel.get(this, "vpcConnectorRevision", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)java.util.Objects.requireNonNull(builder.securityGroups, "securityGroups is required");
            this.vpcConnectorArn = java.util.Objects.requireNonNull(builder.vpcConnectorArn, "vpcConnectorArn is required");
            this.vpcConnectorName = java.util.Objects.requireNonNull(builder.vpcConnectorName, "vpcConnectorName is required");
            this.vpcConnectorRevision = java.util.Objects.requireNonNull(builder.vpcConnectorRevision, "vpcConnectorRevision is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.String getVpcConnectorArn() {
            return this.vpcConnectorArn;
        }

        @Override
        public final java.lang.String getVpcConnectorName() {
            return this.vpcConnectorName;
        }

        @Override
        public final java.lang.Number getVpcConnectorRevision() {
            return this.vpcConnectorRevision;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            data.set("vpcConnectorArn", om.valueToTree(this.getVpcConnectorArn()));
            data.set("vpcConnectorName", om.valueToTree(this.getVpcConnectorName()));
            data.set("vpcConnectorRevision", om.valueToTree(this.getVpcConnectorRevision()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.VpcConnectorAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcConnectorAttributes.Jsii$Proxy that = (VpcConnectorAttributes.Jsii$Proxy) o;

            if (!securityGroups.equals(that.securityGroups)) return false;
            if (!vpcConnectorArn.equals(that.vpcConnectorArn)) return false;
            if (!vpcConnectorName.equals(that.vpcConnectorName)) return false;
            return this.vpcConnectorRevision.equals(that.vpcConnectorRevision);
        }

        @Override
        public final int hashCode() {
            int result = this.securityGroups.hashCode();
            result = 31 * result + (this.vpcConnectorArn.hashCode());
            result = 31 * result + (this.vpcConnectorName.hashCode());
            result = 31 * result + (this.vpcConnectorRevision.hashCode());
            return result;
        }
    }
}
