package software.amazon.awscdk.services.appsync;

/**
 * (experimental) AppSync Functions are local functions that perform certain operations onto a backend data source.
 * <p>
 * Developers can compose operations (Functions)
 * and execute them in sequence with Pipeline Resolvers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * AppsyncFunction appsyncFunction = AppsyncFunction.Builder.create(this, "function")
 *         .name("appsync_function")
 *         .api(api)
 *         .dataSource(api.addNoneDataSource("none"))
 *         .requestMappingTemplate(MappingTemplate.fromFile("request.vtl"))
 *         .responseMappingTemplate(MappingTemplate.fromFile("response.vtl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.068Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.AppsyncFunction")
public class AppsyncFunction extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.appsync.IAppsyncFunction {

    protected AppsyncFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppsyncFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AppsyncFunction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppsyncFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import Appsync Function from arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IAppsyncFunction fromAppsyncFunctionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppsyncFunctionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.AppsyncFunction.class, "fromAppsyncFunctionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IAppsyncFunction.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) the data source of this AppSync Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BaseDataSource getDataSource() {
        return software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.BaseDataSource.class));
    }

    /**
     * (experimental) the ARN of the AppSync function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) the ID of the AppSync function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionId() {
        return software.amazon.jsii.Kernel.get(this, "functionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) the name of this AppSync Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appsync.AppsyncFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.AppsyncFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.AppsyncFunctionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.AppsyncFunctionProps.Builder();
        }

        /**
         * (experimental) the name of the AppSync Function.
         * <p>
         * @return {@code this}
         * @param name the name of the AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * (experimental) the description for this AppSync Function.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description the description for this AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) the request mapping template for the AppSync Function.
         * <p>
         * Default: - no request mapping template
         * <p>
         * @return {@code this}
         * @param requestMappingTemplate the request mapping template for the AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requestMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate) {
            this.props.requestMappingTemplate(requestMappingTemplate);
            return this;
        }

        /**
         * (experimental) the response mapping template for the AppSync Function.
         * <p>
         * Default: - no response mapping template
         * <p>
         * @return {@code this}
         * @param responseMappingTemplate the response mapping template for the AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responseMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate) {
            this.props.responseMappingTemplate(responseMappingTemplate);
            return this;
        }

        /**
         * (experimental) the GraphQL Api linked to this AppSync Function.
         * <p>
         * @return {@code this}
         * @param api the GraphQL Api linked to this AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder api(final software.amazon.awscdk.services.appsync.IGraphqlApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * (experimental) the data source linked to this AppSync Function.
         * <p>
         * @return {@code this}
         * @param dataSource the data source linked to this AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataSource(final software.amazon.awscdk.services.appsync.BaseDataSource dataSource) {
            this.props.dataSource(dataSource);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.AppsyncFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appsync.AppsyncFunction build() {
            return new software.amazon.awscdk.services.appsync.AppsyncFunction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
