package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Abstract AppSync datasource implementation.
 * <p>
 * Do not use directly but use subclasses for concrete datasources
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * MappingTemplate dummyRequest;
 * MappingTemplate dummyResponse;
 * ObjectType info = ObjectType.Builder.create("Info")
 *         .definition(Map.of(
 *                 "node", ResolvableField.Builder.create()
 *                         .returnType(GraphqlType.string())
 *                         .args(Map.of(
 *                                 "id", GraphqlType.string()))
 *                         .dataSource(api.addNoneDataSource("none"))
 *                         .requestMappingTemplate(dummyRequest)
 *                         .responseMappingTemplate(dummyResponse)
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.085Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.BaseDataSource")
public abstract class BaseDataSource extends software.amazon.awscdk.core.Construct {

    protected BaseDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     * @param extended This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected BaseDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BackedDataSourceProps props, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ExtendedDataSourceProps extended) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required"), java.util.Objects.requireNonNull(extended, "extended is required") });
    }

    /**
     * (experimental) creates a new appsync function for this datasource and API using the given properties.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppsyncFunction createFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BaseAppsyncFunctionProps props) {
        return software.amazon.jsii.Kernel.call(this, "createFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppsyncFunction.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) creates a new resolver for this datasource and API using the given properties.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Resolver createResolver(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BaseResolverProps props) {
        return software.amazon.jsii.Kernel.call(this, "createResolver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Resolver.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) the underlying CFN data source resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnDataSource getDs() {
        return software.amazon.jsii.Kernel.get(this, "ds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.CfnDataSource.class));
    }

    /**
     * (experimental) the name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi getApi() {
        return software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setApi(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi value) {
        software.amazon.jsii.Kernel.set(this, "api", java.util.Objects.requireNonNull(value, "api is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setServiceRole(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole value) {
        software.amazon.jsii.Kernel.set(this, "serviceRole", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appsync.BaseDataSource implements software.amazon.awscdk.core.IConstruct.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
