package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Properties for an AppSync GraphQL API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api = GraphqlApi.Builder.create(this, "Api")
 *         .name("demo")
 *         .build();
 * ObjectType demo = ObjectType.Builder.create("Demo")
 *         .definition(Map.of(
 *                 "id", GraphqlType.string(BaseTypeOptions.builder().isRequired(true).build()),
 *                 "version", GraphqlType.string(BaseTypeOptions.builder().isRequired(true).build())))
 *         .build();
 * api.addType(demo);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.220Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.GraphqlApiProps")
@software.amazon.jsii.Jsii.Proxy(GraphqlApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GraphqlApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) the name of the GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * (experimental) Optional authorization configuration.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AuthorizationConfig getAuthorizationConfig() {
        return null;
    }

    /**
     * (experimental) The domain name configuration for the GraphQL API.
     * <p>
     * The Route 53 hosted zone and CName DNS record must be configured in addition to this setting to
     * enable custom domain URL
     * <p>
     * Default: - no domain name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DomainOptions getDomainName() {
        return null;
    }

    /**
     * (experimental) Logging configuration for this api.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.LogConfig getLogConfig() {
        return null;
    }

    /**
     * (experimental) GraphQL schema definition. Specify how you want to define your schema.
     * <p>
     * Schema.fromFile(filePath: string) allows schema definition through schema.graphql file
     * <p>
     * Default: - schema will be generated code-first (i.e. addType, addObjectType, etc.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.Schema getSchema() {
        return null;
    }

    /**
     * (experimental) A flag indicating whether or not X-Ray tracing is enabled for the GraphQL API.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getXrayEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GraphqlApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GraphqlApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GraphqlApiProps> {
        java.lang.String name;
        software.amazon.awscdk.services.appsync.AuthorizationConfig authorizationConfig;
        software.amazon.awscdk.services.appsync.DomainOptions domainName;
        software.amazon.awscdk.services.appsync.LogConfig logConfig;
        software.amazon.awscdk.services.appsync.Schema schema;
        java.lang.Boolean xrayEnabled;

        /**
         * Sets the value of {@link GraphqlApiProps#getName}
         * @param name the name of the GraphQL API. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getAuthorizationConfig}
         * @param authorizationConfig Optional authorization configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizationConfig(software.amazon.awscdk.services.appsync.AuthorizationConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getDomainName}
         * @param domainName The domain name configuration for the GraphQL API.
         *                   The Route 53 hosted zone and CName DNS record must be configured in addition to this setting to
         *                   enable custom domain URL
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(software.amazon.awscdk.services.appsync.DomainOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getLogConfig}
         * @param logConfig Logging configuration for this api.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logConfig(software.amazon.awscdk.services.appsync.LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getSchema}
         * @param schema GraphQL schema definition. Specify how you want to define your schema.
         *               Schema.fromFile(filePath: string) allows schema definition through schema.graphql file
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder schema(software.amazon.awscdk.services.appsync.Schema schema) {
            this.schema = schema;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getXrayEnabled}
         * @param xrayEnabled A flag indicating whether or not X-Ray tracing is enabled for the GraphQL API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder xrayEnabled(java.lang.Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GraphqlApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GraphqlApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GraphqlApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GraphqlApiProps {
        private final java.lang.String name;
        private final software.amazon.awscdk.services.appsync.AuthorizationConfig authorizationConfig;
        private final software.amazon.awscdk.services.appsync.DomainOptions domainName;
        private final software.amazon.awscdk.services.appsync.LogConfig logConfig;
        private final software.amazon.awscdk.services.appsync.Schema schema;
        private final java.lang.Boolean xrayEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationConfig.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.DomainOptions.class));
            this.logConfig = software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.LogConfig.class));
            this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Schema.class));
            this.xrayEnabled = software.amazon.jsii.Kernel.get(this, "xrayEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.authorizationConfig = builder.authorizationConfig;
            this.domainName = builder.domainName;
            this.logConfig = builder.logConfig;
            this.schema = builder.schema;
            this.xrayEnabled = builder.xrayEnabled;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AuthorizationConfig getAuthorizationConfig() {
            return this.authorizationConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.DomainOptions getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.LogConfig getLogConfig() {
            return this.logConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.Schema getSchema() {
            return this.schema;
        }

        @Override
        public final java.lang.Boolean getXrayEnabled() {
            return this.xrayEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAuthorizationConfig() != null) {
                data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getLogConfig() != null) {
                data.set("logConfig", om.valueToTree(this.getLogConfig()));
            }
            if (this.getSchema() != null) {
                data.set("schema", om.valueToTree(this.getSchema()));
            }
            if (this.getXrayEnabled() != null) {
                data.set("xrayEnabled", om.valueToTree(this.getXrayEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_appsync.GraphqlApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GraphqlApiProps.Jsii$Proxy that = (GraphqlApiProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.authorizationConfig != null ? !this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.logConfig != null ? !this.logConfig.equals(that.logConfig) : that.logConfig != null) return false;
            if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) return false;
            return this.xrayEnabled != null ? this.xrayEnabled.equals(that.xrayEnabled) : that.xrayEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.logConfig != null ? this.logConfig.hashCode() : 0);
            result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
            result = 31 * result + (this.xrayEnabled != null ? this.xrayEnabled.hashCode() : 0);
            return result;
        }
    }
}
