package software.amazon.awscdk.services.autoscaling;

/**
 * (experimental) Describes a block device mapping for an EC2 instance or Auto Scaling group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * BlockDeviceVolume blockDeviceVolume = BlockDeviceVolume.ebs(123, EbsDeviceOptions.builder()
 *         .deleteOnTermination(false)
 *         .encrypted(false)
 *         .iops(123)
 *         .volumeType(EbsDeviceVolumeType.STANDARD)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.410Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_autoscaling.BlockDeviceVolume")
public class BlockDeviceVolume extends software.amazon.jsii.JsiiObject {

    protected BlockDeviceVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BlockDeviceVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param ebsDevice EBS device info.
     * @param virtualName Virtual device name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected BlockDeviceVolume(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.EbsDeviceProps ebsDevice, final @org.jetbrains.annotations.Nullable java.lang.String virtualName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { ebsDevice, virtualName });
    }

    /**
     * @param ebsDevice EBS device info.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected BlockDeviceVolume(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.EbsDeviceProps ebsDevice) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { ebsDevice });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected BlockDeviceVolume() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Creates a new Elastic Block Storage device.
     * <p>
     * @param volumeSize The volume size, in Gibibytes (GiB). This parameter is required.
     * @param options additional device options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BlockDeviceVolume ebs(final @org.jetbrains.annotations.NotNull java.lang.Number volumeSize, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.EbsDeviceOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class, "ebs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(volumeSize, "volumeSize is required"), options });
    }

    /**
     * (experimental) Creates a new Elastic Block Storage device.
     * <p>
     * @param volumeSize The volume size, in Gibibytes (GiB). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BlockDeviceVolume ebs(final @org.jetbrains.annotations.NotNull java.lang.Number volumeSize) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class, "ebs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(volumeSize, "volumeSize is required") });
    }

    /**
     * (experimental) Creates a new Elastic Block Storage device from an existing snapshot.
     * <p>
     * @param snapshotId The snapshot ID of the volume to use. This parameter is required.
     * @param options additional device options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BlockDeviceVolume ebsFromSnapshot(final @org.jetbrains.annotations.NotNull java.lang.String snapshotId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.EbsDeviceSnapshotOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class, "ebsFromSnapshot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(snapshotId, "snapshotId is required"), options });
    }

    /**
     * (experimental) Creates a new Elastic Block Storage device from an existing snapshot.
     * <p>
     * @param snapshotId The snapshot ID of the volume to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BlockDeviceVolume ebsFromSnapshot(final @org.jetbrains.annotations.NotNull java.lang.String snapshotId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class, "ebsFromSnapshot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(snapshotId, "snapshotId is required") });
    }

    /**
     * (experimental) Creates a virtual, ephemeral device.
     * <p>
     * The name will be in the form ephemeral{volumeIndex}.
     * <p>
     * @param volumeIndex the volume index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BlockDeviceVolume ephemeral(final @org.jetbrains.annotations.NotNull java.lang.Number volumeIndex) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class, "ephemeral", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(volumeIndex, "volumeIndex is required") });
    }

    /**
     * (experimental) Supresses a volume mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BlockDeviceVolume noDevice() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class, "noDevice", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class));
    }

    /**
     * (experimental) EBS device info.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.EbsDeviceProps getEbsDevice() {
        return software.amazon.jsii.Kernel.get(this, "ebsDevice", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.EbsDeviceProps.class));
    }

    /**
     * (experimental) Virtual device name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getVirtualName() {
        return software.amazon.jsii.Kernel.get(this, "virtualName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
