package software.amazon.awscdk.services.autoscaling;

/**
 * (experimental) Basic properties of an AutoScalingGroup, except the exact machines to run and where they should run.
 * <p>
 * Constructs that want to create AutoScalingGroups can inherit
 * this interface and specialize the essential parts in various ways.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.sns.*;
 * BlockDeviceVolume blockDeviceVolume;
 * Duration duration;
 * GroupMetrics groupMetrics;
 * HealthCheck healthCheck;
 * ScalingEvents scalingEvents;
 * Signals signals;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * Topic topic;
 * UpdatePolicy updatePolicy;
 * CommonAutoScalingGroupProps commonAutoScalingGroupProps = CommonAutoScalingGroupProps.builder()
 *         .allowAllOutbound(false)
 *         .associatePublicIpAddress(false)
 *         .autoScalingGroupName("autoScalingGroupName")
 *         .blockDevices(List.of(BlockDevice.builder()
 *                 .deviceName("deviceName")
 *                 .volume(blockDeviceVolume)
 *                 // the properties below are optional
 *                 .mappingEnabled(false)
 *                 .build()))
 *         .cooldown(duration)
 *         .desiredCapacity(123)
 *         .groupMetrics(List.of(groupMetrics))
 *         .healthCheck(healthCheck)
 *         .ignoreUnmodifiedSizeProperties(false)
 *         .instanceMonitoring(Monitoring.BASIC)
 *         .keyName("keyName")
 *         .maxCapacity(123)
 *         .maxInstanceLifetime(duration)
 *         .minCapacity(123)
 *         .newInstancesProtectedFromScaleIn(false)
 *         .notifications(List.of(NotificationConfiguration.builder()
 *                 .topic(topic)
 *                 // the properties below are optional
 *                 .scalingEvents(scalingEvents)
 *                 .build()))
 *         .notificationsTopic(topic)
 *         .replacingUpdateMinSuccessfulInstancesPercent(123)
 *         .resourceSignalCount(123)
 *         .resourceSignalTimeout(duration)
 *         .rollingUpdateConfiguration(RollingUpdateConfiguration.builder()
 *                 .maxBatchSize(123)
 *                 .minInstancesInService(123)
 *                 .minSuccessfulInstancesPercent(123)
 *                 .pauseTime(duration)
 *                 .suspendProcesses(List.of(ScalingProcess.LAUNCH))
 *                 .waitOnResourceSignals(false)
 *                 .build())
 *         .signals(signals)
 *         .spotPrice("spotPrice")
 *         .terminationPolicies(List.of(TerminationPolicy.ALLOCATION_STRATEGY))
 *         .updatePolicy(updatePolicy)
 *         .updateType(UpdateType.NONE)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnetName("subnetName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.ISOLATED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.559Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_autoscaling.CommonAutoScalingGroupProps")
@software.amazon.jsii.Jsii.Proxy(CommonAutoScalingGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CommonAutoScalingGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Whether the instances can initiate connections to anywhere by default.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * (experimental) Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
     * <p>
     * Default: - Use subnet setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssociatePublicIpAddress() {
        return null;
    }

    /**
     * (experimental) The name of the Auto Scaling group.
     * <p>
     * This name must be unique per Region per account.
     * <p>
     * Default: - Auto generated by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingGroupName() {
        return null;
    }

    /**
     * (experimental) Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     * <p>
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     * <p>
     * Default: - Uses the block device mapping of the AMI
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> getBlockDevices() {
        return null;
    }

    /**
     * (experimental) Default scaling cooldown for this AutoScalingGroup.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getCooldown() {
        return null;
    }

    /**
     * (experimental) Initial amount of instances in the fleet.
     * <p>
     * If this is set to a number, every deployment will reset the amount of
     * instances to this number. It is recommended to leave this value blank.
     * <p>
     * Default: minCapacity, and leave unchanged during deployment
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCapacity() {
        return null;
    }

    /**
     * (experimental) Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
     * <p>
     * To report all group metrics use <code>GroupMetrics.all()</code>
     * Group metrics are reported in a granularity of 1 minute at no additional charge.
     * <p>
     * Default: - no group metrics will be reported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> getGroupMetrics() {
        return null;
    }

    /**
     * (experimental) Configuration for health checks.
     * <p>
     * Default: - HealthCheck.ec2 with no grace period
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.HealthCheck getHealthCheck() {
        return null;
    }

    /**
     * (experimental) If the ASG has scheduled actions, don't reset unchanged group sizes.
     * <p>
     * Only used if the ASG has scheduled actions (which may scale your ASG up
     * or down regardless of cdk deployments). If true, the size of the group
     * will only be reset if it has been changed in the CDK app. If false, the
     * sizes will always be changed back to what they were in the CDK app
     * on deployment.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreUnmodifiedSizeProperties() {
        return null;
    }

    /**
     * (experimental) Controls whether instances in this group are launched with detailed or basic monitoring.
     * <p>
     * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
     * is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
     * <p>
     * Default: - Monitoring.DETAILED
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics">https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.Monitoring getInstanceMonitoring() {
        return null;
    }

    /**
     * (experimental) Name of SSH keypair to grant access to instances.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * (experimental) Maximum number of instances in the fleet.
     * <p>
     * Default: desiredCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return null;
    }

    /**
     * (experimental) The maximum amount of time that an instance can be in service.
     * <p>
     * The maximum duration applies
     * to all current and future instances in the group. As an instance approaches its maximum duration,
     * it is terminated and replaced, and cannot be used again.
     * <p>
     * You must specify a value of at least 604,800 seconds (7 days). To clear a previously set value,
     * leave this property undefined.
     * <p>
     * Default: none
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxInstanceLifetime() {
        return null;
    }

    /**
     * (experimental) Minimum number of instances in the fleet.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
        return null;
    }

    /**
     * (experimental) Whether newly-launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
     * <p>
     * By default, Auto Scaling can terminate an instance at any time after launch
     * when scaling in an Auto Scaling Group, subject to the group's termination
     * policy. However, you may wish to protect newly-launched instances from
     * being scaled in if they are going to run critical applications that should
     * not be prematurely terminated.
     * <p>
     * This flag must be enabled if the Auto Scaling Group will be associated with
     * an ECS Capacity Provider with managed termination protection.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNewInstancesProtectedFromScaleIn() {
        return null;
    }

    /**
     * (experimental) Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
     * <p>
     * Default: - No fleet change notifications will be sent.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> getNotifications() {
        return null;
    }

    /**
     * (deprecated) SNS topic to send notifications about fleet changes.
     * <p>
     * Default: - No fleet change notifications will be sent.
     * <p>
     * @deprecated use `notifications`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getNotificationsTopic() {
        return null;
    }

    /**
     * (deprecated) Configuration for replacing updates.
     * <p>
     * Only used if updateType == UpdateType.ReplacingUpdate. Specifies how
     * many instances must signal success for the update to succeed.
     * <p>
     * Default: minSuccessfulInstancesPercent
     * <p>
     * @deprecated Use `signals` instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Number getReplacingUpdateMinSuccessfulInstancesPercent() {
        return null;
    }

    /**
     * (deprecated) How many ResourceSignal calls CloudFormation expects before the resource is considered created.
     * <p>
     * Default: 1 if resourceSignalTimeout is set, 0 otherwise
     * <p>
     * @deprecated Use `signals` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Number getResourceSignalCount() {
        return null;
    }

    /**
     * (deprecated) The length of time to wait for the resourceSignalCount.
     * <p>
     * The maximum value is 43200 (12 hours).
     * <p>
     * Default: Duration.minutes(5) if resourceSignalCount is set, N/A otherwise
     * <p>
     * @deprecated Use `signals` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getResourceSignalTimeout() {
        return null;
    }

    /**
     * (deprecated) Configuration for rolling updates.
     * <p>
     * Only used if updateType == UpdateType.RollingUpdate.
     * <p>
     * Default: - RollingUpdateConfiguration with defaults.
     * <p>
     * @deprecated Use `updatePolicy` instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration getRollingUpdateConfiguration() {
        return null;
    }

    /**
     * (experimental) Configure waiting for signals during deployment.
     * <p>
     * Use this to pause the CloudFormation deployment to wait for the instances
     * in the AutoScalingGroup to report successful startup during
     * creation and updates. The UserData script needs to invoke <code>cfn-signal</code>
     * with a success or failure code after it is done setting up the instance.
     * <p>
     * Without waiting for signals, the CloudFormation deployment will proceed as
     * soon as the AutoScalingGroup has been created or updated but before the
     * instances in the group have been started.
     * <p>
     * For example, to have instances wait for an Elastic Load Balancing health check before
     * they signal success, add a health-check verification by using the
     * cfn-init helper script. For an example, see the verify_instance_health
     * command in the Auto Scaling rolling updates sample template:
     * <p>
     * https://github.com/awslabs/aws-cloudformation-templates/blob/master/aws/services/AutoScaling/AutoScalingRollingUpdates.yaml
     * <p>
     * Default: - Do not wait for signals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.Signals getSignals() {
        return null;
    }

    /**
     * (experimental) The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
     * <p>
     * Spot Instances are
     * launched when the price you specify exceeds the current Spot market price.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
        return null;
    }

    /**
     * (experimental) A policy or a list of policies that are used to select the instances to terminate.
     * <p>
     * The policies are executed in the order that you list them.
     * <p>
     * Default: - `TerminationPolicy.DEFAULT`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> getTerminationPolicies() {
        return null;
    }

    /**
     * (experimental) What to do when an AutoScalingGroup's instance configuration is changed.
     * <p>
     * This is applied when any of the settings on the ASG are changed that
     * affect how the instances should be created (VPC, instance type, startup
     * scripts, etc.). It indicates how the existing instances should be
     * replaced with new instances matching the new config. By default, nothing
     * is done and only new instances are launched with the new config.
     * <p>
     * Default: - `UpdatePolicy.rollingUpdate()` if using `init`, `UpdatePolicy.none()` otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.UpdatePolicy getUpdatePolicy() {
        return null;
    }

    /**
     * (deprecated) What to do when an AutoScalingGroup's instance configuration is changed.
     * <p>
     * This is applied when any of the settings on the ASG are changed that
     * affect how the instances should be created (VPC, instance type, startup
     * scripts, etc.). It indicates how the existing instances should be
     * replaced with new instances matching the new config. By default, nothing
     * is done and only new instances are launched with the new config.
     * <p>
     * Default: UpdateType.None
     * <p>
     * @deprecated Use `updatePolicy` instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.UpdateType getUpdateType() {
        return null;
    }

    /**
     * (experimental) Where to place instances within the VPC.
     * <p>
     * Default: - All Private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CommonAutoScalingGroupProps> {
        java.lang.Boolean allowAllOutbound;
        java.lang.Boolean associatePublicIpAddress;
        java.lang.String autoScalingGroupName;
        java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices;
        software.amazon.awscdk.core.Duration cooldown;
        java.lang.Number desiredCapacity;
        java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics;
        software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck;
        java.lang.Boolean ignoreUnmodifiedSizeProperties;
        software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring;
        java.lang.String keyName;
        java.lang.Number maxCapacity;
        software.amazon.awscdk.core.Duration maxInstanceLifetime;
        java.lang.Number minCapacity;
        java.lang.Boolean newInstancesProtectedFromScaleIn;
        java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications;
        software.amazon.awscdk.services.sns.ITopic notificationsTopic;
        java.lang.Number replacingUpdateMinSuccessfulInstancesPercent;
        java.lang.Number resourceSignalCount;
        software.amazon.awscdk.core.Duration resourceSignalTimeout;
        software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration rollingUpdateConfiguration;
        software.amazon.awscdk.services.autoscaling.Signals signals;
        java.lang.String spotPrice;
        java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies;
        software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy;
        software.amazon.awscdk.services.autoscaling.UpdateType updateType;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAllowAllOutbound}
         * @param allowAllOutbound Whether the instances can initiate connections to anywhere by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAutoScalingGroupName}
         * @param autoScalingGroupName The name of the Auto Scaling group.
         *                             This name must be unique per Region per account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingGroupName(java.lang.String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getBlockDevices}
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         *                     Each instance that is launched has an associated root device volume,
         *                     either an Amazon EBS volume or an instance store volume.
         *                     You can use block device mappings to specify additional EBS volumes or
         *                     instance store volumes to attach to an instance when it is launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder blockDevices(java.util.List<? extends software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices) {
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice>)blockDevices;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getCooldown}
         * @param cooldown Default scaling cooldown for this AutoScalingGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cooldown(software.amazon.awscdk.core.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getDesiredCapacity}
         * @param desiredCapacity Initial amount of instances in the fleet.
         *                        If this is set to a number, every deployment will reset the amount of
         *                        instances to this number. It is recommended to leave this value blank.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder desiredCapacity(java.lang.Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getGroupMetrics}
         * @param groupMetrics Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
         *                     To report all group metrics use <code>GroupMetrics.all()</code>
         *                     Group metrics are reported in a granularity of 1 minute at no additional charge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder groupMetrics(java.util.List<? extends software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics) {
            this.groupMetrics = (java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics>)groupMetrics;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getHealthCheck}
         * @param healthCheck Configuration for health checks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder healthCheck(software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getIgnoreUnmodifiedSizeProperties}
         * @param ignoreUnmodifiedSizeProperties If the ASG has scheduled actions, don't reset unchanged group sizes.
         *                                       Only used if the ASG has scheduled actions (which may scale your ASG up
         *                                       or down regardless of cdk deployments). If true, the size of the group
         *                                       will only be reset if it has been changed in the CDK app. If false, the
         *                                       sizes will always be changed back to what they were in the CDK app
         *                                       on deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ignoreUnmodifiedSizeProperties(java.lang.Boolean ignoreUnmodifiedSizeProperties) {
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getInstanceMonitoring}
         * @param instanceMonitoring Controls whether instances in this group are launched with detailed or basic monitoring.
         *                           When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
         *                           is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceMonitoring(software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getMaxCapacity}
         * @param maxCapacity Maximum number of instances in the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getMaxInstanceLifetime}
         * @param maxInstanceLifetime The maximum amount of time that an instance can be in service.
         *                            The maximum duration applies
         *                            to all current and future instances in the group. As an instance approaches its maximum duration,
         *                            it is terminated and replaced, and cannot be used again.
         *                            <p>
         *                            You must specify a value of at least 604,800 seconds (7 days). To clear a previously set value,
         *                            leave this property undefined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxInstanceLifetime(software.amazon.awscdk.core.Duration maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getMinCapacity}
         * @param minCapacity Minimum number of instances in the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getNewInstancesProtectedFromScaleIn}
         * @param newInstancesProtectedFromScaleIn Whether newly-launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
         *                                         By default, Auto Scaling can terminate an instance at any time after launch
         *                                         when scaling in an Auto Scaling Group, subject to the group's termination
         *                                         policy. However, you may wish to protect newly-launched instances from
         *                                         being scaled in if they are going to run critical applications that should
         *                                         not be prematurely terminated.
         *                                         <p>
         *                                         This flag must be enabled if the Auto Scaling Group will be associated with
         *                                         an ECS Capacity Provider with managed termination protection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder newInstancesProtectedFromScaleIn(java.lang.Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getNotifications}
         * @param notifications Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder notifications(java.util.List<? extends software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications) {
            this.notifications = (java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration>)notifications;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getNotificationsTopic}
         * @param notificationsTopic SNS topic to send notifications about fleet changes.
         * @return {@code this}
         * @deprecated use `notifications`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder notificationsTopic(software.amazon.awscdk.services.sns.ITopic notificationsTopic) {
            this.notificationsTopic = notificationsTopic;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getReplacingUpdateMinSuccessfulInstancesPercent}
         * @param replacingUpdateMinSuccessfulInstancesPercent Configuration for replacing updates.
         *                                                     Only used if updateType == UpdateType.ReplacingUpdate. Specifies how
         *                                                     many instances must signal success for the update to succeed.
         * @return {@code this}
         * @deprecated Use `signals` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder replacingUpdateMinSuccessfulInstancesPercent(java.lang.Number replacingUpdateMinSuccessfulInstancesPercent) {
            this.replacingUpdateMinSuccessfulInstancesPercent = replacingUpdateMinSuccessfulInstancesPercent;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getResourceSignalCount}
         * @param resourceSignalCount How many ResourceSignal calls CloudFormation expects before the resource is considered created.
         * @return {@code this}
         * @deprecated Use `signals` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder resourceSignalCount(java.lang.Number resourceSignalCount) {
            this.resourceSignalCount = resourceSignalCount;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getResourceSignalTimeout}
         * @param resourceSignalTimeout The length of time to wait for the resourceSignalCount.
         *                              The maximum value is 43200 (12 hours).
         * @return {@code this}
         * @deprecated Use `signals` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder resourceSignalTimeout(software.amazon.awscdk.core.Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getRollingUpdateConfiguration}
         * @param rollingUpdateConfiguration Configuration for rolling updates.
         *                                   Only used if updateType == UpdateType.RollingUpdate.
         * @return {@code this}
         * @deprecated Use `updatePolicy` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder rollingUpdateConfiguration(software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration rollingUpdateConfiguration) {
            this.rollingUpdateConfiguration = rollingUpdateConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getSignals}
         * @param signals Configure waiting for signals during deployment.
         *                Use this to pause the CloudFormation deployment to wait for the instances
         *                in the AutoScalingGroup to report successful startup during
         *                creation and updates. The UserData script needs to invoke <code>cfn-signal</code>
         *                with a success or failure code after it is done setting up the instance.
         *                <p>
         *                Without waiting for signals, the CloudFormation deployment will proceed as
         *                soon as the AutoScalingGroup has been created or updated but before the
         *                instances in the group have been started.
         *                <p>
         *                For example, to have instances wait for an Elastic Load Balancing health check before
         *                they signal success, add a health-check verification by using the
         *                cfn-init helper script. For an example, see the verify_instance_health
         *                command in the Auto Scaling rolling updates sample template:
         *                <p>
         *                https://github.com/awslabs/aws-cloudformation-templates/blob/master/aws/services/AutoScaling/AutoScalingRollingUpdates.yaml
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signals(software.amazon.awscdk.services.autoscaling.Signals signals) {
            this.signals = signals;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getSpotPrice}
         * @param spotPrice The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
         *                  Spot Instances are
         *                  launched when the price you specify exceeds the current Spot market price.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder spotPrice(java.lang.String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getTerminationPolicies}
         * @param terminationPolicies A policy or a list of policies that are used to select the instances to terminate.
         *                            The policies are executed in the order that you list them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder terminationPolicies(java.util.List<? extends software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies) {
            this.terminationPolicies = (java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy>)terminationPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getUpdatePolicy}
         * @param updatePolicy What to do when an AutoScalingGroup's instance configuration is changed.
         *                     This is applied when any of the settings on the ASG are changed that
         *                     affect how the instances should be created (VPC, instance type, startup
         *                     scripts, etc.). It indicates how the existing instances should be
         *                     replaced with new instances matching the new config. By default, nothing
         *                     is done and only new instances are launched with the new config.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder updatePolicy(software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getUpdateType}
         * @param updateType What to do when an AutoScalingGroup's instance configuration is changed.
         *                   This is applied when any of the settings on the ASG are changed that
         *                   affect how the instances should be created (VPC, instance type, startup
         *                   scripts, etc.). It indicates how the existing instances should be
         *                   replaced with new instances matching the new config. By default, nothing
         *                   is done and only new instances are launched with the new config.
         * @return {@code this}
         * @deprecated Use `updatePolicy` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder updateType(software.amazon.awscdk.services.autoscaling.UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getVpcSubnets}
         * @param vpcSubnets Where to place instances within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonAutoScalingGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CommonAutoScalingGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonAutoScalingGroupProps {
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Boolean associatePublicIpAddress;
        private final java.lang.String autoScalingGroupName;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices;
        private final software.amazon.awscdk.core.Duration cooldown;
        private final java.lang.Number desiredCapacity;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics;
        private final software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck;
        private final java.lang.Boolean ignoreUnmodifiedSizeProperties;
        private final software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring;
        private final java.lang.String keyName;
        private final java.lang.Number maxCapacity;
        private final software.amazon.awscdk.core.Duration maxInstanceLifetime;
        private final java.lang.Number minCapacity;
        private final java.lang.Boolean newInstancesProtectedFromScaleIn;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications;
        private final software.amazon.awscdk.services.sns.ITopic notificationsTopic;
        private final java.lang.Number replacingUpdateMinSuccessfulInstancesPercent;
        private final java.lang.Number resourceSignalCount;
        private final software.amazon.awscdk.core.Duration resourceSignalTimeout;
        private final software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration rollingUpdateConfiguration;
        private final software.amazon.awscdk.services.autoscaling.Signals signals;
        private final java.lang.String spotPrice;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies;
        private final software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy;
        private final software.amazon.awscdk.services.autoscaling.UpdateType updateType;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowAllOutbound = software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.autoScalingGroupName = software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockDevices = software.amazon.jsii.Kernel.get(this, "blockDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDevice.class)));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.desiredCapacity = software.amazon.jsii.Kernel.get(this, "desiredCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.groupMetrics = software.amazon.jsii.Kernel.get(this, "groupMetrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.GroupMetrics.class)));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.HealthCheck.class));
            this.ignoreUnmodifiedSizeProperties = software.amazon.jsii.Kernel.get(this, "ignoreUnmodifiedSizeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceMonitoring = software.amazon.jsii.Kernel.get(this, "instanceMonitoring", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Monitoring.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxInstanceLifetime = software.amazon.jsii.Kernel.get(this, "maxInstanceLifetime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.newInstancesProtectedFromScaleIn = software.amazon.jsii.Kernel.get(this, "newInstancesProtectedFromScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notifications = software.amazon.jsii.Kernel.get(this, "notifications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.NotificationConfiguration.class)));
            this.notificationsTopic = software.amazon.jsii.Kernel.get(this, "notificationsTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
            this.replacingUpdateMinSuccessfulInstancesPercent = software.amazon.jsii.Kernel.get(this, "replacingUpdateMinSuccessfulInstancesPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.resourceSignalCount = software.amazon.jsii.Kernel.get(this, "resourceSignalCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.resourceSignalTimeout = software.amazon.jsii.Kernel.get(this, "resourceSignalTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.rollingUpdateConfiguration = software.amazon.jsii.Kernel.get(this, "rollingUpdateConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration.class));
            this.signals = software.amazon.jsii.Kernel.get(this, "signals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Signals.class));
            this.spotPrice = software.amazon.jsii.Kernel.get(this, "spotPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.terminationPolicies = software.amazon.jsii.Kernel.get(this, "terminationPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.TerminationPolicy.class)));
            this.updatePolicy = software.amazon.jsii.Kernel.get(this, "updatePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.UpdatePolicy.class));
            this.updateType = software.amazon.jsii.Kernel.get(this, "updateType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.UpdateType.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowAllOutbound = builder.allowAllOutbound;
            this.associatePublicIpAddress = builder.associatePublicIpAddress;
            this.autoScalingGroupName = builder.autoScalingGroupName;
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice>)builder.blockDevices;
            this.cooldown = builder.cooldown;
            this.desiredCapacity = builder.desiredCapacity;
            this.groupMetrics = (java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics>)builder.groupMetrics;
            this.healthCheck = builder.healthCheck;
            this.ignoreUnmodifiedSizeProperties = builder.ignoreUnmodifiedSizeProperties;
            this.instanceMonitoring = builder.instanceMonitoring;
            this.keyName = builder.keyName;
            this.maxCapacity = builder.maxCapacity;
            this.maxInstanceLifetime = builder.maxInstanceLifetime;
            this.minCapacity = builder.minCapacity;
            this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
            this.notifications = (java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration>)builder.notifications;
            this.notificationsTopic = builder.notificationsTopic;
            this.replacingUpdateMinSuccessfulInstancesPercent = builder.replacingUpdateMinSuccessfulInstancesPercent;
            this.resourceSignalCount = builder.resourceSignalCount;
            this.resourceSignalTimeout = builder.resourceSignalTimeout;
            this.rollingUpdateConfiguration = builder.rollingUpdateConfiguration;
            this.signals = builder.signals;
            this.spotPrice = builder.spotPrice;
            this.terminationPolicies = (java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy>)builder.terminationPolicies;
            this.updatePolicy = builder.updatePolicy;
            this.updateType = builder.updateType;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public final java.lang.Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final java.lang.String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public final java.lang.Number getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> getGroupMetrics() {
            return this.groupMetrics;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.Boolean getIgnoreUnmodifiedSizeProperties() {
            return this.ignoreUnmodifiedSizeProperties;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.Monitoring getInstanceMonitoring() {
            return this.instanceMonitoring;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxInstanceLifetime() {
            return this.maxInstanceLifetime;
        }

        @Override
        public final java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final java.lang.Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> getNotifications() {
            return this.notifications;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getNotificationsTopic() {
            return this.notificationsTopic;
        }

        @Override
        public final java.lang.Number getReplacingUpdateMinSuccessfulInstancesPercent() {
            return this.replacingUpdateMinSuccessfulInstancesPercent;
        }

        @Override
        public final java.lang.Number getResourceSignalCount() {
            return this.resourceSignalCount;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getResourceSignalTimeout() {
            return this.resourceSignalTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration getRollingUpdateConfiguration() {
            return this.rollingUpdateConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.Signals getSignals() {
            return this.signals;
        }

        @Override
        public final java.lang.String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.UpdatePolicy getUpdatePolicy() {
            return this.updatePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.UpdateType getUpdateType() {
            return this.updateType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getAssociatePublicIpAddress() != null) {
                data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
            }
            if (this.getAutoScalingGroupName() != null) {
                data.set("autoScalingGroupName", om.valueToTree(this.getAutoScalingGroupName()));
            }
            if (this.getBlockDevices() != null) {
                data.set("blockDevices", om.valueToTree(this.getBlockDevices()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getDesiredCapacity() != null) {
                data.set("desiredCapacity", om.valueToTree(this.getDesiredCapacity()));
            }
            if (this.getGroupMetrics() != null) {
                data.set("groupMetrics", om.valueToTree(this.getGroupMetrics()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getIgnoreUnmodifiedSizeProperties() != null) {
                data.set("ignoreUnmodifiedSizeProperties", om.valueToTree(this.getIgnoreUnmodifiedSizeProperties()));
            }
            if (this.getInstanceMonitoring() != null) {
                data.set("instanceMonitoring", om.valueToTree(this.getInstanceMonitoring()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMaxInstanceLifetime() != null) {
                data.set("maxInstanceLifetime", om.valueToTree(this.getMaxInstanceLifetime()));
            }
            if (this.getMinCapacity() != null) {
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            }
            if (this.getNewInstancesProtectedFromScaleIn() != null) {
                data.set("newInstancesProtectedFromScaleIn", om.valueToTree(this.getNewInstancesProtectedFromScaleIn()));
            }
            if (this.getNotifications() != null) {
                data.set("notifications", om.valueToTree(this.getNotifications()));
            }
            if (this.getNotificationsTopic() != null) {
                data.set("notificationsTopic", om.valueToTree(this.getNotificationsTopic()));
            }
            if (this.getReplacingUpdateMinSuccessfulInstancesPercent() != null) {
                data.set("replacingUpdateMinSuccessfulInstancesPercent", om.valueToTree(this.getReplacingUpdateMinSuccessfulInstancesPercent()));
            }
            if (this.getResourceSignalCount() != null) {
                data.set("resourceSignalCount", om.valueToTree(this.getResourceSignalCount()));
            }
            if (this.getResourceSignalTimeout() != null) {
                data.set("resourceSignalTimeout", om.valueToTree(this.getResourceSignalTimeout()));
            }
            if (this.getRollingUpdateConfiguration() != null) {
                data.set("rollingUpdateConfiguration", om.valueToTree(this.getRollingUpdateConfiguration()));
            }
            if (this.getSignals() != null) {
                data.set("signals", om.valueToTree(this.getSignals()));
            }
            if (this.getSpotPrice() != null) {
                data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
            }
            if (this.getTerminationPolicies() != null) {
                data.set("terminationPolicies", om.valueToTree(this.getTerminationPolicies()));
            }
            if (this.getUpdatePolicy() != null) {
                data.set("updatePolicy", om.valueToTree(this.getUpdatePolicy()));
            }
            if (this.getUpdateType() != null) {
                data.set("updateType", om.valueToTree(this.getUpdateType()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_autoscaling.CommonAutoScalingGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonAutoScalingGroupProps.Jsii$Proxy that = (CommonAutoScalingGroupProps.Jsii$Proxy) o;

            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
            if (this.autoScalingGroupName != null ? !this.autoScalingGroupName.equals(that.autoScalingGroupName) : that.autoScalingGroupName != null) return false;
            if (this.blockDevices != null ? !this.blockDevices.equals(that.blockDevices) : that.blockDevices != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.desiredCapacity != null ? !this.desiredCapacity.equals(that.desiredCapacity) : that.desiredCapacity != null) return false;
            if (this.groupMetrics != null ? !this.groupMetrics.equals(that.groupMetrics) : that.groupMetrics != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.ignoreUnmodifiedSizeProperties != null ? !this.ignoreUnmodifiedSizeProperties.equals(that.ignoreUnmodifiedSizeProperties) : that.ignoreUnmodifiedSizeProperties != null) return false;
            if (this.instanceMonitoring != null ? !this.instanceMonitoring.equals(that.instanceMonitoring) : that.instanceMonitoring != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.maxInstanceLifetime != null ? !this.maxInstanceLifetime.equals(that.maxInstanceLifetime) : that.maxInstanceLifetime != null) return false;
            if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
            if (this.newInstancesProtectedFromScaleIn != null ? !this.newInstancesProtectedFromScaleIn.equals(that.newInstancesProtectedFromScaleIn) : that.newInstancesProtectedFromScaleIn != null) return false;
            if (this.notifications != null ? !this.notifications.equals(that.notifications) : that.notifications != null) return false;
            if (this.notificationsTopic != null ? !this.notificationsTopic.equals(that.notificationsTopic) : that.notificationsTopic != null) return false;
            if (this.replacingUpdateMinSuccessfulInstancesPercent != null ? !this.replacingUpdateMinSuccessfulInstancesPercent.equals(that.replacingUpdateMinSuccessfulInstancesPercent) : that.replacingUpdateMinSuccessfulInstancesPercent != null) return false;
            if (this.resourceSignalCount != null ? !this.resourceSignalCount.equals(that.resourceSignalCount) : that.resourceSignalCount != null) return false;
            if (this.resourceSignalTimeout != null ? !this.resourceSignalTimeout.equals(that.resourceSignalTimeout) : that.resourceSignalTimeout != null) return false;
            if (this.rollingUpdateConfiguration != null ? !this.rollingUpdateConfiguration.equals(that.rollingUpdateConfiguration) : that.rollingUpdateConfiguration != null) return false;
            if (this.signals != null ? !this.signals.equals(that.signals) : that.signals != null) return false;
            if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
            if (this.terminationPolicies != null ? !this.terminationPolicies.equals(that.terminationPolicies) : that.terminationPolicies != null) return false;
            if (this.updatePolicy != null ? !this.updatePolicy.equals(that.updatePolicy) : that.updatePolicy != null) return false;
            if (this.updateType != null ? !this.updateType.equals(that.updateType) : that.updateType != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0;
            result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
            result = 31 * result + (this.autoScalingGroupName != null ? this.autoScalingGroupName.hashCode() : 0);
            result = 31 * result + (this.blockDevices != null ? this.blockDevices.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.desiredCapacity != null ? this.desiredCapacity.hashCode() : 0);
            result = 31 * result + (this.groupMetrics != null ? this.groupMetrics.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.ignoreUnmodifiedSizeProperties != null ? this.ignoreUnmodifiedSizeProperties.hashCode() : 0);
            result = 31 * result + (this.instanceMonitoring != null ? this.instanceMonitoring.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.maxInstanceLifetime != null ? this.maxInstanceLifetime.hashCode() : 0);
            result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
            result = 31 * result + (this.newInstancesProtectedFromScaleIn != null ? this.newInstancesProtectedFromScaleIn.hashCode() : 0);
            result = 31 * result + (this.notifications != null ? this.notifications.hashCode() : 0);
            result = 31 * result + (this.notificationsTopic != null ? this.notificationsTopic.hashCode() : 0);
            result = 31 * result + (this.replacingUpdateMinSuccessfulInstancesPercent != null ? this.replacingUpdateMinSuccessfulInstancesPercent.hashCode() : 0);
            result = 31 * result + (this.resourceSignalCount != null ? this.resourceSignalCount.hashCode() : 0);
            result = 31 * result + (this.resourceSignalTimeout != null ? this.resourceSignalTimeout.hashCode() : 0);
            result = 31 * result + (this.rollingUpdateConfiguration != null ? this.rollingUpdateConfiguration.hashCode() : 0);
            result = 31 * result + (this.signals != null ? this.signals.hashCode() : 0);
            result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
            result = 31 * result + (this.terminationPolicies != null ? this.terminationPolicies.hashCode() : 0);
            result = 31 * result + (this.updatePolicy != null ? this.updatePolicy.hashCode() : 0);
            result = 31 * result + (this.updateType != null ? this.updateType.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
