package software.amazon.awscdk.services.autoscaling;

/**
 * (experimental) Specifies the termination criteria to apply before Amazon EC2 Auto Scaling chooses an instance for termination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .terminationPolicies(List.of(TerminationPolicy.OLDEST_INSTANCE, TerminationPolicy.DEFAULT))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.631Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_autoscaling.TerminationPolicy")
public enum TerminationPolicy {
    /**
     * (experimental) Terminate instances in the Auto Scaling group to align the remaining instances to the allocation strategy for the type of instance that is terminating (either a Spot Instance or an On-Demand Instance).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ALLOCATION_STRATEGY,
    /**
     * (experimental) Terminate instances that are closest to the next billing hour.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CLOSEST_TO_NEXT_INSTANCE_HOUR,
    /**
     * (experimental) Terminate instances according to the default termination policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DEFAULT,
    /**
     * (experimental) Terminate the newest instance in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NEWEST_INSTANCE,
    /**
     * (experimental) Terminate the oldest instance in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OLDEST_INSTANCE,
    /**
     * (experimental) Terminate instances that have the oldest launch configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OLDEST_LAUNCH_CONFIGURATION,
    /**
     * (experimental) Terminate instances that have the oldest launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OLDEST_LAUNCH_TEMPLATE,
}
