package software.amazon.awscdk.services.backup;

/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 * <p>
 * Contains an optional backup plan display name and an array of <code>BackupRule</code> objects, each of which specifies a backup rule. Each rule in a backup plan is a separate scheduled task and can back up a different selection of AWS resources.
 * <p>
 * For a sample AWS CloudFormation template, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-cfn">AWS Backup Developer Guide</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object backupOptions;
 * CfnBackupPlan cfnBackupPlan = CfnBackupPlan.Builder.create(this, "MyCfnBackupPlan")
 *         .backupPlan(BackupPlanResourceTypeProperty.builder()
 *                 .backupPlanName("backupPlanName")
 *                 .backupPlanRule(List.of(BackupRuleResourceTypeProperty.builder()
 *                         .ruleName("ruleName")
 *                         .targetBackupVault("targetBackupVault")
 *                         // the properties below are optional
 *                         .completionWindowMinutes(123)
 *                         .copyActions(List.of(CopyActionResourceTypeProperty.builder()
 *                                 .destinationBackupVaultArn("destinationBackupVaultArn")
 *                                 // the properties below are optional
 *                                 .lifecycle(LifecycleResourceTypeProperty.builder()
 *                                         .deleteAfterDays(123)
 *                                         .moveToColdStorageAfterDays(123)
 *                                         .build())
 *                                 .build()))
 *                         .enableContinuousBackup(false)
 *                         .lifecycle(LifecycleResourceTypeProperty.builder()
 *                                 .deleteAfterDays(123)
 *                                 .moveToColdStorageAfterDays(123)
 *                                 .build())
 *                         .recoveryPointTags(Map.of(
 *                                 "recoveryPointTagsKey", "recoveryPointTags"))
 *                         .scheduleExpression("scheduleExpression")
 *                         .startWindowMinutes(123)
 *                         .build()))
 *                 // the properties below are optional
 *                 .advancedBackupSettings(List.of(AdvancedBackupSettingResourceTypeProperty.builder()
 *                         .backupOptions(backupOptions)
 *                         .resourceType("resourceType")
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .backupPlanTags(Map.of(
 *                 "backupPlanTagsKey", "backupPlanTags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.713Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_backup.CfnBackupPlan")
public class CfnBackupPlan extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnBackupPlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBackupPlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.backup.CfnBackupPlan.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Backup::BackupPlan`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBackupPlan(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.CfnBackupPlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a backup plan;
     * <p>
     * for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBackupPlanArn() {
        return software.amazon.jsii.Kernel.get(this, "attrBackupPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Uniquely identifies a backup plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBackupPlanId() {
        return software.amazon.jsii.Kernel.get(this, "attrBackupPlanId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long.
     * <p>
     * Version Ids cannot be edited.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionId() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Uniquely identifies the backup plan to be associated with the selection of resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getBackupPlan() {
        return software.amazon.jsii.Kernel.get(this, "backupPlan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Uniquely identifies the backup plan to be associated with the selection of resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupPlan(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.CfnBackupPlan.BackupPlanResourceTypeProperty value) {
        software.amazon.jsii.Kernel.set(this, "backupPlan", java.util.Objects.requireNonNull(value, "backupPlan is required"));
    }

    /**
     * Uniquely identifies the backup plan to be associated with the selection of resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupPlan(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "backupPlan", java.util.Objects.requireNonNull(value, "backupPlan is required"));
    }

    /**
     * To help organize your resources, you can assign your own metadata to the resources that you create.
     * <p>
     * Each tag is a key-value pair. The specified tags are assigned to all backups created with this plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBackupPlanTags() {
        return software.amazon.jsii.Kernel.get(this, "backupPlanTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * To help organize your resources, you can assign your own metadata to the resources that you create.
     * <p>
     * Each tag is a key-value pair. The specified tags are assigned to all backups created with this plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupPlanTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "backupPlanTags", value);
    }

    /**
     * To help organize your resources, you can assign your own metadata to the resources that you create.
     * <p>
     * Each tag is a key-value pair. The specified tags are assigned to all backups created with this plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupPlanTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "backupPlanTags", value);
    }
    /**
     * Specifies an object containing resource type and backup options.
     * <p>
     * This is only supported for Windows VSS backups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * Object backupOptions;
     * AdvancedBackupSettingResourceTypeProperty advancedBackupSettingResourceTypeProperty = AdvancedBackupSettingResourceTypeProperty.builder()
     *         .backupOptions(backupOptions)
     *         .resourceType("resourceType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_backup.CfnBackupPlan.AdvancedBackupSettingResourceTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedBackupSettingResourceTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedBackupSettingResourceTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The backup option for the resource.
         * <p>
         * Each option is a key-value pair.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBackupOptions();

        /**
         * The name of a resource type.
         * <p>
         * The only supported resource type is EC2.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

        /**
         * @return a {@link Builder} of {@link AdvancedBackupSettingResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedBackupSettingResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedBackupSettingResourceTypeProperty> {
            java.lang.Object backupOptions;
            java.lang.String resourceType;

            /**
             * Sets the value of {@link AdvancedBackupSettingResourceTypeProperty#getBackupOptions}
             * @param backupOptions The backup option for the resource. This parameter is required.
             *                      Each option is a key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupOptions(java.lang.Object backupOptions) {
                this.backupOptions = backupOptions;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedBackupSettingResourceTypeProperty#getResourceType}
             * @param resourceType The name of a resource type. This parameter is required.
             *                     The only supported resource type is EC2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedBackupSettingResourceTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedBackupSettingResourceTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedBackupSettingResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedBackupSettingResourceTypeProperty {
            private final java.lang.Object backupOptions;
            private final java.lang.String resourceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backupOptions = software.amazon.jsii.Kernel.get(this, "backupOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backupOptions = java.util.Objects.requireNonNull(builder.backupOptions, "backupOptions is required");
                this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
            }

            @Override
            public final java.lang.Object getBackupOptions() {
                return this.backupOptions;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("backupOptions", om.valueToTree(this.getBackupOptions()));
                data.set("resourceType", om.valueToTree(this.getResourceType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_backup.CfnBackupPlan.AdvancedBackupSettingResourceTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedBackupSettingResourceTypeProperty.Jsii$Proxy that = (AdvancedBackupSettingResourceTypeProperty.Jsii$Proxy) o;

                if (!backupOptions.equals(that.backupOptions)) return false;
                return this.resourceType.equals(that.resourceType);
            }

            @Override
            public final int hashCode() {
                int result = this.backupOptions.hashCode();
                result = 31 * result + (this.resourceType.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies an object containing properties used to create a backup plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * Object backupOptions;
     * BackupPlanResourceTypeProperty backupPlanResourceTypeProperty = BackupPlanResourceTypeProperty.builder()
     *         .backupPlanName("backupPlanName")
     *         .backupPlanRule(List.of(BackupRuleResourceTypeProperty.builder()
     *                 .ruleName("ruleName")
     *                 .targetBackupVault("targetBackupVault")
     *                 // the properties below are optional
     *                 .completionWindowMinutes(123)
     *                 .copyActions(List.of(CopyActionResourceTypeProperty.builder()
     *                         .destinationBackupVaultArn("destinationBackupVaultArn")
     *                         // the properties below are optional
     *                         .lifecycle(LifecycleResourceTypeProperty.builder()
     *                                 .deleteAfterDays(123)
     *                                 .moveToColdStorageAfterDays(123)
     *                                 .build())
     *                         .build()))
     *                 .enableContinuousBackup(false)
     *                 .lifecycle(LifecycleResourceTypeProperty.builder()
     *                         .deleteAfterDays(123)
     *                         .moveToColdStorageAfterDays(123)
     *                         .build())
     *                 .recoveryPointTags(Map.of(
     *                         "recoveryPointTagsKey", "recoveryPointTags"))
     *                 .scheduleExpression("scheduleExpression")
     *                 .startWindowMinutes(123)
     *                 .build()))
     *         // the properties below are optional
     *         .advancedBackupSettings(List.of(AdvancedBackupSettingResourceTypeProperty.builder()
     *                 .backupOptions(backupOptions)
     *                 .resourceType("resourceType")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_backup.CfnBackupPlan.BackupPlanResourceTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(BackupPlanResourceTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BackupPlanResourceTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The display name of a backup plan.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBackupPlanName();

        /**
         * An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBackupPlanRule();

        /**
         * A list of backup options for each resource type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedBackupSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BackupPlanResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BackupPlanResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BackupPlanResourceTypeProperty> {
            java.lang.String backupPlanName;
            java.lang.Object backupPlanRule;
            java.lang.Object advancedBackupSettings;

            /**
             * Sets the value of {@link BackupPlanResourceTypeProperty#getBackupPlanName}
             * @param backupPlanName The display name of a backup plan. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupPlanName(java.lang.String backupPlanName) {
                this.backupPlanName = backupPlanName;
                return this;
            }

            /**
             * Sets the value of {@link BackupPlanResourceTypeProperty#getBackupPlanRule}
             * @param backupPlanRule An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupPlanRule(software.amazon.awscdk.core.IResolvable backupPlanRule) {
                this.backupPlanRule = backupPlanRule;
                return this;
            }

            /**
             * Sets the value of {@link BackupPlanResourceTypeProperty#getBackupPlanRule}
             * @param backupPlanRule An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupPlanRule(java.util.List<? extends java.lang.Object> backupPlanRule) {
                this.backupPlanRule = backupPlanRule;
                return this;
            }

            /**
             * Sets the value of {@link BackupPlanResourceTypeProperty#getAdvancedBackupSettings}
             * @param advancedBackupSettings A list of backup options for each resource type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedBackupSettings(software.amazon.awscdk.core.IResolvable advancedBackupSettings) {
                this.advancedBackupSettings = advancedBackupSettings;
                return this;
            }

            /**
             * Sets the value of {@link BackupPlanResourceTypeProperty#getAdvancedBackupSettings}
             * @param advancedBackupSettings A list of backup options for each resource type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedBackupSettings(java.util.List<? extends java.lang.Object> advancedBackupSettings) {
                this.advancedBackupSettings = advancedBackupSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BackupPlanResourceTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BackupPlanResourceTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BackupPlanResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupPlanResourceTypeProperty {
            private final java.lang.String backupPlanName;
            private final java.lang.Object backupPlanRule;
            private final java.lang.Object advancedBackupSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backupPlanName = software.amazon.jsii.Kernel.get(this, "backupPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backupPlanRule = software.amazon.jsii.Kernel.get(this, "backupPlanRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.advancedBackupSettings = software.amazon.jsii.Kernel.get(this, "advancedBackupSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backupPlanName = java.util.Objects.requireNonNull(builder.backupPlanName, "backupPlanName is required");
                this.backupPlanRule = java.util.Objects.requireNonNull(builder.backupPlanRule, "backupPlanRule is required");
                this.advancedBackupSettings = builder.advancedBackupSettings;
            }

            @Override
            public final java.lang.String getBackupPlanName() {
                return this.backupPlanName;
            }

            @Override
            public final java.lang.Object getBackupPlanRule() {
                return this.backupPlanRule;
            }

            @Override
            public final java.lang.Object getAdvancedBackupSettings() {
                return this.advancedBackupSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("backupPlanName", om.valueToTree(this.getBackupPlanName()));
                data.set("backupPlanRule", om.valueToTree(this.getBackupPlanRule()));
                if (this.getAdvancedBackupSettings() != null) {
                    data.set("advancedBackupSettings", om.valueToTree(this.getAdvancedBackupSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_backup.CfnBackupPlan.BackupPlanResourceTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BackupPlanResourceTypeProperty.Jsii$Proxy that = (BackupPlanResourceTypeProperty.Jsii$Proxy) o;

                if (!backupPlanName.equals(that.backupPlanName)) return false;
                if (!backupPlanRule.equals(that.backupPlanRule)) return false;
                return this.advancedBackupSettings != null ? this.advancedBackupSettings.equals(that.advancedBackupSettings) : that.advancedBackupSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.backupPlanName.hashCode();
                result = 31 * result + (this.backupPlanRule.hashCode());
                result = 31 * result + (this.advancedBackupSettings != null ? this.advancedBackupSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an object containing properties used to schedule a task to back up a selection of resources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * BackupRuleResourceTypeProperty backupRuleResourceTypeProperty = BackupRuleResourceTypeProperty.builder()
     *         .ruleName("ruleName")
     *         .targetBackupVault("targetBackupVault")
     *         // the properties below are optional
     *         .completionWindowMinutes(123)
     *         .copyActions(List.of(CopyActionResourceTypeProperty.builder()
     *                 .destinationBackupVaultArn("destinationBackupVaultArn")
     *                 // the properties below are optional
     *                 .lifecycle(LifecycleResourceTypeProperty.builder()
     *                         .deleteAfterDays(123)
     *                         .moveToColdStorageAfterDays(123)
     *                         .build())
     *                 .build()))
     *         .enableContinuousBackup(false)
     *         .lifecycle(LifecycleResourceTypeProperty.builder()
     *                 .deleteAfterDays(123)
     *                 .moveToColdStorageAfterDays(123)
     *                 .build())
     *         .recoveryPointTags(Map.of(
     *                 "recoveryPointTagsKey", "recoveryPointTags"))
     *         .scheduleExpression("scheduleExpression")
     *         .startWindowMinutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_backup.CfnBackupPlan.BackupRuleResourceTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(BackupRuleResourceTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BackupRuleResourceTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A display name for a backup rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuleName();

        /**
         * The name of a logical container where backups are stored.
         * <p>
         * Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of letters, numbers, and hyphens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetBackupVault();

        /**
         * A value in minutes after a backup job is successfully started before it must be completed or it is canceled by AWS Backup .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCompletionWindowMinutes() {
            return null;
        }

        /**
         * An array of CopyAction objects, which contains the details of the copy operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyActions() {
            return null;
        }

        /**
         * Enables continuous backup and point-in-time restores (PITR).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableContinuousBackup() {
            return null;
        }

        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
         * <p>
         * AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLifecycle() {
            return null;
        }

        /**
         * To help organize your resources, you can assign your own metadata to the resources that you create.
         * <p>
         * Each tag is a key-value pair.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecoveryPointTags() {
            return null;
        }

        /**
         * A CRON expression specifying when AWS Backup initiates a backup job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
            return null;
        }

        /**
         * An optional value that specifies a period of time in minutes after a backup is scheduled before a job is canceled if it doesn't start successfully.
         * <p>
         * If this value is included, it must be at least 60 minutes to avoid errors.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartWindowMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BackupRuleResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BackupRuleResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BackupRuleResourceTypeProperty> {
            java.lang.String ruleName;
            java.lang.String targetBackupVault;
            java.lang.Number completionWindowMinutes;
            java.lang.Object copyActions;
            java.lang.Object enableContinuousBackup;
            java.lang.Object lifecycle;
            java.lang.Object recoveryPointTags;
            java.lang.String scheduleExpression;
            java.lang.Number startWindowMinutes;

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getRuleName}
             * @param ruleName A display name for a backup rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleName(java.lang.String ruleName) {
                this.ruleName = ruleName;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getTargetBackupVault}
             * @param targetBackupVault The name of a logical container where backups are stored. This parameter is required.
             *                          Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of letters, numbers, and hyphens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetBackupVault(java.lang.String targetBackupVault) {
                this.targetBackupVault = targetBackupVault;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getCompletionWindowMinutes}
             * @param completionWindowMinutes A value in minutes after a backup job is successfully started before it must be completed or it is canceled by AWS Backup .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder completionWindowMinutes(java.lang.Number completionWindowMinutes) {
                this.completionWindowMinutes = completionWindowMinutes;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getCopyActions}
             * @param copyActions An array of CopyAction objects, which contains the details of the copy operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyActions(software.amazon.awscdk.core.IResolvable copyActions) {
                this.copyActions = copyActions;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getCopyActions}
             * @param copyActions An array of CopyAction objects, which contains the details of the copy operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyActions(java.util.List<? extends java.lang.Object> copyActions) {
                this.copyActions = copyActions;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getEnableContinuousBackup}
             * @param enableContinuousBackup Enables continuous backup and point-in-time restores (PITR).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableContinuousBackup(java.lang.Boolean enableContinuousBackup) {
                this.enableContinuousBackup = enableContinuousBackup;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getEnableContinuousBackup}
             * @param enableContinuousBackup Enables continuous backup and point-in-time restores (PITR).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableContinuousBackup(software.amazon.awscdk.core.IResolvable enableContinuousBackup) {
                this.enableContinuousBackup = enableContinuousBackup;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getLifecycle}
             * @param lifecycle The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
             *                  AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycle(software.amazon.awscdk.services.backup.CfnBackupPlan.LifecycleResourceTypeProperty lifecycle) {
                this.lifecycle = lifecycle;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getLifecycle}
             * @param lifecycle The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
             *                  AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycle(software.amazon.awscdk.core.IResolvable lifecycle) {
                this.lifecycle = lifecycle;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getRecoveryPointTags}
             * @param recoveryPointTags To help organize your resources, you can assign your own metadata to the resources that you create.
             *                          Each tag is a key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryPointTags(software.amazon.awscdk.core.IResolvable recoveryPointTags) {
                this.recoveryPointTags = recoveryPointTags;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getRecoveryPointTags}
             * @param recoveryPointTags To help organize your resources, you can assign your own metadata to the resources that you create.
             *                          Each tag is a key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryPointTags(java.util.Map<java.lang.String, java.lang.String> recoveryPointTags) {
                this.recoveryPointTags = recoveryPointTags;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getScheduleExpression}
             * @param scheduleExpression A CRON expression specifying when AWS Backup initiates a backup job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Sets the value of {@link BackupRuleResourceTypeProperty#getStartWindowMinutes}
             * @param startWindowMinutes An optional value that specifies a period of time in minutes after a backup is scheduled before a job is canceled if it doesn't start successfully.
             *                           If this value is included, it must be at least 60 minutes to avoid errors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startWindowMinutes(java.lang.Number startWindowMinutes) {
                this.startWindowMinutes = startWindowMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BackupRuleResourceTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BackupRuleResourceTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BackupRuleResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupRuleResourceTypeProperty {
            private final java.lang.String ruleName;
            private final java.lang.String targetBackupVault;
            private final java.lang.Number completionWindowMinutes;
            private final java.lang.Object copyActions;
            private final java.lang.Object enableContinuousBackup;
            private final java.lang.Object lifecycle;
            private final java.lang.Object recoveryPointTags;
            private final java.lang.String scheduleExpression;
            private final java.lang.Number startWindowMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetBackupVault = software.amazon.jsii.Kernel.get(this, "targetBackupVault", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.completionWindowMinutes = software.amazon.jsii.Kernel.get(this, "completionWindowMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.copyActions = software.amazon.jsii.Kernel.get(this, "copyActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableContinuousBackup = software.amazon.jsii.Kernel.get(this, "enableContinuousBackup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recoveryPointTags = software.amazon.jsii.Kernel.get(this, "recoveryPointTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startWindowMinutes = software.amazon.jsii.Kernel.get(this, "startWindowMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleName = java.util.Objects.requireNonNull(builder.ruleName, "ruleName is required");
                this.targetBackupVault = java.util.Objects.requireNonNull(builder.targetBackupVault, "targetBackupVault is required");
                this.completionWindowMinutes = builder.completionWindowMinutes;
                this.copyActions = builder.copyActions;
                this.enableContinuousBackup = builder.enableContinuousBackup;
                this.lifecycle = builder.lifecycle;
                this.recoveryPointTags = builder.recoveryPointTags;
                this.scheduleExpression = builder.scheduleExpression;
                this.startWindowMinutes = builder.startWindowMinutes;
            }

            @Override
            public final java.lang.String getRuleName() {
                return this.ruleName;
            }

            @Override
            public final java.lang.String getTargetBackupVault() {
                return this.targetBackupVault;
            }

            @Override
            public final java.lang.Number getCompletionWindowMinutes() {
                return this.completionWindowMinutes;
            }

            @Override
            public final java.lang.Object getCopyActions() {
                return this.copyActions;
            }

            @Override
            public final java.lang.Object getEnableContinuousBackup() {
                return this.enableContinuousBackup;
            }

            @Override
            public final java.lang.Object getLifecycle() {
                return this.lifecycle;
            }

            @Override
            public final java.lang.Object getRecoveryPointTags() {
                return this.recoveryPointTags;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            public final java.lang.Number getStartWindowMinutes() {
                return this.startWindowMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ruleName", om.valueToTree(this.getRuleName()));
                data.set("targetBackupVault", om.valueToTree(this.getTargetBackupVault()));
                if (this.getCompletionWindowMinutes() != null) {
                    data.set("completionWindowMinutes", om.valueToTree(this.getCompletionWindowMinutes()));
                }
                if (this.getCopyActions() != null) {
                    data.set("copyActions", om.valueToTree(this.getCopyActions()));
                }
                if (this.getEnableContinuousBackup() != null) {
                    data.set("enableContinuousBackup", om.valueToTree(this.getEnableContinuousBackup()));
                }
                if (this.getLifecycle() != null) {
                    data.set("lifecycle", om.valueToTree(this.getLifecycle()));
                }
                if (this.getRecoveryPointTags() != null) {
                    data.set("recoveryPointTags", om.valueToTree(this.getRecoveryPointTags()));
                }
                if (this.getScheduleExpression() != null) {
                    data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                }
                if (this.getStartWindowMinutes() != null) {
                    data.set("startWindowMinutes", om.valueToTree(this.getStartWindowMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_backup.CfnBackupPlan.BackupRuleResourceTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BackupRuleResourceTypeProperty.Jsii$Proxy that = (BackupRuleResourceTypeProperty.Jsii$Proxy) o;

                if (!ruleName.equals(that.ruleName)) return false;
                if (!targetBackupVault.equals(that.targetBackupVault)) return false;
                if (this.completionWindowMinutes != null ? !this.completionWindowMinutes.equals(that.completionWindowMinutes) : that.completionWindowMinutes != null) return false;
                if (this.copyActions != null ? !this.copyActions.equals(that.copyActions) : that.copyActions != null) return false;
                if (this.enableContinuousBackup != null ? !this.enableContinuousBackup.equals(that.enableContinuousBackup) : that.enableContinuousBackup != null) return false;
                if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
                if (this.recoveryPointTags != null ? !this.recoveryPointTags.equals(that.recoveryPointTags) : that.recoveryPointTags != null) return false;
                if (this.scheduleExpression != null ? !this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression != null) return false;
                return this.startWindowMinutes != null ? this.startWindowMinutes.equals(that.startWindowMinutes) : that.startWindowMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ruleName.hashCode();
                result = 31 * result + (this.targetBackupVault.hashCode());
                result = 31 * result + (this.completionWindowMinutes != null ? this.completionWindowMinutes.hashCode() : 0);
                result = 31 * result + (this.copyActions != null ? this.copyActions.hashCode() : 0);
                result = 31 * result + (this.enableContinuousBackup != null ? this.enableContinuousBackup.hashCode() : 0);
                result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
                result = 31 * result + (this.recoveryPointTags != null ? this.recoveryPointTags.hashCode() : 0);
                result = 31 * result + (this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0);
                result = 31 * result + (this.startWindowMinutes != null ? this.startWindowMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Copies backups created by a backup rule to another vault.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * CopyActionResourceTypeProperty copyActionResourceTypeProperty = CopyActionResourceTypeProperty.builder()
     *         .destinationBackupVaultArn("destinationBackupVaultArn")
     *         // the properties below are optional
     *         .lifecycle(LifecycleResourceTypeProperty.builder()
     *                 .deleteAfterDays(123)
     *                 .moveToColdStorageAfterDays(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_backup.CfnBackupPlan.CopyActionResourceTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(CopyActionResourceTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CopyActionResourceTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup.
         * <p>
         * For example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationBackupVaultArn();

        /**
         * Defines when a protected resource is transitioned to cold storage and when it expires.
         * <p>
         * AWS Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, AWS Backup applies the lifecycle policy of the source backup to the destination backup.
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLifecycle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CopyActionResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CopyActionResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CopyActionResourceTypeProperty> {
            java.lang.String destinationBackupVaultArn;
            java.lang.Object lifecycle;

            /**
             * Sets the value of {@link CopyActionResourceTypeProperty#getDestinationBackupVaultArn}
             * @param destinationBackupVaultArn An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. This parameter is required.
             *                                  For example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationBackupVaultArn(java.lang.String destinationBackupVaultArn) {
                this.destinationBackupVaultArn = destinationBackupVaultArn;
                return this;
            }

            /**
             * Sets the value of {@link CopyActionResourceTypeProperty#getLifecycle}
             * @param lifecycle Defines when a protected resource is transitioned to cold storage and when it expires.
             *                  AWS Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, AWS Backup applies the lifecycle policy of the source backup to the destination backup.
             *                  <p>
             *                  Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycle(software.amazon.awscdk.services.backup.CfnBackupPlan.LifecycleResourceTypeProperty lifecycle) {
                this.lifecycle = lifecycle;
                return this;
            }

            /**
             * Sets the value of {@link CopyActionResourceTypeProperty#getLifecycle}
             * @param lifecycle Defines when a protected resource is transitioned to cold storage and when it expires.
             *                  AWS Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, AWS Backup applies the lifecycle policy of the source backup to the destination backup.
             *                  <p>
             *                  Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycle(software.amazon.awscdk.core.IResolvable lifecycle) {
                this.lifecycle = lifecycle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CopyActionResourceTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CopyActionResourceTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CopyActionResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CopyActionResourceTypeProperty {
            private final java.lang.String destinationBackupVaultArn;
            private final java.lang.Object lifecycle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationBackupVaultArn = software.amazon.jsii.Kernel.get(this, "destinationBackupVaultArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationBackupVaultArn = java.util.Objects.requireNonNull(builder.destinationBackupVaultArn, "destinationBackupVaultArn is required");
                this.lifecycle = builder.lifecycle;
            }

            @Override
            public final java.lang.String getDestinationBackupVaultArn() {
                return this.destinationBackupVaultArn;
            }

            @Override
            public final java.lang.Object getLifecycle() {
                return this.lifecycle;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationBackupVaultArn", om.valueToTree(this.getDestinationBackupVaultArn()));
                if (this.getLifecycle() != null) {
                    data.set("lifecycle", om.valueToTree(this.getLifecycle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_backup.CfnBackupPlan.CopyActionResourceTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CopyActionResourceTypeProperty.Jsii$Proxy that = (CopyActionResourceTypeProperty.Jsii$Proxy) o;

                if (!destinationBackupVaultArn.equals(that.destinationBackupVaultArn)) return false;
                return this.lifecycle != null ? this.lifecycle.equals(that.lifecycle) : that.lifecycle == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationBackupVaultArn.hashCode();
                result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an object containing an array of `Transition` objects that determine how long in days before a recovery point transitions to cold storage or is deleted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * LifecycleResourceTypeProperty lifecycleResourceTypeProperty = LifecycleResourceTypeProperty.builder()
     *         .deleteAfterDays(123)
     *         .moveToColdStorageAfterDays(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_backup.CfnBackupPlan.LifecycleResourceTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(LifecycleResourceTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LifecycleResourceTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number of days after creation that a recovery point is deleted.
         * <p>
         * Must be greater than <code>MoveToColdStorageAfterDays</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDeleteAfterDays() {
            return null;
        }

        /**
         * Specifies the number of days after creation that a recovery point is moved to cold storage.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMoveToColdStorageAfterDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LifecycleResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LifecycleResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LifecycleResourceTypeProperty> {
            java.lang.Number deleteAfterDays;
            java.lang.Number moveToColdStorageAfterDays;

            /**
             * Sets the value of {@link LifecycleResourceTypeProperty#getDeleteAfterDays}
             * @param deleteAfterDays Specifies the number of days after creation that a recovery point is deleted.
             *                        Must be greater than <code>MoveToColdStorageAfterDays</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteAfterDays(java.lang.Number deleteAfterDays) {
                this.deleteAfterDays = deleteAfterDays;
                return this;
            }

            /**
             * Sets the value of {@link LifecycleResourceTypeProperty#getMoveToColdStorageAfterDays}
             * @param moveToColdStorageAfterDays Specifies the number of days after creation that a recovery point is moved to cold storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder moveToColdStorageAfterDays(java.lang.Number moveToColdStorageAfterDays) {
                this.moveToColdStorageAfterDays = moveToColdStorageAfterDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleResourceTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LifecycleResourceTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LifecycleResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleResourceTypeProperty {
            private final java.lang.Number deleteAfterDays;
            private final java.lang.Number moveToColdStorageAfterDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteAfterDays = software.amazon.jsii.Kernel.get(this, "deleteAfterDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.moveToColdStorageAfterDays = software.amazon.jsii.Kernel.get(this, "moveToColdStorageAfterDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteAfterDays = builder.deleteAfterDays;
                this.moveToColdStorageAfterDays = builder.moveToColdStorageAfterDays;
            }

            @Override
            public final java.lang.Number getDeleteAfterDays() {
                return this.deleteAfterDays;
            }

            @Override
            public final java.lang.Number getMoveToColdStorageAfterDays() {
                return this.moveToColdStorageAfterDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteAfterDays() != null) {
                    data.set("deleteAfterDays", om.valueToTree(this.getDeleteAfterDays()));
                }
                if (this.getMoveToColdStorageAfterDays() != null) {
                    data.set("moveToColdStorageAfterDays", om.valueToTree(this.getMoveToColdStorageAfterDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_backup.CfnBackupPlan.LifecycleResourceTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LifecycleResourceTypeProperty.Jsii$Proxy that = (LifecycleResourceTypeProperty.Jsii$Proxy) o;

                if (this.deleteAfterDays != null ? !this.deleteAfterDays.equals(that.deleteAfterDays) : that.deleteAfterDays != null) return false;
                return this.moveToColdStorageAfterDays != null ? this.moveToColdStorageAfterDays.equals(that.moveToColdStorageAfterDays) : that.moveToColdStorageAfterDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteAfterDays != null ? this.deleteAfterDays.hashCode() : 0;
                result = 31 * result + (this.moveToColdStorageAfterDays != null ? this.moveToColdStorageAfterDays.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.CfnBackupPlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.CfnBackupPlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.backup.CfnBackupPlanProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.backup.CfnBackupPlanProps.Builder();
        }

        /**
         * Uniquely identifies the backup plan to be associated with the selection of resources.
         * <p>
         * @return {@code this}
         * @param backupPlan Uniquely identifies the backup plan to be associated with the selection of resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlan(final software.amazon.awscdk.services.backup.CfnBackupPlan.BackupPlanResourceTypeProperty backupPlan) {
            this.props.backupPlan(backupPlan);
            return this;
        }
        /**
         * Uniquely identifies the backup plan to be associated with the selection of resources.
         * <p>
         * @return {@code this}
         * @param backupPlan Uniquely identifies the backup plan to be associated with the selection of resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlan(final software.amazon.awscdk.core.IResolvable backupPlan) {
            this.props.backupPlan(backupPlan);
            return this;
        }

        /**
         * To help organize your resources, you can assign your own metadata to the resources that you create.
         * <p>
         * Each tag is a key-value pair. The specified tags are assigned to all backups created with this plan.
         * <p>
         * @return {@code this}
         * @param backupPlanTags To help organize your resources, you can assign your own metadata to the resources that you create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlanTags(final software.amazon.awscdk.core.IResolvable backupPlanTags) {
            this.props.backupPlanTags(backupPlanTags);
            return this;
        }
        /**
         * To help organize your resources, you can assign your own metadata to the resources that you create.
         * <p>
         * Each tag is a key-value pair. The specified tags are assigned to all backups created with this plan.
         * <p>
         * @return {@code this}
         * @param backupPlanTags To help organize your resources, you can assign your own metadata to the resources that you create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlanTags(final java.util.Map<java.lang.String, java.lang.String> backupPlanTags) {
            this.props.backupPlanTags(backupPlanTags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.backup.CfnBackupPlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.CfnBackupPlan build() {
            return new software.amazon.awscdk.services.backup.CfnBackupPlan(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
