package software.amazon.awscdk.services.batch;

/**
 * (experimental) Batch Compute Environment.
 * <p>
 * Defines a batch compute environment to run batch jobs on.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ComputeEnvironment myComputeEnv = ComputeEnvironment.Builder.create(this, "ComputeEnv")
 *         .computeResources(ComputeResources.builder()
 *                 .image(EcsOptimizedAmi.Builder.create()
 *                         .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                         .build())
 *                 .vpc(vpc)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.933Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_batch.ComputeEnvironment")
public class ComputeEnvironment extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.batch.IComputeEnvironment {

    protected ComputeEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ComputeEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ComputeEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ComputeEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ComputeEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Fetches an existing batch compute environment by its amazon resource name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param computeEnvironmentArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IComputeEnvironment fromComputeEnvironmentArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String computeEnvironmentArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.ComputeEnvironment.class, "fromComputeEnvironmentArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IComputeEnvironment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(computeEnvironmentArn, "computeEnvironmentArn is required") });
    }

    /**
     * (experimental) The ARN of this compute environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "computeEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of this compute environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentName() {
        return software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.batch.ComputeEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.ComputeEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.batch.ComputeEnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) A name for the compute environment.
         * <p>
         * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         * <p>
         * Default: - CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param computeEnvironmentName A name for the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeEnvironmentName(final java.lang.String computeEnvironmentName) {
            this.props().computeEnvironmentName(computeEnvironmentName);
            return this;
        }

        /**
         * (experimental) The details of the required compute resources for the managed compute environment.
         * <p>
         * If specified, and this is an unmanaged compute environment, will throw an error.
         * <p>
         * By default, AWS Batch managed compute environments use a recent, approved version of the
         * Amazon ECS-optimized AMI for compute resources.
         * <p>
         * Default: - CloudFormation defaults
         * <p>
         * @return {@code this}
         * @param computeResources The details of the required compute resources for the managed compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeResources(final software.amazon.awscdk.services.batch.ComputeResources computeResources) {
            this.props().computeResources(computeResources);
            return this;
        }

        /**
         * (experimental) The state of the compute environment.
         * <p>
         * If the state is set to true, then the compute
         * environment accepts jobs from a queue and can scale out automatically based on queues.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled The state of the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * (experimental) Determines if AWS should manage the allocation of compute resources for processing jobs.
         * <p>
         * If set to false, then you are in charge of providing the compute resource details.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param managed Determines if AWS should manage the allocation of compute resources for processing jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder managed(final java.lang.Boolean managed) {
            this.props().managed(managed);
            return this;
        }

        /**
         * (experimental) The IAM role used by Batch to make calls to other AWS services on your behalf for managing the resources that you use with the service.
         * <p>
         * By default, this role is created for you using
         * the AWS managed service policy for Batch.
         * <p>
         * Default: - Role using the 'service-role/AWSBatchServiceRole' policy.
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM role used by Batch to make calls to other AWS services on your behalf for managing the resources that you use with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props().serviceRole(serviceRole);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.ComputeEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.batch.ComputeEnvironment build() {
            return new software.amazon.awscdk.services.batch.ComputeEnvironment(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.batch.ComputeEnvironmentProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.batch.ComputeEnvironmentProps.Builder();
            }
            return this.props;
        }
    }
}
