package software.amazon.awscdk.services.batch;

/**
 * (experimental) Properties for defining the structure of the batch compute cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ComputeEnvironment myComputeEnv = ComputeEnvironment.Builder.create(this, "ComputeEnv")
 *         .computeResources(ComputeResources.builder()
 *                 .image(EcsOptimizedAmi.Builder.create()
 *                         .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                         .build())
 *                 .vpc(vpc)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.937Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_batch.ComputeResources")
@software.amazon.jsii.Jsii.Proxy(ComputeResources.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ComputeResources extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The VPC network that all compute resources will be connected to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * (experimental) The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated.
     * <p>
     * This could be due to availability of the instance type in
     * the region or Amazon EC2 service limits. If this is not specified, the default for the EC2
     * ComputeResourceType is BEST_FIT, which will use only the best fitting instance type, waiting for
     * additional capacity if it's not available. This allocation strategy keeps costs lower but can limit
     * scaling. If you are using Spot Fleets with BEST_FIT then the Spot Fleet IAM Role must be specified.
     * BEST_FIT_PROGRESSIVE will select an additional instance type that is large enough to meet the
     * requirements of the jobs in the queue, with a preference for an instance type with a lower cost.
     * The default value for the SPOT instance type is SPOT_CAPACITY_OPTIMIZED, which is only available for
     * for this type of compute resources and will select an additional instance type that is large enough
     * to meet the requirements of the jobs in the queue, with a preference for an instance type that is
     * less likely to be interrupted.
     * <p>
     * Default: AllocationStrategy.BEST_FIT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.AllocationStrategy getAllocationStrategy() {
        return null;
    }

    /**
     * (experimental) This property will be ignored if you set the environment type to ON_DEMAND.
     * <p>
     * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for
     * that instance type before instances are launched. For example, if your maximum percentage is 20%,
     * then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. You always
     * pay the lowest (market) price and never more than your maximum percentage. If you leave this field empty,
     * the default value is 100% of the On-Demand price.
     * <p>
     * Default: 100
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBidPercentage() {
        return null;
    }

    /**
     * (experimental) Key-value pair tags to be applied to resources that are launched in the compute environment.
     * <p>
     * For AWS Batch, these take the form of "String1": "String2", where String1 is the tag key and
     * String2 is the tag value—for example, { "Name": "AWS Batch Instance - C4OnDemand" }.
     * <p>
     * Default: - no tags will be assigned on compute resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getComputeResourcesTags() {
        return null;
    }

    /**
     * (experimental) The desired number of EC2 vCPUS in the compute environment.
     * <p>
     * Default: - no desired vcpu value will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredvCpus() {
        return null;
    }

    /**
     * (experimental) The EC2 key pair that is used for instances launched in the compute environment.
     * <p>
     * If no key is defined, then SSH access is not allowed to provisioned compute resources.
     * <p>
     * Default: - no SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getEc2KeyPair() {
        return null;
    }

    /**
     * (experimental) The Amazon Machine Image (AMI) ID used for instances launched in the compute environment.
     * <p>
     * Default: - no image will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IMachineImage getImage() {
        return null;
    }

    /**
     * (experimental) The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment.
     * <p>
     * You can specify
     * the short name or full Amazon Resource Name (ARN) of an instance profile. For example, ecsInstanceRole or
     * arn:aws:iam::&lt;aws_account_id&gt;:instance-profile/ecsInstanceRole . For more information, see Amazon ECS
     * Instance Role in the AWS Batch User Guide.
     * <p>
     * Default: - a new role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceRole() {
        return null;
    }

    /**
     * (experimental) The types of EC2 instances that may be launched in the compute environment.
     * <p>
     * You can specify instance
     * families to launch any instance type within those families (for example, c4 or p3), or you can specify
     * specific sizes within a family (such as c4.8xlarge). You can also choose optimal to pick instance types
     * (from the C, M, and R instance families) on the fly that match the demand of your job queues.
     * <p>
     * Default: optimal
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.InstanceType> getInstanceTypes() {
        return null;
    }

    /**
     * (experimental) An optional launch template to associate with your compute resources.
     * <p>
     * For more information, see README file.
     * <p>
     * Default: - no custom launch template will be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.LaunchTemplateSpecification getLaunchTemplate() {
        return null;
    }

    /**
     * (experimental) The maximum number of EC2 vCPUs that an environment can reach.
     * <p>
     * Each vCPU is equivalent to
     * 1,024 CPU shares. You must specify at least one vCPU.
     * <p>
     * Default: 256
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxvCpus() {
        return null;
    }

    /**
     * (experimental) The minimum number of EC2 vCPUs that an environment should maintain (even if the compute environment state is DISABLED).
     * <p>
     * Each vCPU is equivalent to 1,024 CPU shares. By keeping this set to 0 you will not have instance time wasted when
     * there is no work to be run. If you set this above zero you will maintain that number of vCPUs at all times.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinvCpus() {
        return null;
    }

    /**
     * (experimental) The Amazon EC2 placement group to associate with your compute resources.
     * <p>
     * Default: - No placement group will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroup() {
        return null;
    }

    /**
     * (experimental) The EC2 security group(s) associated with instances launched in the compute environment.
     * <p>
     * Default: - AWS default security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * (experimental) This property will be ignored if you set the environment type to ON_DEMAND.
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment.
     * For more information, see Amazon EC2 Spot Fleet Role in the AWS Batch User Guide.
     * <p>
     * Default: - no fleet role will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getSpotFleetRole() {
        return null;
    }

    /**
     * (experimental) The type of compute environment: ON_DEMAND, SPOT, FARGATE, or FARGATE_SPOT.
     * <p>
     * Default: ON_DEMAND
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ComputeResourceType getType() {
        return null;
    }

    /**
     * (experimental) The VPC subnets into which the compute resources are launched.
     * <p>
     * Default: - private subnets of the supplied VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeResources}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeResources}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeResources> {
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.batch.AllocationStrategy allocationStrategy;
        java.lang.Number bidPercentage;
        java.util.Map<java.lang.String, java.lang.String> computeResourcesTags;
        java.lang.Number desiredvCpus;
        java.lang.String ec2KeyPair;
        software.amazon.awscdk.services.ec2.IMachineImage image;
        java.lang.String instanceRole;
        java.util.List<software.amazon.awscdk.services.ec2.InstanceType> instanceTypes;
        software.amazon.awscdk.services.batch.LaunchTemplateSpecification launchTemplate;
        java.lang.Number maxvCpus;
        java.lang.Number minvCpus;
        java.lang.String placementGroup;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.iam.IRole spotFleetRole;
        software.amazon.awscdk.services.batch.ComputeResourceType type;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link ComputeResources#getVpc}
         * @param vpc The VPC network that all compute resources will be connected to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getAllocationStrategy}
         * @param allocationStrategy The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated.
         *                           This could be due to availability of the instance type in
         *                           the region or Amazon EC2 service limits. If this is not specified, the default for the EC2
         *                           ComputeResourceType is BEST_FIT, which will use only the best fitting instance type, waiting for
         *                           additional capacity if it's not available. This allocation strategy keeps costs lower but can limit
         *                           scaling. If you are using Spot Fleets with BEST_FIT then the Spot Fleet IAM Role must be specified.
         *                           BEST_FIT_PROGRESSIVE will select an additional instance type that is large enough to meet the
         *                           requirements of the jobs in the queue, with a preference for an instance type with a lower cost.
         *                           The default value for the SPOT instance type is SPOT_CAPACITY_OPTIMIZED, which is only available for
         *                           for this type of compute resources and will select an additional instance type that is large enough
         *                           to meet the requirements of the jobs in the queue, with a preference for an instance type that is
         *                           less likely to be interrupted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allocationStrategy(software.amazon.awscdk.services.batch.AllocationStrategy allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getBidPercentage}
         * @param bidPercentage This property will be ignored if you set the environment type to ON_DEMAND.
         *                      The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for
         *                      that instance type before instances are launched. For example, if your maximum percentage is 20%,
         *                      then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. You always
         *                      pay the lowest (market) price and never more than your maximum percentage. If you leave this field empty,
         *                      the default value is 100% of the On-Demand price.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bidPercentage(java.lang.Number bidPercentage) {
            this.bidPercentage = bidPercentage;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getComputeResourcesTags}
         * @param computeResourcesTags Key-value pair tags to be applied to resources that are launched in the compute environment.
         *                             For AWS Batch, these take the form of "String1": "String2", where String1 is the tag key and
         *                             String2 is the tag value—for example, { "Name": "AWS Batch Instance - C4OnDemand" }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeResourcesTags(java.util.Map<java.lang.String, java.lang.String> computeResourcesTags) {
            this.computeResourcesTags = computeResourcesTags;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getDesiredvCpus}
         * @param desiredvCpus The desired number of EC2 vCPUS in the compute environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder desiredvCpus(java.lang.Number desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getEc2KeyPair}
         * @param ec2KeyPair The EC2 key pair that is used for instances launched in the compute environment.
         *                   If no key is defined, then SSH access is not allowed to provisioned compute resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ec2KeyPair(java.lang.String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getImage}
         * @param image The Amazon Machine Image (AMI) ID used for instances launched in the compute environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(software.amazon.awscdk.services.ec2.IMachineImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getInstanceRole}
         * @param instanceRole The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment.
         *                     You can specify
         *                     the short name or full Amazon Resource Name (ARN) of an instance profile. For example, ecsInstanceRole or
         *                     arn:aws:iam::&lt;aws_account_id&gt;:instance-profile/ecsInstanceRole . For more information, see Amazon ECS
         *                     Instance Role in the AWS Batch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceRole(java.lang.String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getInstanceTypes}
         * @param instanceTypes The types of EC2 instances that may be launched in the compute environment.
         *                      You can specify instance
         *                      families to launch any instance type within those families (for example, c4 or p3), or you can specify
         *                      specific sizes within a family (such as c4.8xlarge). You can also choose optimal to pick instance types
         *                      (from the C, M, and R instance families) on the fly that match the demand of your job queues.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder instanceTypes(java.util.List<? extends software.amazon.awscdk.services.ec2.InstanceType> instanceTypes) {
            this.instanceTypes = (java.util.List<software.amazon.awscdk.services.ec2.InstanceType>)instanceTypes;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getLaunchTemplate}
         * @param launchTemplate An optional launch template to associate with your compute resources.
         *                       For more information, see README file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder launchTemplate(software.amazon.awscdk.services.batch.LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getMaxvCpus}
         * @param maxvCpus The maximum number of EC2 vCPUs that an environment can reach.
         *                 Each vCPU is equivalent to
         *                 1,024 CPU shares. You must specify at least one vCPU.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxvCpus(java.lang.Number maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getMinvCpus}
         * @param minvCpus The minimum number of EC2 vCPUs that an environment should maintain (even if the compute environment state is DISABLED).
         *                 Each vCPU is equivalent to 1,024 CPU shares. By keeping this set to 0 you will not have instance time wasted when
         *                 there is no work to be run. If you set this above zero you will maintain that number of vCPUs at all times.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minvCpus(java.lang.Number minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getPlacementGroup}
         * @param placementGroup The Amazon EC2 placement group to associate with your compute resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder placementGroup(java.lang.String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getSecurityGroups}
         * @param securityGroups The EC2 security group(s) associated with instances launched in the compute environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getSpotFleetRole}
         * @param spotFleetRole This property will be ignored if you set the environment type to ON_DEMAND.
         *                      The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment.
         *                      For more information, see Amazon EC2 Spot Fleet Role in the AWS Batch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder spotFleetRole(software.amazon.awscdk.services.iam.IRole spotFleetRole) {
            this.spotFleetRole = spotFleetRole;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getType}
         * @param type The type of compute environment: ON_DEMAND, SPOT, FARGATE, or FARGATE_SPOT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(software.amazon.awscdk.services.batch.ComputeResourceType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ComputeResources#getVpcSubnets}
         * @param vpcSubnets The VPC subnets into which the compute resources are launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeResources}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ComputeResources build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeResources}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeResources {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.batch.AllocationStrategy allocationStrategy;
        private final java.lang.Number bidPercentage;
        private final java.util.Map<java.lang.String, java.lang.String> computeResourcesTags;
        private final java.lang.Number desiredvCpus;
        private final java.lang.String ec2KeyPair;
        private final software.amazon.awscdk.services.ec2.IMachineImage image;
        private final java.lang.String instanceRole;
        private final java.util.List<software.amazon.awscdk.services.ec2.InstanceType> instanceTypes;
        private final software.amazon.awscdk.services.batch.LaunchTemplateSpecification launchTemplate;
        private final java.lang.Number maxvCpus;
        private final java.lang.Number minvCpus;
        private final java.lang.String placementGroup;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.iam.IRole spotFleetRole;
        private final software.amazon.awscdk.services.batch.ComputeResourceType type;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.AllocationStrategy.class));
            this.bidPercentage = software.amazon.jsii.Kernel.get(this, "bidPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.computeResourcesTags = software.amazon.jsii.Kernel.get(this, "computeResourcesTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.desiredvCpus = software.amazon.jsii.Kernel.get(this, "desiredvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ec2KeyPair = software.amazon.jsii.Kernel.get(this, "ec2KeyPair", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
            this.instanceRole = software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceTypes = software.amazon.jsii.Kernel.get(this, "instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class)));
            this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LaunchTemplateSpecification.class));
            this.maxvCpus = software.amazon.jsii.Kernel.get(this, "maxvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minvCpus = software.amazon.jsii.Kernel.get(this, "minvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.placementGroup = software.amazon.jsii.Kernel.get(this, "placementGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.spotFleetRole = software.amazon.jsii.Kernel.get(this, "spotFleetRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ComputeResourceType.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.allocationStrategy = builder.allocationStrategy;
            this.bidPercentage = builder.bidPercentage;
            this.computeResourcesTags = builder.computeResourcesTags;
            this.desiredvCpus = builder.desiredvCpus;
            this.ec2KeyPair = builder.ec2KeyPair;
            this.image = builder.image;
            this.instanceRole = builder.instanceRole;
            this.instanceTypes = (java.util.List<software.amazon.awscdk.services.ec2.InstanceType>)builder.instanceTypes;
            this.launchTemplate = builder.launchTemplate;
            this.maxvCpus = builder.maxvCpus;
            this.minvCpus = builder.minvCpus;
            this.placementGroup = builder.placementGroup;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.spotFleetRole = builder.spotFleetRole;
            this.type = builder.type;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.batch.AllocationStrategy getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final java.lang.Number getBidPercentage() {
            return this.bidPercentage;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getComputeResourcesTags() {
            return this.computeResourcesTags;
        }

        @Override
        public final java.lang.Number getDesiredvCpus() {
            return this.desiredvCpus;
        }

        @Override
        public final java.lang.String getEc2KeyPair() {
            return this.ec2KeyPair;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IMachineImage getImage() {
            return this.image;
        }

        @Override
        public final java.lang.String getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.InstanceType> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final software.amazon.awscdk.services.batch.LaunchTemplateSpecification getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Override
        public final java.lang.Number getMaxvCpus() {
            return this.maxvCpus;
        }

        @Override
        public final java.lang.Number getMinvCpus() {
            return this.minvCpus;
        }

        @Override
        public final java.lang.String getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getSpotFleetRole() {
            return this.spotFleetRole;
        }

        @Override
        public final software.amazon.awscdk.services.batch.ComputeResourceType getType() {
            return this.type;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAllocationStrategy() != null) {
                data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
            }
            if (this.getBidPercentage() != null) {
                data.set("bidPercentage", om.valueToTree(this.getBidPercentage()));
            }
            if (this.getComputeResourcesTags() != null) {
                data.set("computeResourcesTags", om.valueToTree(this.getComputeResourcesTags()));
            }
            if (this.getDesiredvCpus() != null) {
                data.set("desiredvCpus", om.valueToTree(this.getDesiredvCpus()));
            }
            if (this.getEc2KeyPair() != null) {
                data.set("ec2KeyPair", om.valueToTree(this.getEc2KeyPair()));
            }
            if (this.getImage() != null) {
                data.set("image", om.valueToTree(this.getImage()));
            }
            if (this.getInstanceRole() != null) {
                data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
            }
            if (this.getInstanceTypes() != null) {
                data.set("instanceTypes", om.valueToTree(this.getInstanceTypes()));
            }
            if (this.getLaunchTemplate() != null) {
                data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
            }
            if (this.getMaxvCpus() != null) {
                data.set("maxvCpus", om.valueToTree(this.getMaxvCpus()));
            }
            if (this.getMinvCpus() != null) {
                data.set("minvCpus", om.valueToTree(this.getMinvCpus()));
            }
            if (this.getPlacementGroup() != null) {
                data.set("placementGroup", om.valueToTree(this.getPlacementGroup()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSpotFleetRole() != null) {
                data.set("spotFleetRole", om.valueToTree(this.getSpotFleetRole()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_batch.ComputeResources"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeResources.Jsii$Proxy that = (ComputeResources.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
            if (this.bidPercentage != null ? !this.bidPercentage.equals(that.bidPercentage) : that.bidPercentage != null) return false;
            if (this.computeResourcesTags != null ? !this.computeResourcesTags.equals(that.computeResourcesTags) : that.computeResourcesTags != null) return false;
            if (this.desiredvCpus != null ? !this.desiredvCpus.equals(that.desiredvCpus) : that.desiredvCpus != null) return false;
            if (this.ec2KeyPair != null ? !this.ec2KeyPair.equals(that.ec2KeyPair) : that.ec2KeyPair != null) return false;
            if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
            if (this.instanceRole != null ? !this.instanceRole.equals(that.instanceRole) : that.instanceRole != null) return false;
            if (this.instanceTypes != null ? !this.instanceTypes.equals(that.instanceTypes) : that.instanceTypes != null) return false;
            if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
            if (this.maxvCpus != null ? !this.maxvCpus.equals(that.maxvCpus) : that.maxvCpus != null) return false;
            if (this.minvCpus != null ? !this.minvCpus.equals(that.minvCpus) : that.minvCpus != null) return false;
            if (this.placementGroup != null ? !this.placementGroup.equals(that.placementGroup) : that.placementGroup != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.spotFleetRole != null ? !this.spotFleetRole.equals(that.spotFleetRole) : that.spotFleetRole != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0);
            result = 31 * result + (this.bidPercentage != null ? this.bidPercentage.hashCode() : 0);
            result = 31 * result + (this.computeResourcesTags != null ? this.computeResourcesTags.hashCode() : 0);
            result = 31 * result + (this.desiredvCpus != null ? this.desiredvCpus.hashCode() : 0);
            result = 31 * result + (this.ec2KeyPair != null ? this.ec2KeyPair.hashCode() : 0);
            result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
            result = 31 * result + (this.instanceRole != null ? this.instanceRole.hashCode() : 0);
            result = 31 * result + (this.instanceTypes != null ? this.instanceTypes.hashCode() : 0);
            result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
            result = 31 * result + (this.maxvCpus != null ? this.maxvCpus.hashCode() : 0);
            result = 31 * result + (this.minvCpus != null ? this.minvCpus.hashCode() : 0);
            result = 31 * result + (this.placementGroup != null ? this.placementGroup.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.spotFleetRole != null ? this.spotFleetRole.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
