package software.amazon.awscdk.services.billingconductor;

/**
 * A CloudFormation `AWS::BillingConductor::CustomLineItem`.
 * <p>
 * Creates a custom line item that can be used to create a one-time or recurring, fixed or percentage-based charge that you can apply to a single billing group. You can apply custom line items to the current or previous billing period. You can create either a fee or a discount custom line item.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.billingconductor.*;
 * CfnCustomLineItem cfnCustomLineItem = CfnCustomLineItem.Builder.create(this, "MyCfnCustomLineItem")
 *         .billingGroupArn("billingGroupArn")
 *         .name("name")
 *         // the properties below are optional
 *         .billingPeriodRange(BillingPeriodRangeProperty.builder()
 *                 .exclusiveEndBillingPeriod("exclusiveEndBillingPeriod")
 *                 .inclusiveStartBillingPeriod("inclusiveStartBillingPeriod")
 *                 .build())
 *         .customLineItemChargeDetails(CustomLineItemChargeDetailsProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .flat(CustomLineItemFlatChargeDetailsProperty.builder()
 *                         .chargeValue(123)
 *                         .build())
 *                 .percentage(CustomLineItemPercentageChargeDetailsProperty.builder()
 *                         .percentageValue(123)
 *                         // the properties below are optional
 *                         .childAssociatedResources(List.of("childAssociatedResources"))
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.963Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_billingconductor.CfnCustomLineItem")
public class CfnCustomLineItem extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCustomLineItem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCustomLineItem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::BillingConductor::CustomLineItem`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCustomLineItem(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.billingconductor.CfnCustomLineItemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of resources that are associated to the custom line item.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrAssociationSize() {
        return software.amazon.jsii.Kernel.get(this, "attrAssociationSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The time created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The custom line item's charge value currency.
     * <p>
     * Only one of the valid values can be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCurrencyCode() {
        return software.amazon.jsii.Kernel.get(this, "attrCurrencyCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The most recent time the custom line item was modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The product code associated with the custom line item.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProductCode() {
        return software.amazon.jsii.Kernel.get(this, "attrProductCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A map that contains tag keys and tag values that are attached to a custom line item.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBillingGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "billingGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingGroupArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "billingGroupArn", java.util.Objects.requireNonNull(value, "billingGroupArn is required"));
    }

    /**
     * The custom line item's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The custom line item's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A time range for which the custom line item is effective.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBillingPeriodRange() {
        return software.amazon.jsii.Kernel.get(this, "billingPeriodRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A time range for which the custom line item is effective.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingPeriodRange(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.BillingPeriodRangeProperty value) {
        software.amazon.jsii.Kernel.set(this, "billingPeriodRange", value);
    }

    /**
     * A time range for which the custom line item is effective.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingPeriodRange(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "billingPeriodRange", value);
    }

    /**
     * The charge details of a custom line item.
     * <p>
     * It should contain only one of <code>Flat</code> or <code>Percentage</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomLineItemChargeDetails() {
        return software.amazon.jsii.Kernel.get(this, "customLineItemChargeDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The charge details of a custom line item.
     * <p>
     * It should contain only one of <code>Flat</code> or <code>Percentage</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomLineItemChargeDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.CustomLineItemChargeDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "customLineItemChargeDetails", value);
    }

    /**
     * The charge details of a custom line item.
     * <p>
     * It should contain only one of <code>Flat</code> or <code>Percentage</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomLineItemChargeDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customLineItemChargeDetails", value);
    }

    /**
     * The custom line item's description.
     * <p>
     * This is shown on the Bills page in association with the charge value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The custom line item's description.
     * <p>
     * This is shown on the Bills page in association with the charge value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * The billing period range in which the custom line item request will be applied.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.billingconductor.*;
     * BillingPeriodRangeProperty billingPeriodRangeProperty = BillingPeriodRangeProperty.builder()
     *         .exclusiveEndBillingPeriod("exclusiveEndBillingPeriod")
     *         .inclusiveStartBillingPeriod("inclusiveStartBillingPeriod")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_billingconductor.CfnCustomLineItem.BillingPeriodRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(BillingPeriodRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BillingPeriodRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The exclusive end billing period that defines a billing period range where a custom line is applied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExclusiveEndBillingPeriod() {
            return null;
        }

        /**
         * The inclusive start billing period that defines a billing period range where a custom line is applied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInclusiveStartBillingPeriod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BillingPeriodRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BillingPeriodRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BillingPeriodRangeProperty> {
            java.lang.String exclusiveEndBillingPeriod;
            java.lang.String inclusiveStartBillingPeriod;

            /**
             * Sets the value of {@link BillingPeriodRangeProperty#getExclusiveEndBillingPeriod}
             * @param exclusiveEndBillingPeriod The exclusive end billing period that defines a billing period range where a custom line is applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusiveEndBillingPeriod(java.lang.String exclusiveEndBillingPeriod) {
                this.exclusiveEndBillingPeriod = exclusiveEndBillingPeriod;
                return this;
            }

            /**
             * Sets the value of {@link BillingPeriodRangeProperty#getInclusiveStartBillingPeriod}
             * @param inclusiveStartBillingPeriod The inclusive start billing period that defines a billing period range where a custom line is applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusiveStartBillingPeriod(java.lang.String inclusiveStartBillingPeriod) {
                this.inclusiveStartBillingPeriod = inclusiveStartBillingPeriod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BillingPeriodRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BillingPeriodRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BillingPeriodRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BillingPeriodRangeProperty {
            private final java.lang.String exclusiveEndBillingPeriod;
            private final java.lang.String inclusiveStartBillingPeriod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exclusiveEndBillingPeriod = software.amazon.jsii.Kernel.get(this, "exclusiveEndBillingPeriod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inclusiveStartBillingPeriod = software.amazon.jsii.Kernel.get(this, "inclusiveStartBillingPeriod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exclusiveEndBillingPeriod = builder.exclusiveEndBillingPeriod;
                this.inclusiveStartBillingPeriod = builder.inclusiveStartBillingPeriod;
            }

            @Override
            public final java.lang.String getExclusiveEndBillingPeriod() {
                return this.exclusiveEndBillingPeriod;
            }

            @Override
            public final java.lang.String getInclusiveStartBillingPeriod() {
                return this.inclusiveStartBillingPeriod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExclusiveEndBillingPeriod() != null) {
                    data.set("exclusiveEndBillingPeriod", om.valueToTree(this.getExclusiveEndBillingPeriod()));
                }
                if (this.getInclusiveStartBillingPeriod() != null) {
                    data.set("inclusiveStartBillingPeriod", om.valueToTree(this.getInclusiveStartBillingPeriod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_billingconductor.CfnCustomLineItem.BillingPeriodRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BillingPeriodRangeProperty.Jsii$Proxy that = (BillingPeriodRangeProperty.Jsii$Proxy) o;

                if (this.exclusiveEndBillingPeriod != null ? !this.exclusiveEndBillingPeriod.equals(that.exclusiveEndBillingPeriod) : that.exclusiveEndBillingPeriod != null) return false;
                return this.inclusiveStartBillingPeriod != null ? this.inclusiveStartBillingPeriod.equals(that.inclusiveStartBillingPeriod) : that.inclusiveStartBillingPeriod == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exclusiveEndBillingPeriod != null ? this.exclusiveEndBillingPeriod.hashCode() : 0;
                result = 31 * result + (this.inclusiveStartBillingPeriod != null ? this.inclusiveStartBillingPeriod.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The charge details of a custom line item.
     * <p>
     * It should contain only one of <code>Flat</code> or <code>Percentage</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.billingconductor.*;
     * CustomLineItemChargeDetailsProperty customLineItemChargeDetailsProperty = CustomLineItemChargeDetailsProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .flat(CustomLineItemFlatChargeDetailsProperty.builder()
     *                 .chargeValue(123)
     *                 .build())
     *         .percentage(CustomLineItemPercentageChargeDetailsProperty.builder()
     *                 .percentageValue(123)
     *                 // the properties below are optional
     *                 .childAssociatedResources(List.of("childAssociatedResources"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_billingconductor.CfnCustomLineItem.CustomLineItemChargeDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomLineItemChargeDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomLineItemChargeDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the custom line item that indicates whether the charge is a fee or credit.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A `CustomLineItemFlatChargeDetails` that describes the charge details of a flat custom line item.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFlat() {
            return null;
        }

        /**
         * A `CustomLineItemPercentageChargeDetails` that describes the charge details of a percentage custom line item.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPercentage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomLineItemChargeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomLineItemChargeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomLineItemChargeDetailsProperty> {
            java.lang.String type;
            java.lang.Object flat;
            java.lang.Object percentage;

            /**
             * Sets the value of {@link CustomLineItemChargeDetailsProperty#getType}
             * @param type The type of the custom line item that indicates whether the charge is a fee or credit. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link CustomLineItemChargeDetailsProperty#getFlat}
             * @param flat A `CustomLineItemFlatChargeDetails` that describes the charge details of a flat custom line item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flat(software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.CustomLineItemFlatChargeDetailsProperty flat) {
                this.flat = flat;
                return this;
            }

            /**
             * Sets the value of {@link CustomLineItemChargeDetailsProperty#getFlat}
             * @param flat A `CustomLineItemFlatChargeDetails` that describes the charge details of a flat custom line item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flat(software.amazon.awscdk.core.IResolvable flat) {
                this.flat = flat;
                return this;
            }

            /**
             * Sets the value of {@link CustomLineItemChargeDetailsProperty#getPercentage}
             * @param percentage A `CustomLineItemPercentageChargeDetails` that describes the charge details of a percentage custom line item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentage(software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.CustomLineItemPercentageChargeDetailsProperty percentage) {
                this.percentage = percentage;
                return this;
            }

            /**
             * Sets the value of {@link CustomLineItemChargeDetailsProperty#getPercentage}
             * @param percentage A `CustomLineItemPercentageChargeDetails` that describes the charge details of a percentage custom line item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentage(software.amazon.awscdk.core.IResolvable percentage) {
                this.percentage = percentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomLineItemChargeDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomLineItemChargeDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomLineItemChargeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomLineItemChargeDetailsProperty {
            private final java.lang.String type;
            private final java.lang.Object flat;
            private final java.lang.Object percentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.flat = software.amazon.jsii.Kernel.get(this, "flat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.percentage = software.amazon.jsii.Kernel.get(this, "percentage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.flat = builder.flat;
                this.percentage = builder.percentage;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getFlat() {
                return this.flat;
            }

            @Override
            public final java.lang.Object getPercentage() {
                return this.percentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getFlat() != null) {
                    data.set("flat", om.valueToTree(this.getFlat()));
                }
                if (this.getPercentage() != null) {
                    data.set("percentage", om.valueToTree(this.getPercentage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_billingconductor.CfnCustomLineItem.CustomLineItemChargeDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomLineItemChargeDetailsProperty.Jsii$Proxy that = (CustomLineItemChargeDetailsProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.flat != null ? !this.flat.equals(that.flat) : that.flat != null) return false;
                return this.percentage != null ? this.percentage.equals(that.percentage) : that.percentage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.flat != null ? this.flat.hashCode() : 0);
                result = 31 * result + (this.percentage != null ? this.percentage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The charge details of a custom line item.
     * <p>
     * It should contain only one of <code>Flat</code> or <code>Percentage</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.billingconductor.*;
     * CustomLineItemFlatChargeDetailsProperty customLineItemFlatChargeDetailsProperty = CustomLineItemFlatChargeDetailsProperty.builder()
     *         .chargeValue(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_billingconductor.CfnCustomLineItem.CustomLineItemFlatChargeDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomLineItemFlatChargeDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomLineItemFlatChargeDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom line item's fixed charge value in USD.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getChargeValue();

        /**
         * @return a {@link Builder} of {@link CustomLineItemFlatChargeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomLineItemFlatChargeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomLineItemFlatChargeDetailsProperty> {
            java.lang.Number chargeValue;

            /**
             * Sets the value of {@link CustomLineItemFlatChargeDetailsProperty#getChargeValue}
             * @param chargeValue The custom line item's fixed charge value in USD. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chargeValue(java.lang.Number chargeValue) {
                this.chargeValue = chargeValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomLineItemFlatChargeDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomLineItemFlatChargeDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomLineItemFlatChargeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomLineItemFlatChargeDetailsProperty {
            private final java.lang.Number chargeValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.chargeValue = software.amazon.jsii.Kernel.get(this, "chargeValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.chargeValue = java.util.Objects.requireNonNull(builder.chargeValue, "chargeValue is required");
            }

            @Override
            public final java.lang.Number getChargeValue() {
                return this.chargeValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("chargeValue", om.valueToTree(this.getChargeValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_billingconductor.CfnCustomLineItem.CustomLineItemFlatChargeDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomLineItemFlatChargeDetailsProperty.Jsii$Proxy that = (CustomLineItemFlatChargeDetailsProperty.Jsii$Proxy) o;

                return this.chargeValue.equals(that.chargeValue);
            }

            @Override
            public final int hashCode() {
                int result = this.chargeValue.hashCode();
                return result;
            }
        }
    }
    /**
     * A representation of the charge details associated with a percentage custom line item.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.billingconductor.*;
     * CustomLineItemPercentageChargeDetailsProperty customLineItemPercentageChargeDetailsProperty = CustomLineItemPercentageChargeDetailsProperty.builder()
     *         .percentageValue(123)
     *         // the properties below are optional
     *         .childAssociatedResources(List.of("childAssociatedResources"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_billingconductor.CfnCustomLineItem.CustomLineItemPercentageChargeDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomLineItemPercentageChargeDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomLineItemPercentageChargeDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom line item's percentage value.
         * <p>
         * This will be multiplied against the combined value of its associated resources to determine its charge value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPercentageValue();

        /**
         * A list of resource ARNs to associate to the percentage custom line item.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getChildAssociatedResources() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomLineItemPercentageChargeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomLineItemPercentageChargeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomLineItemPercentageChargeDetailsProperty> {
            java.lang.Number percentageValue;
            java.util.List<java.lang.String> childAssociatedResources;

            /**
             * Sets the value of {@link CustomLineItemPercentageChargeDetailsProperty#getPercentageValue}
             * @param percentageValue The custom line item's percentage value. This parameter is required.
             *                        This will be multiplied against the combined value of its associated resources to determine its charge value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentageValue(java.lang.Number percentageValue) {
                this.percentageValue = percentageValue;
                return this;
            }

            /**
             * Sets the value of {@link CustomLineItemPercentageChargeDetailsProperty#getChildAssociatedResources}
             * @param childAssociatedResources A list of resource ARNs to associate to the percentage custom line item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder childAssociatedResources(java.util.List<java.lang.String> childAssociatedResources) {
                this.childAssociatedResources = childAssociatedResources;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomLineItemPercentageChargeDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomLineItemPercentageChargeDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomLineItemPercentageChargeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomLineItemPercentageChargeDetailsProperty {
            private final java.lang.Number percentageValue;
            private final java.util.List<java.lang.String> childAssociatedResources;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.percentageValue = software.amazon.jsii.Kernel.get(this, "percentageValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.childAssociatedResources = software.amazon.jsii.Kernel.get(this, "childAssociatedResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.percentageValue = java.util.Objects.requireNonNull(builder.percentageValue, "percentageValue is required");
                this.childAssociatedResources = builder.childAssociatedResources;
            }

            @Override
            public final java.lang.Number getPercentageValue() {
                return this.percentageValue;
            }

            @Override
            public final java.util.List<java.lang.String> getChildAssociatedResources() {
                return this.childAssociatedResources;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("percentageValue", om.valueToTree(this.getPercentageValue()));
                if (this.getChildAssociatedResources() != null) {
                    data.set("childAssociatedResources", om.valueToTree(this.getChildAssociatedResources()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_billingconductor.CfnCustomLineItem.CustomLineItemPercentageChargeDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomLineItemPercentageChargeDetailsProperty.Jsii$Proxy that = (CustomLineItemPercentageChargeDetailsProperty.Jsii$Proxy) o;

                if (!percentageValue.equals(that.percentageValue)) return false;
                return this.childAssociatedResources != null ? this.childAssociatedResources.equals(that.childAssociatedResources) : that.childAssociatedResources == null;
            }

            @Override
            public final int hashCode() {
                int result = this.percentageValue.hashCode();
                result = 31 * result + (this.childAssociatedResources != null ? this.childAssociatedResources.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.billingconductor.CfnCustomLineItem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.billingconductor.CfnCustomLineItem> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.billingconductor.CfnCustomLineItemProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.billingconductor.CfnCustomLineItemProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
         * <p>
         * @return {@code this}
         * @param billingGroupArn The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingGroupArn(final java.lang.String billingGroupArn) {
            this.props.billingGroupArn(billingGroupArn);
            return this;
        }

        /**
         * The custom line item's name.
         * <p>
         * @return {@code this}
         * @param name The custom line item's name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A time range for which the custom line item is effective.
         * <p>
         * @return {@code this}
         * @param billingPeriodRange A time range for which the custom line item is effective. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingPeriodRange(final software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.BillingPeriodRangeProperty billingPeriodRange) {
            this.props.billingPeriodRange(billingPeriodRange);
            return this;
        }
        /**
         * A time range for which the custom line item is effective.
         * <p>
         * @return {@code this}
         * @param billingPeriodRange A time range for which the custom line item is effective. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingPeriodRange(final software.amazon.awscdk.core.IResolvable billingPeriodRange) {
            this.props.billingPeriodRange(billingPeriodRange);
            return this;
        }

        /**
         * The charge details of a custom line item.
         * <p>
         * It should contain only one of <code>Flat</code> or <code>Percentage</code> .
         * <p>
         * @return {@code this}
         * @param customLineItemChargeDetails The charge details of a custom line item. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customLineItemChargeDetails(final software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.CustomLineItemChargeDetailsProperty customLineItemChargeDetails) {
            this.props.customLineItemChargeDetails(customLineItemChargeDetails);
            return this;
        }
        /**
         * The charge details of a custom line item.
         * <p>
         * It should contain only one of <code>Flat</code> or <code>Percentage</code> .
         * <p>
         * @return {@code this}
         * @param customLineItemChargeDetails The charge details of a custom line item. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customLineItemChargeDetails(final software.amazon.awscdk.core.IResolvable customLineItemChargeDetails) {
            this.props.customLineItemChargeDetails(customLineItemChargeDetails);
            return this;
        }

        /**
         * The custom line item's description.
         * <p>
         * This is shown on the Bills page in association with the charge value.
         * <p>
         * @return {@code this}
         * @param description The custom line item's description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A map that contains tag keys and tag values that are attached to a custom line item.
         * <p>
         * @return {@code this}
         * @param tags A map that contains tag keys and tag values that are attached to a custom line item. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.billingconductor.CfnCustomLineItem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.billingconductor.CfnCustomLineItem build() {
            return new software.amazon.awscdk.services.billingconductor.CfnCustomLineItem(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
