package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFormation `AWS::CloudFront::OriginAccessControl`.
 * <p>
 * Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
 * <p>
 * For an Amazon S3 origin, this makes it possible to block public access to the Amazon S3 bucket so that viewers (users) can access the content in the bucket only through CloudFront.
 * <p>
 * For more information about using a CloudFront origin access control, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Restricting access to an Amazon S3 origin</a> in the <em>Amazon CloudFront Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnOriginAccessControl cfnOriginAccessControl = CfnOriginAccessControl.Builder.create(this, "MyCfnOriginAccessControl")
 *         .originAccessControlConfig(OriginAccessControlConfigProperty.builder()
 *                 .name("name")
 *                 .originAccessControlOriginType("originAccessControlOriginType")
 *                 .signingBehavior("signingBehavior")
 *                 .signingProtocol("signingProtocol")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.452Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudfront.CfnOriginAccessControl")
public class CfnOriginAccessControl extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnOriginAccessControl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOriginAccessControl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudFront::OriginAccessControl`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOriginAccessControl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnOriginAccessControlProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique identifier of the origin access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The origin access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOriginAccessControlConfig() {
        return software.amazon.jsii.Kernel.get(this, "originAccessControlConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The origin access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginAccessControlConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl.OriginAccessControlConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "originAccessControlConfig", java.util.Objects.requireNonNull(value, "originAccessControlConfig is required"));
    }

    /**
     * The origin access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginAccessControlConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "originAccessControlConfig", java.util.Objects.requireNonNull(value, "originAccessControlConfig is required"));
    }
    /**
     * Creates a new origin access control in CloudFront.
     * <p>
     * After you create an origin access control, you can add it to an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
     * <p>
     * For an Amazon S3 origin, this makes it possible to block public access to the Amazon S3 bucket so that viewers (users) can access the content in the bucket only through CloudFront.
     * <p>
     * For more information about using a CloudFront origin access control, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Restricting access to an Amazon S3 origin</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginAccessControlConfigProperty originAccessControlConfigProperty = OriginAccessControlConfigProperty.builder()
     *         .name("name")
     *         .originAccessControlOriginType("originAccessControlOriginType")
     *         .signingBehavior("signingBehavior")
     *         .signingProtocol("signingProtocol")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudfront.CfnOriginAccessControl.OriginAccessControlConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginAccessControlConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginAccessControlConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name to identify the origin access control.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The type of origin that this origin access control is for.
         * <p>
         * The only valid value is <code>s3</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginAccessControlOriginType();

        /**
         * Specifies which requests CloudFront signs (adds authentication information to).
         * <p>
         * Specify <code>always</code> for the most common use case. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings">origin access control advanced settings</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * This field can have one of the following values:
         * <p>
         * <ul>
         * <li><code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header from the viewer request if one exists.</li>
         * <li><code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access control for all origins in all distributions that use this origin access control.</li>
         * <li><code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header, then CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header, then CloudFront doesn't sign the origin request and instead passes along the <code>Authorization</code> header from the viewer request. <em>WARNING: To pass along the <code>Authorization</code> header from the viewer request, you <em>must</em> add the <code>Authorization</code> header to a <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">cache policy</a> for all cache behaviors that use origins associated with this origin access control.</em></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSigningBehavior();

        /**
         * The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests.
         * <p>
         * The only valid value is <code>sigv4</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSigningProtocol();

        /**
         * A description of the origin access control.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginAccessControlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginAccessControlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginAccessControlConfigProperty> {
            java.lang.String name;
            java.lang.String originAccessControlOriginType;
            java.lang.String signingBehavior;
            java.lang.String signingProtocol;
            java.lang.String description;

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getName}
             * @param name A name to identify the origin access control. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getOriginAccessControlOriginType}
             * @param originAccessControlOriginType The type of origin that this origin access control is for. This parameter is required.
             *                                      The only valid value is <code>s3</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessControlOriginType(java.lang.String originAccessControlOriginType) {
                this.originAccessControlOriginType = originAccessControlOriginType;
                return this;
            }

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getSigningBehavior}
             * @param signingBehavior Specifies which requests CloudFront signs (adds authentication information to). This parameter is required.
             *                        Specify <code>always</code> for the most common use case. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings">origin access control advanced settings</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        This field can have one of the following values:
             *                        <p>
             *                        <ul>
             *                        <li><code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header from the viewer request if one exists.</li>
             *                        <li><code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access control for all origins in all distributions that use this origin access control.</li>
             *                        <li><code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header, then CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header, then CloudFront doesn't sign the origin request and instead passes along the <code>Authorization</code> header from the viewer request. <em>WARNING: To pass along the <code>Authorization</code> header from the viewer request, you <em>must</em> add the <code>Authorization</code> header to a <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">cache policy</a> for all cache behaviors that use origins associated with this origin access control.</em></li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingBehavior(java.lang.String signingBehavior) {
                this.signingBehavior = signingBehavior;
                return this;
            }

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getSigningProtocol}
             * @param signingProtocol The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests. This parameter is required.
             *                        The only valid value is <code>sigv4</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingProtocol(java.lang.String signingProtocol) {
                this.signingProtocol = signingProtocol;
                return this;
            }

            /**
             * Sets the value of {@link OriginAccessControlConfigProperty#getDescription}
             * @param description A description of the origin access control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginAccessControlConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginAccessControlConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginAccessControlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginAccessControlConfigProperty {
            private final java.lang.String name;
            private final java.lang.String originAccessControlOriginType;
            private final java.lang.String signingBehavior;
            private final java.lang.String signingProtocol;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originAccessControlOriginType = software.amazon.jsii.Kernel.get(this, "originAccessControlOriginType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.signingBehavior = software.amazon.jsii.Kernel.get(this, "signingBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.signingProtocol = software.amazon.jsii.Kernel.get(this, "signingProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.originAccessControlOriginType = java.util.Objects.requireNonNull(builder.originAccessControlOriginType, "originAccessControlOriginType is required");
                this.signingBehavior = java.util.Objects.requireNonNull(builder.signingBehavior, "signingBehavior is required");
                this.signingProtocol = java.util.Objects.requireNonNull(builder.signingProtocol, "signingProtocol is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getOriginAccessControlOriginType() {
                return this.originAccessControlOriginType;
            }

            @Override
            public final java.lang.String getSigningBehavior() {
                return this.signingBehavior;
            }

            @Override
            public final java.lang.String getSigningProtocol() {
                return this.signingProtocol;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("originAccessControlOriginType", om.valueToTree(this.getOriginAccessControlOriginType()));
                data.set("signingBehavior", om.valueToTree(this.getSigningBehavior()));
                data.set("signingProtocol", om.valueToTree(this.getSigningProtocol()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cloudfront.CfnOriginAccessControl.OriginAccessControlConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginAccessControlConfigProperty.Jsii$Proxy that = (OriginAccessControlConfigProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!originAccessControlOriginType.equals(that.originAccessControlOriginType)) return false;
                if (!signingBehavior.equals(that.signingBehavior)) return false;
                if (!signingProtocol.equals(that.signingProtocol)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.originAccessControlOriginType.hashCode());
                result = 31 * result + (this.signingBehavior.hashCode());
                result = 31 * result + (this.signingProtocol.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnOriginAccessControlProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnOriginAccessControlProps.Builder();
        }

        /**
         * The origin access control.
         * <p>
         * @return {@code this}
         * @param originAccessControlConfig The origin access control. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlConfig(final software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl.OriginAccessControlConfigProperty originAccessControlConfig) {
            this.props.originAccessControlConfig(originAccessControlConfig);
            return this;
        }
        /**
         * The origin access control.
         * <p>
         * @return {@code this}
         * @param originAccessControlConfig The origin access control. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlConfig(final software.amazon.awscdk.core.IResolvable originAccessControlConfig) {
            this.props.originAccessControlConfig(originAccessControlConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl build() {
            return new software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
