package software.amazon.awscdk.services.cloudfront;

/**
 * (experimental) HTTP status code to failover to second origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Configuring origin fallback options for the CloudFrontWebDistribution
 * // Configuring origin fallback options for the CloudFrontWebDistribution
 * CloudFrontWebDistribution.Builder.create(this, "ADistribution")
 *         .originConfigs(List.of(SourceConfiguration.builder()
 *                 .s3OriginSource(S3OriginConfig.builder()
 *                         .s3BucketSource(Bucket.fromBucketName(this, "aBucket", "myoriginbucket"))
 *                         .originPath("/")
 *                         .originHeaders(Map.of(
 *                                 "myHeader", "42"))
 *                         .originShieldRegion("us-west-2")
 *                         .build())
 *                 .failoverS3OriginSource(S3OriginConfig.builder()
 *                         .s3BucketSource(Bucket.fromBucketName(this, "aBucketFallback", "myoriginbucketfallback"))
 *                         .originPath("/somewhere")
 *                         .originHeaders(Map.of(
 *                                 "myHeader2", "21"))
 *                         .originShieldRegion("us-east-1")
 *                         .build())
 *                 .failoverCriteriaStatusCodes(List.of(FailoverStatusCode.INTERNAL_SERVER_ERROR))
 *                 .behaviors(List.of(Behavior.builder()
 *                         .isDefaultBehavior(true)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.560Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudfront.FailoverStatusCode")
public enum FailoverStatusCode {
    /**
     * (experimental) Forbidden (403).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FORBIDDEN,
    /**
     * (experimental) Not found (404).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NOT_FOUND,
    /**
     * (experimental) Internal Server Error (500).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INTERNAL_SERVER_ERROR,
    /**
     * (experimental) Bad Gateway (502).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BAD_GATEWAY,
    /**
     * (experimental) Service Unavailable (503).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SERVICE_UNAVAILABLE,
    /**
     * (experimental) Gateway Timeout (504).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GATEWAY_TIMEOUT,
}
