package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) Properties for Alarms.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Alias alias;
 * // or add alarms to an existing group
 * Alias blueGreenAlias;
 * Alarm alarm = Alarm.Builder.create(this, "Errors")
 *         .comparisonOperator(ComparisonOperator.GREATER_THAN_THRESHOLD)
 *         .threshold(1)
 *         .evaluationPeriods(1)
 *         .metric(alias.metricErrors())
 *         .build();
 * LambdaDeploymentGroup deploymentGroup = LambdaDeploymentGroup.Builder.create(this, "BlueGreenDeployment")
 *         .alias(alias)
 *         .deploymentConfig(LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE)
 *         .alarms(List.of(alarm))
 *         .build();
 * deploymentGroup.addAlarm(Alarm.Builder.create(this, "BlueGreenErrors")
 *         .comparisonOperator(ComparisonOperator.GREATER_THAN_THRESHOLD)
 *         .threshold(1)
 *         .evaluationPeriods(1)
 *         .metric(blueGreenAlias.metricErrors())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.771Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudwatch.AlarmProps")
@software.amazon.jsii.Jsii.Proxy(AlarmProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AlarmProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions {

    /**
     * (experimental) The metric to add the alarm on.
     * <p>
     * Metric objects can be obtained from most resources, or you can construct
     * custom Metric objects by instantiating one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric getMetric();

    /**
     * @return a {@link Builder} of {@link AlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AlarmProps> {
        software.amazon.awscdk.services.cloudwatch.IMetric metric;
        java.lang.Number evaluationPeriods;
        java.lang.Number threshold;
        java.lang.Boolean actionsEnabled;
        java.lang.String alarmDescription;
        java.lang.String alarmName;
        software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator;
        java.lang.Number datapointsToAlarm;
        java.lang.String evaluateLowSampleCountPercentile;
        software.amazon.awscdk.core.Duration period;
        java.lang.String statistic;
        software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData;

        /**
         * Sets the value of {@link AlarmProps#getMetric}
         * @param metric The metric to add the alarm on. This parameter is required.
         *               Metric objects can be obtained from most resources, or you can construct
         *               custom Metric objects by instantiating one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metric(software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getEvaluationPeriods}
         * @param evaluationPeriods The number of periods over which data is compared to the specified threshold. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getThreshold}
         * @param threshold The value against which the specified statistic is compared. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder threshold(java.lang.Number threshold) {
            this.threshold = threshold;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getActionsEnabled}
         * @param actionsEnabled Whether the actions for this alarm are enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionsEnabled(java.lang.Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getAlarmDescription}
         * @param alarmDescription Description for the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder alarmDescription(java.lang.String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getAlarmName}
         * @param alarmName Name of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder alarmName(java.lang.String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getComparisonOperator}
         * @param comparisonOperator Comparison to use to check if metric is breaching.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder comparisonOperator(software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getDatapointsToAlarm}
         * @param datapointsToAlarm The number of datapoints that must be breaching to trigger the alarm.
         *                          This is used only if you are setting an "M
         *                          out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon
         *                          CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder datapointsToAlarm(java.lang.Number datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getEvaluateLowSampleCountPercentile}
         * @param evaluateLowSampleCountPercentile Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
         *                                         Used only for alarms that are based on percentiles.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder evaluateLowSampleCountPercentile(java.lang.String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getPeriod}
         * @param period The period over which the specified statistic is applied.
         *               Cannot be used with <code>MathExpression</code> objects.
         * @return {@code this}
         * @deprecated Use `metric.with({ period: ... })` to encode the period into the Metric object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder period(software.amazon.awscdk.core.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getStatistic}
         * @param statistic What function to use for aggregating.
         *                  Can be one of the following:
         *                  <p>
         *                  <ul>
         *                  <li>"Minimum" | "min"</li>
         *                  <li>"Maximum" | "max"</li>
         *                  <li>"Average" | "avg"</li>
         *                  <li>"Sum" | "sum"</li>
         *                  <li>"SampleCount | "n"</li>
         *                  <li>"pNN.NN"</li>
         *                  </ul>
         *                  <p>
         *                  Cannot be used with <code>MathExpression</code> objects.
         * @return {@code this}
         * @deprecated Use `metric.with({ statistic: ... })` to encode the period into the Metric object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link AlarmProps#getTreatMissingData}
         * @param treatMissingData Sets how this alarm is to handle missing data points.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder treatMissingData(software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlarmProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AlarmProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmProps {
        private final software.amazon.awscdk.services.cloudwatch.IMetric metric;
        private final java.lang.Number evaluationPeriods;
        private final java.lang.Number threshold;
        private final java.lang.Boolean actionsEnabled;
        private final java.lang.String alarmDescription;
        private final java.lang.String alarmName;
        private final software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator;
        private final java.lang.Number datapointsToAlarm;
        private final java.lang.String evaluateLowSampleCountPercentile;
        private final software.amazon.awscdk.core.Duration period;
        private final java.lang.String statistic;
        private final software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
            this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.actionsEnabled = software.amazon.jsii.Kernel.get(this, "actionsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.alarmDescription = software.amazon.jsii.Kernel.get(this, "alarmDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.ComparisonOperator.class));
            this.datapointsToAlarm = software.amazon.jsii.Kernel.get(this, "datapointsToAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.evaluateLowSampleCountPercentile = software.amazon.jsii.Kernel.get(this, "evaluateLowSampleCountPercentile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.treatMissingData = software.amazon.jsii.Kernel.get(this, "treatMissingData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TreatMissingData.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metric = java.util.Objects.requireNonNull(builder.metric, "metric is required");
            this.evaluationPeriods = java.util.Objects.requireNonNull(builder.evaluationPeriods, "evaluationPeriods is required");
            this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
            this.actionsEnabled = builder.actionsEnabled;
            this.alarmDescription = builder.alarmDescription;
            this.alarmName = builder.alarmName;
            this.comparisonOperator = builder.comparisonOperator;
            this.datapointsToAlarm = builder.datapointsToAlarm;
            this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
            this.period = builder.period;
            this.statistic = builder.statistic;
            this.treatMissingData = builder.treatMissingData;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
            return this.metric;
        }

        @Override
        public final java.lang.Number getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final java.lang.Number getThreshold() {
            return this.threshold;
        }

        @Override
        public final java.lang.Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final java.lang.String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final java.lang.String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.ComparisonOperator getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final java.lang.Number getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        @Override
        public final java.lang.String getEvaluateLowSampleCountPercentile() {
            return this.evaluateLowSampleCountPercentile;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.TreatMissingData getTreatMissingData() {
            return this.treatMissingData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metric", om.valueToTree(this.getMetric()));
            data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
            data.set("threshold", om.valueToTree(this.getThreshold()));
            if (this.getActionsEnabled() != null) {
                data.set("actionsEnabled", om.valueToTree(this.getActionsEnabled()));
            }
            if (this.getAlarmDescription() != null) {
                data.set("alarmDescription", om.valueToTree(this.getAlarmDescription()));
            }
            if (this.getAlarmName() != null) {
                data.set("alarmName", om.valueToTree(this.getAlarmName()));
            }
            if (this.getComparisonOperator() != null) {
                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
            }
            if (this.getDatapointsToAlarm() != null) {
                data.set("datapointsToAlarm", om.valueToTree(this.getDatapointsToAlarm()));
            }
            if (this.getEvaluateLowSampleCountPercentile() != null) {
                data.set("evaluateLowSampleCountPercentile", om.valueToTree(this.getEvaluateLowSampleCountPercentile()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getTreatMissingData() != null) {
                data.set("treatMissingData", om.valueToTree(this.getTreatMissingData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cloudwatch.AlarmProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlarmProps.Jsii$Proxy that = (AlarmProps.Jsii$Proxy) o;

            if (!metric.equals(that.metric)) return false;
            if (!evaluationPeriods.equals(that.evaluationPeriods)) return false;
            if (!threshold.equals(that.threshold)) return false;
            if (this.actionsEnabled != null ? !this.actionsEnabled.equals(that.actionsEnabled) : that.actionsEnabled != null) return false;
            if (this.alarmDescription != null ? !this.alarmDescription.equals(that.alarmDescription) : that.alarmDescription != null) return false;
            if (this.alarmName != null ? !this.alarmName.equals(that.alarmName) : that.alarmName != null) return false;
            if (this.comparisonOperator != null ? !this.comparisonOperator.equals(that.comparisonOperator) : that.comparisonOperator != null) return false;
            if (this.datapointsToAlarm != null ? !this.datapointsToAlarm.equals(that.datapointsToAlarm) : that.datapointsToAlarm != null) return false;
            if (this.evaluateLowSampleCountPercentile != null ? !this.evaluateLowSampleCountPercentile.equals(that.evaluateLowSampleCountPercentile) : that.evaluateLowSampleCountPercentile != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            return this.treatMissingData != null ? this.treatMissingData.equals(that.treatMissingData) : that.treatMissingData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metric.hashCode();
            result = 31 * result + (this.evaluationPeriods.hashCode());
            result = 31 * result + (this.threshold.hashCode());
            result = 31 * result + (this.actionsEnabled != null ? this.actionsEnabled.hashCode() : 0);
            result = 31 * result + (this.alarmDescription != null ? this.alarmDescription.hashCode() : 0);
            result = 31 * result + (this.alarmName != null ? this.alarmName.hashCode() : 0);
            result = 31 * result + (this.comparisonOperator != null ? this.comparisonOperator.hashCode() : 0);
            result = 31 * result + (this.datapointsToAlarm != null ? this.datapointsToAlarm.hashCode() : 0);
            result = 31 * result + (this.evaluateLowSampleCountPercentile != null ? this.evaluateLowSampleCountPercentile.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.treatMissingData != null ? this.treatMissingData.hashCode() : 0);
            return result;
        }
    }
}
