package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) A dashboard widget that displays alarms in a grid view.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * Alarm errorAlarm;
 * dashboard.addWidgets(
 * AlarmStatusWidget.Builder.create()
 *         .alarms(List.of(errorAlarm))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.775Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudwatch.AlarmStatusWidget")
public class AlarmStatusWidget extends software.amazon.awscdk.services.cloudwatch.ConcreteWidget {

    protected AlarmStatusWidget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AlarmStatusWidget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AlarmStatusWidget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AlarmStatusWidgetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Place the widget at a given position.
     * <p>
     * @param x This parameter is required.
     * @param y This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void position(final @org.jetbrains.annotations.NotNull java.lang.Number x, final @org.jetbrains.annotations.NotNull java.lang.Number y) {
        software.amazon.jsii.Kernel.call(this, "position", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(x, "x is required"), java.util.Objects.requireNonNull(y, "y is required") });
    }

    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.AlarmStatusWidget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.AlarmStatusWidget> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.AlarmStatusWidgetProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.AlarmStatusWidgetProps.Builder();
        }

        /**
         * (experimental) CloudWatch Alarms to show in widget.
         * <p>
         * @return {@code this}
         * @param alarms CloudWatch Alarms to show in widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder alarms(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IAlarm> alarms) {
            this.props.alarms(alarms);
            return this;
        }

        /**
         * (experimental) Height of the widget.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param height Height of the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder height(final java.lang.Number height) {
            this.props.height(height);
            return this;
        }

        /**
         * (experimental) Specifies how to sort the alarms in the widget.
         * <p>
         * Default: - alphabetical order
         * <p>
         * @return {@code this}
         * @param sortBy Specifies how to sort the alarms in the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sortBy(final software.amazon.awscdk.services.cloudwatch.AlarmStatusWidgetSortBy sortBy) {
            this.props.sortBy(sortBy);
            return this;
        }

        /**
         * (experimental) Use this field to filter the list of alarms displayed in the widget to only those alarms currently in the specified states.
         * <p>
         * You can specify one or more alarm states in the value for this field.
         * The alarm states that you can specify are ALARM, INSUFFICIENT_DATA, and OK.
         * <p>
         * If you omit this field or specify an empty array, all the alarms specifed in alarms are displayed.
         * <p>
         * Default: -  all the alarms specified in alarms are displayed.
         * <p>
         * @return {@code this}
         * @param states Use this field to filter the list of alarms displayed in the widget to only those alarms currently in the specified states. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder states(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.AlarmState> states) {
            this.props.states(states);
            return this;
        }

        /**
         * (experimental) The title of the widget.
         * <p>
         * Default: 'Alarm Status'
         * <p>
         * @return {@code this}
         * @param title The title of the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * (experimental) Width of the widget, in a grid of 24 units wide.
         * <p>
         * Default: 6
         * <p>
         * @return {@code this}
         * @param width Width of the widget, in a grid of 24 units wide. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder width(final java.lang.Number width) {
            this.props.width(width);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.AlarmStatusWidget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cloudwatch.AlarmStatusWidget build() {
            return new software.amazon.awscdk.services.cloudwatch.AlarmStatusWidget(
                this.props.build()
            );
        }
    }
}
