package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) Properties of a rendered metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Duration duration;
 * Metric metric;
 * Object renderingProperties;
 * Object value;
 * MetricConfig metricConfig = MetricConfig.builder()
 *         .mathExpression(MetricExpressionConfig.builder()
 *                 .expression("expression")
 *                 .period(123)
 *                 .usingMetrics(Map.of(
 *                         "usingMetricsKey", metric))
 *                 // the properties below are optional
 *                 .searchAccount("searchAccount")
 *                 .searchRegion("searchRegion")
 *                 .build())
 *         .metricStat(MetricStatConfig.builder()
 *                 .metricName("metricName")
 *                 .namespace("namespace")
 *                 .period(duration)
 *                 .statistic("statistic")
 *                 // the properties below are optional
 *                 .account("account")
 *                 .dimensions(List.of(Dimension.builder()
 *                         .name("name")
 *                         .value(value)
 *                         .build()))
 *                 .region("region")
 *                 .unitFilter(Unit.SECONDS)
 *                 .build())
 *         .renderingProperties(Map.of(
 *                 "renderingPropertiesKey", renderingProperties))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.900Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudwatch.MetricConfig")
@software.amazon.jsii.Jsii.Proxy(MetricConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface MetricConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) In case the metric is a math expression, the details of the math expression.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig getMathExpression() {
        return null;
    }

    /**
     * (experimental) In case the metric represents a query, the details of the query.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricStatConfig getMetricStat() {
        return null;
    }

    /**
     * (experimental) Additional properties which will be rendered if the metric is used in a dashboard.
     * <p>
     * Examples are 'label' and 'color', but any key in here will be
     * added to dashboard graphs.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getRenderingProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MetricConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<MetricConfig> {
        software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig mathExpression;
        software.amazon.awscdk.services.cloudwatch.MetricStatConfig metricStat;
        java.util.Map<java.lang.String, java.lang.Object> renderingProperties;

        /**
         * Sets the value of {@link MetricConfig#getMathExpression}
         * @param mathExpression In case the metric is a math expression, the details of the math expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mathExpression(software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig mathExpression) {
            this.mathExpression = mathExpression;
            return this;
        }

        /**
         * Sets the value of {@link MetricConfig#getMetricStat}
         * @param metricStat In case the metric represents a query, the details of the query.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricStat(software.amazon.awscdk.services.cloudwatch.MetricStatConfig metricStat) {
            this.metricStat = metricStat;
            return this;
        }

        /**
         * Sets the value of {@link MetricConfig#getRenderingProperties}
         * @param renderingProperties Additional properties which will be rendered if the metric is used in a dashboard.
         *                            Examples are 'label' and 'color', but any key in here will be
         *                            added to dashboard graphs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder renderingProperties(java.util.Map<java.lang.String, ? extends java.lang.Object> renderingProperties) {
            this.renderingProperties = (java.util.Map<java.lang.String, java.lang.Object>)renderingProperties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public MetricConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MetricConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricConfig {
        private final software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig mathExpression;
        private final software.amazon.awscdk.services.cloudwatch.MetricStatConfig metricStat;
        private final java.util.Map<java.lang.String, java.lang.Object> renderingProperties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mathExpression = software.amazon.jsii.Kernel.get(this, "mathExpression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig.class));
            this.metricStat = software.amazon.jsii.Kernel.get(this, "metricStat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.MetricStatConfig.class));
            this.renderingProperties = software.amazon.jsii.Kernel.get(this, "renderingProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mathExpression = builder.mathExpression;
            this.metricStat = builder.metricStat;
            this.renderingProperties = (java.util.Map<java.lang.String, java.lang.Object>)builder.renderingProperties;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig getMathExpression() {
            return this.mathExpression;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.MetricStatConfig getMetricStat() {
            return this.metricStat;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getRenderingProperties() {
            return this.renderingProperties;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMathExpression() != null) {
                data.set("mathExpression", om.valueToTree(this.getMathExpression()));
            }
            if (this.getMetricStat() != null) {
                data.set("metricStat", om.valueToTree(this.getMetricStat()));
            }
            if (this.getRenderingProperties() != null) {
                data.set("renderingProperties", om.valueToTree(this.getRenderingProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cloudwatch.MetricConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricConfig.Jsii$Proxy that = (MetricConfig.Jsii$Proxy) o;

            if (this.mathExpression != null ? !this.mathExpression.equals(that.mathExpression) : that.mathExpression != null) return false;
            if (this.metricStat != null ? !this.metricStat.equals(that.metricStat) : that.metricStat != null) return false;
            return this.renderingProperties != null ? this.renderingProperties.equals(that.renderingProperties) : that.renderingProperties == null;
        }

        @Override
        public final int hashCode() {
            int result = this.mathExpression != null ? this.mathExpression.hashCode() : 0;
            result = 31 * result + (this.metricStat != null ? this.metricStat.hashCode() : 0);
            result = 31 * result + (this.renderingProperties != null ? this.renderingProperties.hashCode() : 0);
            return result;
        }
    }
}
