package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) Properties for a SingleValueWidget.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * Metric visitorCount;
 * Metric purchaseCount;
 * dashboard.addWidgets(SingleValueWidget.Builder.create()
 *         .metrics(List.of(visitorCount, purchaseCount))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.913Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudwatch.SingleValueWidgetProps")
@software.amazon.jsii.Jsii.Proxy(SingleValueWidgetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SingleValueWidgetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MetricWidgetProps {

    /**
     * (experimental) Metrics to display.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getMetrics();

    /**
     * (experimental) Whether to show as many digits as can fit, before rounding.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFullPrecision() {
        return null;
    }

    /**
     * (experimental) Whether to show the value from the entire time range.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSetPeriodToTimeRange() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SingleValueWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SingleValueWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SingleValueWidgetProps> {
        java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> metrics;
        java.lang.Boolean fullPrecision;
        java.lang.Boolean setPeriodToTimeRange;
        java.lang.Number height;
        java.lang.String region;
        java.lang.String title;
        java.lang.Number width;

        /**
         * Sets the value of {@link SingleValueWidgetProps#getMetrics}
         * @param metrics Metrics to display. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder metrics(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> metrics) {
            this.metrics = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)metrics;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getFullPrecision}
         * @param fullPrecision Whether to show as many digits as can fit, before rounding.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fullPrecision(java.lang.Boolean fullPrecision) {
            this.fullPrecision = fullPrecision;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getSetPeriodToTimeRange}
         * @param setPeriodToTimeRange Whether to show the value from the entire time range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder setPeriodToTimeRange(java.lang.Boolean setPeriodToTimeRange) {
            this.setPeriodToTimeRange = setPeriodToTimeRange;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getHeight}
         * @param height Height of the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder height(java.lang.Number height) {
            this.height = height;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getRegion}
         * @param region The region the metrics of this graph should be taken from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getTitle}
         * @param title Title for the graph.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link SingleValueWidgetProps#getWidth}
         * @param width Width of the widget, in a grid of 24 units wide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder width(java.lang.Number width) {
            this.width = width;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SingleValueWidgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SingleValueWidgetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SingleValueWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleValueWidgetProps {
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> metrics;
        private final java.lang.Boolean fullPrecision;
        private final java.lang.Boolean setPeriodToTimeRange;
        private final java.lang.Number height;
        private final java.lang.String region;
        private final java.lang.String title;
        private final java.lang.Number width;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
            this.fullPrecision = software.amazon.jsii.Kernel.get(this, "fullPrecision", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.setPeriodToTimeRange = software.amazon.jsii.Kernel.get(this, "setPeriodToTimeRange", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.height = software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.width = software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metrics = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)java.util.Objects.requireNonNull(builder.metrics, "metrics is required");
            this.fullPrecision = builder.fullPrecision;
            this.setPeriodToTimeRange = builder.setPeriodToTimeRange;
            this.height = builder.height;
            this.region = builder.region;
            this.title = builder.title;
            this.width = builder.width;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getMetrics() {
            return this.metrics;
        }

        @Override
        public final java.lang.Boolean getFullPrecision() {
            return this.fullPrecision;
        }

        @Override
        public final java.lang.Boolean getSetPeriodToTimeRange() {
            return this.setPeriodToTimeRange;
        }

        @Override
        public final java.lang.Number getHeight() {
            return this.height;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public final java.lang.Number getWidth() {
            return this.width;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metrics", om.valueToTree(this.getMetrics()));
            if (this.getFullPrecision() != null) {
                data.set("fullPrecision", om.valueToTree(this.getFullPrecision()));
            }
            if (this.getSetPeriodToTimeRange() != null) {
                data.set("setPeriodToTimeRange", om.valueToTree(this.getSetPeriodToTimeRange()));
            }
            if (this.getHeight() != null) {
                data.set("height", om.valueToTree(this.getHeight()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTitle() != null) {
                data.set("title", om.valueToTree(this.getTitle()));
            }
            if (this.getWidth() != null) {
                data.set("width", om.valueToTree(this.getWidth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cloudwatch.SingleValueWidgetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SingleValueWidgetProps.Jsii$Proxy that = (SingleValueWidgetProps.Jsii$Proxy) o;

            if (!metrics.equals(that.metrics)) return false;
            if (this.fullPrecision != null ? !this.fullPrecision.equals(that.fullPrecision) : that.fullPrecision != null) return false;
            if (this.setPeriodToTimeRange != null ? !this.setPeriodToTimeRange.equals(that.setPeriodToTimeRange) : that.setPeriodToTimeRange != null) return false;
            if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
            return this.width != null ? this.width.equals(that.width) : that.width == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metrics.hashCode();
            result = 31 * result + (this.fullPrecision != null ? this.fullPrecision.hashCode() : 0);
            result = 31 * result + (this.setPeriodToTimeRange != null ? this.setPeriodToTimeRange.hashCode() : 0);
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            return result;
        }
    }
}
