package software.amazon.awscdk.services.codebuild;

/**
 * (experimental) The options when creating a CodeBuild Docker build image using {@link LinuxBuildImage.fromDockerRegistry} or {@link WindowsBuildImage.fromDockerRegistry}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * .environment(BuildEnvironment.builder()
 *         .buildImage(LinuxBuildImage.fromDockerRegistry("my-registry/my-repo", DockerImageOptions.builder()
 *                 .secretsManagerCredentials(secrets)
 *                 .build()))
 *         .build())
 * .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:56.107Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codebuild.DockerImageOptions")
@software.amazon.jsii.Jsii.Proxy(DockerImageOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DockerImageOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The credentials, stored in Secrets Manager, used for accessing the repository holding the image, if the repository is private.
     * <p>
     * Default: no credentials will be used (we assume the repository is public)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DockerImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DockerImageOptions> {
        software.amazon.awscdk.services.secretsmanager.ISecret secretsManagerCredentials;

        /**
         * Sets the value of {@link DockerImageOptions#getSecretsManagerCredentials}
         * @param secretsManagerCredentials The credentials, stored in Secrets Manager, used for accessing the repository holding the image, if the repository is private.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretsManagerCredentials(software.amazon.awscdk.services.secretsmanager.ISecret secretsManagerCredentials) {
            this.secretsManagerCredentials = secretsManagerCredentials;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DockerImageOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DockerImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageOptions {
        private final software.amazon.awscdk.services.secretsmanager.ISecret secretsManagerCredentials;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.secretsManagerCredentials = software.amazon.jsii.Kernel.get(this, "secretsManagerCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.secretsManagerCredentials = builder.secretsManagerCredentials;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
            return this.secretsManagerCredentials;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getSecretsManagerCredentials() != null) {
                data.set("secretsManagerCredentials", om.valueToTree(this.getSecretsManagerCredentials()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_codebuild.DockerImageOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageOptions.Jsii$Proxy that = (DockerImageOptions.Jsii$Proxy) o;

            return this.secretsManagerCredentials != null ? this.secretsManagerCredentials.equals(that.secretsManagerCredentials) : that.secretsManagerCredentials == null;
        }

        @Override
        public final int hashCode() {
            int result = this.secretsManagerCredentials != null ? this.secretsManagerCredentials.hashCode() : 0;
            return result;
        }
    }
}
