package software.amazon.awscdk.services.codepipeline;

/**
 * (experimental) A specific file within an output artifact.
 * <p>
 * The most common use case for this is specifying the template file
 * for a CloudFormation action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Source stage: read from repository
 * Repository repo = Repository.Builder.create(stack, "TemplateRepo")
 *         .repositoryName("template-repo")
 *         .build();
 * Artifact sourceOutput = new Artifact("SourceArtifact");
 * CodeCommitSourceAction source = CodeCommitSourceAction.Builder.create()
 *         .actionName("Source")
 *         .repository(repo)
 *         .output(sourceOutput)
 *         .trigger(CodeCommitTrigger.POLL)
 *         .build();
 * Map&lt;String, Object&gt; sourceStage = Map.of(
 *         "stageName", "Source",
 *         "actions", List.of(source));
 * // Deployment stage: create and deploy changeset with manual approval
 * String stackName = "OurStack";
 * String changeSetName = "StagedChangeSet";
 * Map&lt;String, Object&gt; prodStage = Map.of(
 *         "stageName", "Deploy",
 *         "actions", List.of(
 *             CloudFormationCreateReplaceChangeSetAction.Builder.create()
 *                     .actionName("PrepareChanges")
 *                     .stackName(stackName)
 *                     .changeSetName(changeSetName)
 *                     .adminPermissions(true)
 *                     .templatePath(sourceOutput.atPath("template.yaml"))
 *                     .runOrder(1)
 *                     .build(),
 *             ManualApprovalAction.Builder.create()
 *                     .actionName("ApproveChanges")
 *                     .runOrder(2)
 *                     .build(),
 *             CloudFormationExecuteChangeSetAction.Builder.create()
 *                     .actionName("ExecuteChanges")
 *                     .stackName(stackName)
 *                     .changeSetName(changeSetName)
 *                     .runOrder(3)
 *                     .build()));
 * Pipeline.Builder.create(stack, "Pipeline")
 *         .stages(List.of(sourceStage, prodStage))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:56.432Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codepipeline.ArtifactPath")
public class ArtifactPath extends software.amazon.jsii.JsiiObject {

    protected ArtifactPath(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ArtifactPath(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param artifact This parameter is required.
     * @param fileName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ArtifactPath(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact artifact, final @org.jetbrains.annotations.NotNull java.lang.String fileName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(artifact, "artifact is required"), java.util.Objects.requireNonNull(fileName, "fileName is required") });
    }

    /**
     * @param artifactName This parameter is required.
     * @param fileName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ArtifactPath artifactPath(final @org.jetbrains.annotations.NotNull java.lang.String artifactName, final @org.jetbrains.annotations.NotNull java.lang.String fileName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.ArtifactPath.class, "artifactPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ArtifactPath.class), new Object[] { java.util.Objects.requireNonNull(artifactName, "artifactName is required"), java.util.Objects.requireNonNull(fileName, "fileName is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getArtifact() {
        return software.amazon.jsii.Kernel.get(this, "artifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileName() {
        return software.amazon.jsii.Kernel.get(this, "fileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getLocation() {
        return software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
