package software.amazon.awscdk.services.cognito;

/**
 * (experimental) OpenID Connect endpoints.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * OidcEndpoints oidcEndpoints = OidcEndpoints.builder()
 *         .authorization("authorization")
 *         .jwksUri("jwksUri")
 *         .token("token")
 *         .userInfo("userInfo")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.041Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.OidcEndpoints")
@software.amazon.jsii.Jsii.Proxy(OidcEndpoints.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface OidcEndpoints extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Authorization endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorization();

    /**
     * (experimental) Jwks_uri endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getJwksUri();

    /**
     * (experimental) Token endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getToken();

    /**
     * (experimental) UserInfo endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getUserInfo();

    /**
     * @return a {@link Builder} of {@link OidcEndpoints}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OidcEndpoints}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<OidcEndpoints> {
        java.lang.String authorization;
        java.lang.String jwksUri;
        java.lang.String token;
        java.lang.String userInfo;

        /**
         * Sets the value of {@link OidcEndpoints#getAuthorization}
         * @param authorization Authorization endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorization(java.lang.String authorization) {
            this.authorization = authorization;
            return this;
        }

        /**
         * Sets the value of {@link OidcEndpoints#getJwksUri}
         * @param jwksUri Jwks_uri endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jwksUri(java.lang.String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        /**
         * Sets the value of {@link OidcEndpoints#getToken}
         * @param token Token endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder token(java.lang.String token) {
            this.token = token;
            return this;
        }

        /**
         * Sets the value of {@link OidcEndpoints#getUserInfo}
         * @param userInfo UserInfo endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userInfo(java.lang.String userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OidcEndpoints}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public OidcEndpoints build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OidcEndpoints}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OidcEndpoints {
        private final java.lang.String authorization;
        private final java.lang.String jwksUri;
        private final java.lang.String token;
        private final java.lang.String userInfo;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorization = software.amazon.jsii.Kernel.get(this, "authorization", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jwksUri = software.amazon.jsii.Kernel.get(this, "jwksUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.token = software.amazon.jsii.Kernel.get(this, "token", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userInfo = software.amazon.jsii.Kernel.get(this, "userInfo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorization = java.util.Objects.requireNonNull(builder.authorization, "authorization is required");
            this.jwksUri = java.util.Objects.requireNonNull(builder.jwksUri, "jwksUri is required");
            this.token = java.util.Objects.requireNonNull(builder.token, "token is required");
            this.userInfo = java.util.Objects.requireNonNull(builder.userInfo, "userInfo is required");
        }

        @Override
        public final java.lang.String getAuthorization() {
            return this.authorization;
        }

        @Override
        public final java.lang.String getJwksUri() {
            return this.jwksUri;
        }

        @Override
        public final java.lang.String getToken() {
            return this.token;
        }

        @Override
        public final java.lang.String getUserInfo() {
            return this.userInfo;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorization", om.valueToTree(this.getAuthorization()));
            data.set("jwksUri", om.valueToTree(this.getJwksUri()));
            data.set("token", om.valueToTree(this.getToken()));
            data.set("userInfo", om.valueToTree(this.getUserInfo()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cognito.OidcEndpoints"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OidcEndpoints.Jsii$Proxy that = (OidcEndpoints.Jsii$Proxy) o;

            if (!authorization.equals(that.authorization)) return false;
            if (!jwksUri.equals(that.jwksUri)) return false;
            if (!token.equals(that.token)) return false;
            return this.userInfo.equals(that.userInfo);
        }

        @Override
        public final int hashCode() {
            int result = this.authorization.hashCode();
            result = 31 * result + (this.jwksUri.hashCode());
            result = 31 * result + (this.token.hashCode());
            result = 31 * result + (this.userInfo.hashCode());
            return result;
        }
    }
}
