package software.amazon.awscdk.services.cognito;

/**
 * (experimental) Represents a identity provider that integrates with OpenID Connect.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * ProviderAttribute providerAttribute;
 * UserPool userPool;
 * UserPoolIdentityProviderOidc userPoolIdentityProviderOidc = UserPoolIdentityProviderOidc.Builder.create(this, "MyUserPoolIdentityProviderOidc")
 *         .clientId("clientId")
 *         .clientSecret("clientSecret")
 *         .issuerUrl("issuerUrl")
 *         .userPool(userPool)
 *         // the properties below are optional
 *         .attributeMapping(AttributeMapping.builder()
 *                 .address(providerAttribute)
 *                 .birthdate(providerAttribute)
 *                 .custom(Map.of(
 *                         "customKey", providerAttribute))
 *                 .email(providerAttribute)
 *                 .familyName(providerAttribute)
 *                 .fullname(providerAttribute)
 *                 .gender(providerAttribute)
 *                 .givenName(providerAttribute)
 *                 .lastUpdateTime(providerAttribute)
 *                 .locale(providerAttribute)
 *                 .middleName(providerAttribute)
 *                 .nickname(providerAttribute)
 *                 .phoneNumber(providerAttribute)
 *                 .preferredUsername(providerAttribute)
 *                 .profilePage(providerAttribute)
 *                 .profilePicture(providerAttribute)
 *                 .timezone(providerAttribute)
 *                 .website(providerAttribute)
 *                 .build())
 *         .attributeRequestMethod(OidcAttributeRequestMethod.GET)
 *         .endpoints(OidcEndpoints.builder()
 *                 .authorization("authorization")
 *                 .jwksUri("jwksUri")
 *                 .token("token")
 *                 .userInfo("userInfo")
 *                 .build())
 *         .identifiers(List.of("identifiers"))
 *         .name("name")
 *         .scopes(List.of("scopes"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.091Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.UserPoolIdentityProviderOidc")
public class UserPoolIdentityProviderOidc extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider {

    protected UserPoolIdentityProviderOidc(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolIdentityProviderOidc(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public UserPoolIdentityProviderOidc(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidcProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.lang.Object configureAttributeMapping() {
        return software.amazon.jsii.Kernel.call(this, "configureAttributeMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (experimental) The primary identifier of this identity provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getProviderName() {
        return software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidc}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidc> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidcProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidcProps.Builder();
        }

        /**
         * (experimental) The user pool to which this construct provides identities.
         * <p>
         * @return {@code this}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * (experimental) Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * <p>
         * Default: - no attribute mapping
         * <p>
         * @return {@code this}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder attributeMapping(final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.props.attributeMapping(attributeMapping);
            return this;
        }

        /**
         * (experimental) The client id.
         * <p>
         * @return {@code this}
         * @param clientId The client id. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientId(final java.lang.String clientId) {
            this.props.clientId(clientId);
            return this;
        }

        /**
         * (experimental) The client secret.
         * <p>
         * @return {@code this}
         * @param clientSecret The client secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientSecret(final java.lang.String clientSecret) {
            this.props.clientSecret(clientSecret);
            return this;
        }

        /**
         * (experimental) Issuer URL.
         * <p>
         * @return {@code this}
         * @param issuerUrl Issuer URL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder issuerUrl(final java.lang.String issuerUrl) {
            this.props.issuerUrl(issuerUrl);
            return this;
        }

        /**
         * (experimental) The method to use to request attributes.
         * <p>
         * Default: OidcAttributeRequestMethod.GET
         * <p>
         * @return {@code this}
         * @param attributeRequestMethod The method to use to request attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder attributeRequestMethod(final software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod attributeRequestMethod) {
            this.props.attributeRequestMethod(attributeRequestMethod);
            return this;
        }

        /**
         * (experimental) OpenID connect endpoints.
         * <p>
         * Default: - auto discovered with issuer URL
         * <p>
         * @return {@code this}
         * @param endpoints OpenID connect endpoints. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder endpoints(final software.amazon.awscdk.services.cognito.OidcEndpoints endpoints) {
            this.props.endpoints(endpoints);
            return this;
        }

        /**
         * (experimental) Identifiers.
         * <p>
         * Identifiers can be used to redirect users to the correct IdP in multitenant apps.
         * <p>
         * Default: - no identifiers used
         * <p>
         * @return {@code this}
         * @param identifiers Identifiers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder identifiers(final java.util.List<java.lang.String> identifiers) {
            this.props.identifiers(identifiers);
            return this;
        }

        /**
         * (experimental) The name of the provider.
         * <p>
         * Default: - the unique ID of the construct
         * <p>
         * @return {@code this}
         * @param name The name of the provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * (experimental) The OAuth 2.0 scopes that you will request from OpenID Connect. Scopes are groups of OpenID Connect user attributes to exchange with your app.
         * <p>
         * Default: ['openid']
         * <p>
         * @return {@code this}
         * @param scopes The OAuth 2.0 scopes that you will request from OpenID Connect. Scopes are groups of OpenID Connect user attributes to exchange with your app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scopes(final java.util.List<java.lang.String> scopes) {
            this.props.scopes(scopes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidc}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidc build() {
            return new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidc(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
