package software.amazon.awscdk.services.cognito.identitypool;

/**
 * (experimental) Define a Cognito Identity Pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OpenIdConnectProvider openIdConnectProvider;
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         .authenticationProviders(IdentityPoolAuthenticationProviders.builder()
 *                 .google(IdentityPoolGoogleLoginProvider.builder()
 *                         .clientId("12345678012.apps.googleusercontent.com")
 *                         .build())
 *                 .openIdConnectProviders(List.of(openIdConnectProvider))
 *                 .customProvider("my-custom-provider.example.com")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.148Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito_identitypool.IdentityPool")
public class IdentityPool extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.cognito.identitypool.IIdentityPool {

    protected IdentityPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IdentityPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IdentityPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IdentityPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import an existing Identity Pool from its Arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param identityPoolArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IIdentityPool fromIdentityPoolArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String identityPoolArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPool.class, "fromIdentityPoolArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IIdentityPool.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(identityPoolArn, "identityPoolArn is required") });
    }

    /**
     * (experimental) Import an existing Identity Pool from its id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param identityPoolId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IIdentityPool fromIdentityPoolId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String identityPoolId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPool.class, "fromIdentityPoolId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IIdentityPool.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(identityPoolId, "identityPoolId is required") });
    }

    /**
     * (experimental) Adds Role Mappings to Identity Pool.
     * <p>
     * @param roleMappings This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addRoleMappings(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping... roleMappings) {
        software.amazon.jsii.Kernel.call(this, "addRoleMappings", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(roleMappings).toArray(Object[]::new));
    }

    /**
     * (experimental) Add a User Pool to the IdentityPool and configure User Pool Client to handle identities.
     * <p>
     * @param userPool This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addUserPoolAuthentication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider userPool) {
        software.amazon.jsii.Kernel.call(this, "addUserPoolAuthentication", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(userPool, "userPool is required") });
    }

    /**
     * (experimental) Default role for authenticated users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getAuthenticatedRole() {
        return software.amazon.jsii.Kernel.get(this, "authenticatedRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) The ARN of the Identity Pool.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolArn() {
        return software.amazon.jsii.Kernel.get(this, "identityPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The id of the Identity Pool in the format REGION:GUID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolId() {
        return software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the Identity Pool.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolName() {
        return software.amazon.jsii.Kernel.get(this, "identityPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Default role for unauthenticated users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getUnauthenticatedRole() {
        return software.amazon.jsii.Kernel.get(this, "unauthenticatedRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cognito.identitypool.IdentityPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.identitypool.IdentityPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) Enables the Basic (Classic) authentication flow.
         * <p>
         * Default: - Classic Flow not allowed
         * <p>
         * @return {@code this}
         * @param allowClassicFlow Enables the Basic (Classic) authentication flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowClassicFlow(final java.lang.Boolean allowClassicFlow) {
            this.props().allowClassicFlow(allowClassicFlow);
            return this;
        }

        /**
         * (experimental) Wwhether the identity pool supports unauthenticated logins.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param allowUnauthenticatedIdentities Wwhether the identity pool supports unauthenticated logins. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowUnauthenticatedIdentities(final java.lang.Boolean allowUnauthenticatedIdentities) {
            this.props().allowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
            return this;
        }

        /**
         * (experimental) The Default Role to be assumed by Authenticated Users.
         * <p>
         * Default: - A Default Authenticated Role will be added
         * <p>
         * @return {@code this}
         * @param authenticatedRole The Default Role to be assumed by Authenticated Users. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authenticatedRole(final software.amazon.awscdk.services.iam.IRole authenticatedRole) {
            this.props().authenticatedRole(authenticatedRole);
            return this;
        }

        /**
         * (experimental) Authentication providers for using in identity pool.
         * <p>
         * Default: - No Authentication Providers passed directly to Identity Pool
         * <p>
         * @return {@code this}
         * @param authenticationProviders Authentication providers for using in identity pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authenticationProviders(final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAuthenticationProviders authenticationProviders) {
            this.props().authenticationProviders(authenticationProviders);
            return this;
        }

        /**
         * (experimental) The name of the Identity Pool.
         * <p>
         * Default: - automatically generated name by CloudFormation at deploy time
         * <p>
         * @return {@code this}
         * @param identityPoolName The name of the Identity Pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder identityPoolName(final java.lang.String identityPoolName) {
            this.props().identityPoolName(identityPoolName);
            return this;
        }

        /**
         * (experimental) Rules for mapping roles to users.
         * <p>
         * Default: - no Role Mappings
         * <p>
         * @return {@code this}
         * @param roleMappings Rules for mapping roles to users. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder roleMappings(final java.util.List<? extends software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping> roleMappings) {
            this.props().roleMappings(roleMappings);
            return this;
        }

        /**
         * (experimental) The Default Role to be assumed by Unauthenticated Users.
         * <p>
         * Default: - A Default Unauthenticated Role will be added
         * <p>
         * @return {@code this}
         * @param unauthenticatedRole The Default Role to be assumed by Unauthenticated Users. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder unauthenticatedRole(final software.amazon.awscdk.services.iam.IRole unauthenticatedRole) {
            this.props().unauthenticatedRole(unauthenticatedRole);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.identitypool.IdentityPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cognito.identitypool.IdentityPool build() {
            return new software.amazon.awscdk.services.cognito.identitypool.IdentityPool(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProps.Builder();
            }
            return this.props;
        }
    }
}
