package software.amazon.awscdk.services.cognito.identitypool;

/**
 * (experimental) Props for an Identity Pool Role Attachment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.identitypool.*;
 * import software.amazon.awscdk.services.iam.*;
 * IdentityPool identityPool;
 * IdentityPoolProviderUrl identityPoolProviderUrl;
 * Role role;
 * IdentityPoolRoleAttachmentProps identityPoolRoleAttachmentProps = IdentityPoolRoleAttachmentProps.builder()
 *         .identityPool(identityPool)
 *         // the properties below are optional
 *         .authenticatedRole(role)
 *         .roleMappings(List.of(IdentityPoolRoleMapping.builder()
 *                 .providerUrl(identityPoolProviderUrl)
 *                 // the properties below are optional
 *                 .resolveAmbiguousRoles(false)
 *                 .rules(List.of(RoleMappingRule.builder()
 *                         .claim("claim")
 *                         .claimValue("claimValue")
 *                         .mappedRole(role)
 *                         // the properties below are optional
 *                         .matchType(RoleMappingMatchType.EQUALS)
 *                         .build()))
 *                 .useToken(false)
 *                 .build()))
 *         .unauthenticatedRole(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.164Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito_identitypool.IdentityPoolRoleAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(IdentityPoolRoleAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IdentityPoolRoleAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Id of the Attachments Underlying Identity Pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IIdentityPool getIdentityPool();

    /**
     * (experimental) Default Authenticated (User) Role.
     * <p>
     * Default: - No default authenticated role will be added
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAuthenticatedRole() {
        return null;
    }

    /**
     * (experimental) Rules for mapping roles to users.
     * <p>
     * Default: - no Role Mappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping> getRoleMappings() {
        return null;
    }

    /**
     * (experimental) Default Unauthenticated (Guest) Role.
     * <p>
     * Default: - No default unauthenticated role will be added
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getUnauthenticatedRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IdentityPoolRoleAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdentityPoolRoleAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<IdentityPoolRoleAttachmentProps> {
        software.amazon.awscdk.services.cognito.identitypool.IIdentityPool identityPool;
        software.amazon.awscdk.services.iam.IRole authenticatedRole;
        java.util.List<software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping> roleMappings;
        software.amazon.awscdk.services.iam.IRole unauthenticatedRole;

        /**
         * Sets the value of {@link IdentityPoolRoleAttachmentProps#getIdentityPool}
         * @param identityPool Id of the Attachments Underlying Identity Pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder identityPool(software.amazon.awscdk.services.cognito.identitypool.IIdentityPool identityPool) {
            this.identityPool = identityPool;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolRoleAttachmentProps#getAuthenticatedRole}
         * @param authenticatedRole Default Authenticated (User) Role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authenticatedRole(software.amazon.awscdk.services.iam.IRole authenticatedRole) {
            this.authenticatedRole = authenticatedRole;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolRoleAttachmentProps#getRoleMappings}
         * @param roleMappings Rules for mapping roles to users.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder roleMappings(java.util.List<? extends software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping> roleMappings) {
            this.roleMappings = (java.util.List<software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping>)roleMappings;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolRoleAttachmentProps#getUnauthenticatedRole}
         * @param unauthenticatedRole Default Unauthenticated (Guest) Role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder unauthenticatedRole(software.amazon.awscdk.services.iam.IRole unauthenticatedRole) {
            this.unauthenticatedRole = unauthenticatedRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdentityPoolRoleAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public IdentityPoolRoleAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdentityPoolRoleAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityPoolRoleAttachmentProps {
        private final software.amazon.awscdk.services.cognito.identitypool.IIdentityPool identityPool;
        private final software.amazon.awscdk.services.iam.IRole authenticatedRole;
        private final java.util.List<software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping> roleMappings;
        private final software.amazon.awscdk.services.iam.IRole unauthenticatedRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityPool = software.amazon.jsii.Kernel.get(this, "identityPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IIdentityPool.class));
            this.authenticatedRole = software.amazon.jsii.Kernel.get(this, "authenticatedRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.roleMappings = software.amazon.jsii.Kernel.get(this, "roleMappings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping.class)));
            this.unauthenticatedRole = software.amazon.jsii.Kernel.get(this, "unauthenticatedRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityPool = java.util.Objects.requireNonNull(builder.identityPool, "identityPool is required");
            this.authenticatedRole = builder.authenticatedRole;
            this.roleMappings = (java.util.List<software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping>)builder.roleMappings;
            this.unauthenticatedRole = builder.unauthenticatedRole;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.identitypool.IIdentityPool getIdentityPool() {
            return this.identityPool;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAuthenticatedRole() {
            return this.authenticatedRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping> getRoleMappings() {
            return this.roleMappings;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getUnauthenticatedRole() {
            return this.unauthenticatedRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityPool", om.valueToTree(this.getIdentityPool()));
            if (this.getAuthenticatedRole() != null) {
                data.set("authenticatedRole", om.valueToTree(this.getAuthenticatedRole()));
            }
            if (this.getRoleMappings() != null) {
                data.set("roleMappings", om.valueToTree(this.getRoleMappings()));
            }
            if (this.getUnauthenticatedRole() != null) {
                data.set("unauthenticatedRole", om.valueToTree(this.getUnauthenticatedRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cognito_identitypool.IdentityPoolRoleAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdentityPoolRoleAttachmentProps.Jsii$Proxy that = (IdentityPoolRoleAttachmentProps.Jsii$Proxy) o;

            if (!identityPool.equals(that.identityPool)) return false;
            if (this.authenticatedRole != null ? !this.authenticatedRole.equals(that.authenticatedRole) : that.authenticatedRole != null) return false;
            if (this.roleMappings != null ? !this.roleMappings.equals(that.roleMappings) : that.roleMappings != null) return false;
            return this.unauthenticatedRole != null ? this.unauthenticatedRole.equals(that.unauthenticatedRole) : that.unauthenticatedRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identityPool.hashCode();
            result = 31 * result + (this.authenticatedRole != null ? this.authenticatedRole.hashCode() : 0);
            result = 31 * result + (this.roleMappings != null ? this.roleMappings.hashCode() : 0);
            result = 31 * result + (this.unauthenticatedRole != null ? this.unauthenticatedRole.hashCode() : 0);
            return result;
        }
    }
}
