package software.amazon.awscdk.services.connect;

/**
 * A CloudFormation `AWS::Connect::Rule`.
 * <p>
 * Creates a rule for the specified Amazon Connect instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * Object assignContactCategoryActions;
 * CfnRule cfnRule = CfnRule.Builder.create(this, "MyCfnRule")
 *         .actions(ActionsProperty.builder()
 *                 .assignContactCategoryActions(List.of(assignContactCategoryActions))
 *                 .eventBridgeActions(List.of(EventBridgeActionProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .sendNotificationActions(List.of(SendNotificationActionProperty.builder()
 *                         .content("content")
 *                         .contentType("contentType")
 *                         .deliveryMethod("deliveryMethod")
 *                         .recipient(NotificationRecipientTypeProperty.builder()
 *                                 .userArns(List.of("userArns"))
 *                                 .userTags(Map.of(
 *                                         "userTagsKey", "userTags"))
 *                                 .build())
 *                         // the properties below are optional
 *                         .subject("subject")
 *                         .build()))
 *                 .taskActions(List.of(TaskActionProperty.builder()
 *                         .contactFlowArn("contactFlowArn")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .references(Map.of(
 *                                 "referencesKey", ReferenceProperty.builder()
 *                                         .type("type")
 *                                         .value("value")
 *                                         .build()))
 *                         .build()))
 *                 .build())
 *         .function("function")
 *         .instanceArn("instanceArn")
 *         .name("name")
 *         .publishStatus("publishStatus")
 *         .triggerEventSource(RuleTriggerEventSourceProperty.builder()
 *                 .eventSourceName("eventSourceName")
 *                 // the properties below are optional
 *                 .integrationAssociationArn("integrationAssociationArn")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.349Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnRule")
public class CfnRule extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Connect::Rule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * A list of actions to be run when the rule is triggered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getActions() {
        return software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of actions to be run when the rule is triggered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnRule.ActionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * A list of actions to be run when the rule is triggered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * The conditions of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunction() {
        return software.amazon.jsii.Kernel.get(this, "function", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The conditions of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunction(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "function", java.util.Objects.requireNonNull(value, "function is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceArn", java.util.Objects.requireNonNull(value, "instanceArn is required"));
    }

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The publish status of the rule.
     * <p>
     * <em>Allowed values</em> : <code>DRAFT</code> | <code>PUBLISHED</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPublishStatus() {
        return software.amazon.jsii.Kernel.get(this, "publishStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The publish status of the rule.
     * <p>
     * <em>Allowed values</em> : <code>DRAFT</code> | <code>PUBLISHED</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublishStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "publishStatus", java.util.Objects.requireNonNull(value, "publishStatus is required"));
    }

    /**
     * The event source to trigger the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTriggerEventSource() {
        return software.amazon.jsii.Kernel.get(this, "triggerEventSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The event source to trigger the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggerEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnRule.RuleTriggerEventSourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "triggerEventSource", java.util.Objects.requireNonNull(value, "triggerEventSource is required"));
    }

    /**
     * The event source to trigger the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggerEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "triggerEventSource", java.util.Objects.requireNonNull(value, "triggerEventSource is required"));
    }
    /**
     * A list of actions to be run when the rule is triggered.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * Object assignContactCategoryActions;
     * ActionsProperty actionsProperty = ActionsProperty.builder()
     *         .assignContactCategoryActions(List.of(assignContactCategoryActions))
     *         .eventBridgeActions(List.of(EventBridgeActionProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .sendNotificationActions(List.of(SendNotificationActionProperty.builder()
     *                 .content("content")
     *                 .contentType("contentType")
     *                 .deliveryMethod("deliveryMethod")
     *                 .recipient(NotificationRecipientTypeProperty.builder()
     *                         .userArns(List.of("userArns"))
     *                         .userTags(Map.of(
     *                                 "userTagsKey", "userTags"))
     *                         .build())
     *                 // the properties below are optional
     *                 .subject("subject")
     *                 .build()))
     *         .taskActions(List.of(TaskActionProperty.builder()
     *                 .contactFlowArn("contactFlowArn")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .references(Map.of(
     *                         "referencesKey", ReferenceProperty.builder()
     *                                 .type("type")
     *                                 .value("value")
     *                                 .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnRule.ActionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the contact category action.
         * <p>
         * The syntax can be empty, for example, <code>{}</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssignContactCategoryActions() {
            return null;
        }

        /**
         * Information about the EventBridge action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeActions() {
            return null;
        }

        /**
         * Information about the send notification action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSendNotificationActions() {
            return null;
        }

        /**
         * Information about the task action.
         * <p>
         * This field is required if <code>TriggerEventSource</code> is one of the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTaskActions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionsProperty> {
            java.lang.Object assignContactCategoryActions;
            java.lang.Object eventBridgeActions;
            java.lang.Object sendNotificationActions;
            java.lang.Object taskActions;

            /**
             * Sets the value of {@link ActionsProperty#getAssignContactCategoryActions}
             * @param assignContactCategoryActions Information about the contact category action.
             *                                     The syntax can be empty, for example, <code>{}</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignContactCategoryActions(java.util.List<? extends java.lang.Object> assignContactCategoryActions) {
                this.assignContactCategoryActions = assignContactCategoryActions;
                return this;
            }

            /**
             * Sets the value of {@link ActionsProperty#getAssignContactCategoryActions}
             * @param assignContactCategoryActions Information about the contact category action.
             *                                     The syntax can be empty, for example, <code>{}</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignContactCategoryActions(software.amazon.awscdk.core.IResolvable assignContactCategoryActions) {
                this.assignContactCategoryActions = assignContactCategoryActions;
                return this;
            }

            /**
             * Sets the value of {@link ActionsProperty#getEventBridgeActions}
             * @param eventBridgeActions Information about the EventBridge action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeActions(software.amazon.awscdk.core.IResolvable eventBridgeActions) {
                this.eventBridgeActions = eventBridgeActions;
                return this;
            }

            /**
             * Sets the value of {@link ActionsProperty#getEventBridgeActions}
             * @param eventBridgeActions Information about the EventBridge action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeActions(java.util.List<? extends java.lang.Object> eventBridgeActions) {
                this.eventBridgeActions = eventBridgeActions;
                return this;
            }

            /**
             * Sets the value of {@link ActionsProperty#getSendNotificationActions}
             * @param sendNotificationActions Information about the send notification action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendNotificationActions(software.amazon.awscdk.core.IResolvable sendNotificationActions) {
                this.sendNotificationActions = sendNotificationActions;
                return this;
            }

            /**
             * Sets the value of {@link ActionsProperty#getSendNotificationActions}
             * @param sendNotificationActions Information about the send notification action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendNotificationActions(java.util.List<? extends java.lang.Object> sendNotificationActions) {
                this.sendNotificationActions = sendNotificationActions;
                return this;
            }

            /**
             * Sets the value of {@link ActionsProperty#getTaskActions}
             * @param taskActions Information about the task action.
             *                    This field is required if <code>TriggerEventSource</code> is one of the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskActions(software.amazon.awscdk.core.IResolvable taskActions) {
                this.taskActions = taskActions;
                return this;
            }

            /**
             * Sets the value of {@link ActionsProperty#getTaskActions}
             * @param taskActions Information about the task action.
             *                    This field is required if <code>TriggerEventSource</code> is one of the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskActions(java.util.List<? extends java.lang.Object> taskActions) {
                this.taskActions = taskActions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionsProperty {
            private final java.lang.Object assignContactCategoryActions;
            private final java.lang.Object eventBridgeActions;
            private final java.lang.Object sendNotificationActions;
            private final java.lang.Object taskActions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.assignContactCategoryActions = software.amazon.jsii.Kernel.get(this, "assignContactCategoryActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBridgeActions = software.amazon.jsii.Kernel.get(this, "eventBridgeActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sendNotificationActions = software.amazon.jsii.Kernel.get(this, "sendNotificationActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.taskActions = software.amazon.jsii.Kernel.get(this, "taskActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.assignContactCategoryActions = builder.assignContactCategoryActions;
                this.eventBridgeActions = builder.eventBridgeActions;
                this.sendNotificationActions = builder.sendNotificationActions;
                this.taskActions = builder.taskActions;
            }

            @Override
            public final java.lang.Object getAssignContactCategoryActions() {
                return this.assignContactCategoryActions;
            }

            @Override
            public final java.lang.Object getEventBridgeActions() {
                return this.eventBridgeActions;
            }

            @Override
            public final java.lang.Object getSendNotificationActions() {
                return this.sendNotificationActions;
            }

            @Override
            public final java.lang.Object getTaskActions() {
                return this.taskActions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssignContactCategoryActions() != null) {
                    data.set("assignContactCategoryActions", om.valueToTree(this.getAssignContactCategoryActions()));
                }
                if (this.getEventBridgeActions() != null) {
                    data.set("eventBridgeActions", om.valueToTree(this.getEventBridgeActions()));
                }
                if (this.getSendNotificationActions() != null) {
                    data.set("sendNotificationActions", om.valueToTree(this.getSendNotificationActions()));
                }
                if (this.getTaskActions() != null) {
                    data.set("taskActions", om.valueToTree(this.getTaskActions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnRule.ActionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionsProperty.Jsii$Proxy that = (ActionsProperty.Jsii$Proxy) o;

                if (this.assignContactCategoryActions != null ? !this.assignContactCategoryActions.equals(that.assignContactCategoryActions) : that.assignContactCategoryActions != null) return false;
                if (this.eventBridgeActions != null ? !this.eventBridgeActions.equals(that.eventBridgeActions) : that.eventBridgeActions != null) return false;
                if (this.sendNotificationActions != null ? !this.sendNotificationActions.equals(that.sendNotificationActions) : that.sendNotificationActions != null) return false;
                return this.taskActions != null ? this.taskActions.equals(that.taskActions) : that.taskActions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.assignContactCategoryActions != null ? this.assignContactCategoryActions.hashCode() : 0;
                result = 31 * result + (this.eventBridgeActions != null ? this.eventBridgeActions.hashCode() : 0);
                result = 31 * result + (this.sendNotificationActions != null ? this.sendNotificationActions.hashCode() : 0);
                result = 31 * result + (this.taskActions != null ? this.taskActions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The EventBridge action definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EventBridgeActionProperty eventBridgeActionProperty = EventBridgeActionProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnRule.EventBridgeActionProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link EventBridgeActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeActionProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link EventBridgeActionProperty#getName}
             * @param name The name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeActionProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnRule.EventBridgeActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeActionProperty.Jsii$Proxy that = (EventBridgeActionProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * The type of notification recipient.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * NotificationRecipientTypeProperty notificationRecipientTypeProperty = NotificationRecipientTypeProperty.builder()
     *         .userArns(List.of("userArns"))
     *         .userTags(Map.of(
     *                 "userTagsKey", "userTags"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnRule.NotificationRecipientTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationRecipientTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationRecipientTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the user account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUserArns() {
            return null;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * For example, { "tags": {"key1":"value1", "key2":"value2"} }. Amazon Connect users with the specified tags will be notified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotificationRecipientTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationRecipientTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationRecipientTypeProperty> {
            java.util.List<java.lang.String> userArns;
            java.lang.Object userTags;

            /**
             * Sets the value of {@link NotificationRecipientTypeProperty#getUserArns}
             * @param userArns The Amazon Resource Name (ARN) of the user account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userArns(java.util.List<java.lang.String> userArns) {
                this.userArns = userArns;
                return this;
            }

            /**
             * Sets the value of {@link NotificationRecipientTypeProperty#getUserTags}
             * @param userTags The tags used to organize, track, or control access for this resource.
             *                 For example, { "tags": {"key1":"value1", "key2":"value2"} }. Amazon Connect users with the specified tags will be notified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userTags(software.amazon.awscdk.core.IResolvable userTags) {
                this.userTags = userTags;
                return this;
            }

            /**
             * Sets the value of {@link NotificationRecipientTypeProperty#getUserTags}
             * @param userTags The tags used to organize, track, or control access for this resource.
             *                 For example, { "tags": {"key1":"value1", "key2":"value2"} }. Amazon Connect users with the specified tags will be notified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userTags(java.util.Map<java.lang.String, java.lang.String> userTags) {
                this.userTags = userTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationRecipientTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationRecipientTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationRecipientTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationRecipientTypeProperty {
            private final java.util.List<java.lang.String> userArns;
            private final java.lang.Object userTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.userArns = software.amazon.jsii.Kernel.get(this, "userArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.userTags = software.amazon.jsii.Kernel.get(this, "userTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.userArns = builder.userArns;
                this.userTags = builder.userTags;
            }

            @Override
            public final java.util.List<java.lang.String> getUserArns() {
                return this.userArns;
            }

            @Override
            public final java.lang.Object getUserTags() {
                return this.userTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUserArns() != null) {
                    data.set("userArns", om.valueToTree(this.getUserArns()));
                }
                if (this.getUserTags() != null) {
                    data.set("userTags", om.valueToTree(this.getUserTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnRule.NotificationRecipientTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationRecipientTypeProperty.Jsii$Proxy that = (NotificationRecipientTypeProperty.Jsii$Proxy) o;

                if (this.userArns != null ? !this.userArns.equals(that.userArns) : that.userArns != null) return false;
                return this.userTags != null ? this.userTags.equals(that.userTags) : that.userTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.userArns != null ? this.userArns.hashCode() : 0;
                result = 31 * result + (this.userTags != null ? this.userTags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the reference when the `referenceType` is `URL` .
     * <p>
     * Otherwise, null. (Supports variable injection in the <code>Value</code> field.)
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * ReferenceProperty referenceProperty = ReferenceProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnRule.ReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(ReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the reference. `DATE` must be of type Epoch timestamp.
         * <p>
         * <em>Allowed values</em> : <code>URL</code> | <code>ATTACHMENT</code> | <code>NUMBER</code> | <code>STRING</code> | <code>DATE</code> | <code>EMAIL</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A valid value for the reference.
         * <p>
         * For example, for a URL reference, a formatted URL that is displayed to an agent in the Contact Control Panel (CCP).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReferenceProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link ReferenceProperty#getType}
             * @param type The type of the reference. `DATE` must be of type Epoch timestamp. This parameter is required.
             *             <em>Allowed values</em> : <code>URL</code> | <code>ATTACHMENT</code> | <code>NUMBER</code> | <code>STRING</code> | <code>DATE</code> | <code>EMAIL</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceProperty#getValue}
             * @param value A valid value for the reference. This parameter is required.
             *              For example, for a URL reference, a formatted URL that is displayed to an agent in the Contact Control Panel (CCP).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReferenceProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnRule.ReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReferenceProperty.Jsii$Proxy that = (ReferenceProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The name of the event source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * RuleTriggerEventSourceProperty ruleTriggerEventSourceProperty = RuleTriggerEventSourceProperty.builder()
     *         .eventSourceName("eventSourceName")
     *         // the properties below are optional
     *         .integrationAssociationArn("integrationAssociationArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnRule.RuleTriggerEventSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleTriggerEventSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleTriggerEventSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the event source.
         * <p>
         * <em>Allowed values</em> : <code>OnPostCallAnalysisAvailable</code> | <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnPostChatAnalysisAvailable</code> | <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventSourceName();

        /**
         * The Amazon Resource Name (ARN) for the integration association.
         * <p>
         * <code>IntegrationAssociationArn</code> is required if <code>TriggerEventSource</code> is one of the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationAssociationArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleTriggerEventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleTriggerEventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleTriggerEventSourceProperty> {
            java.lang.String eventSourceName;
            java.lang.String integrationAssociationArn;

            /**
             * Sets the value of {@link RuleTriggerEventSourceProperty#getEventSourceName}
             * @param eventSourceName The name of the event source. This parameter is required.
             *                        <em>Allowed values</em> : <code>OnPostCallAnalysisAvailable</code> | <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnPostChatAnalysisAvailable</code> | <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventSourceName(java.lang.String eventSourceName) {
                this.eventSourceName = eventSourceName;
                return this;
            }

            /**
             * Sets the value of {@link RuleTriggerEventSourceProperty#getIntegrationAssociationArn}
             * @param integrationAssociationArn The Amazon Resource Name (ARN) for the integration association.
             *                                  <code>IntegrationAssociationArn</code> is required if <code>TriggerEventSource</code> is one of the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integrationAssociationArn(java.lang.String integrationAssociationArn) {
                this.integrationAssociationArn = integrationAssociationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleTriggerEventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleTriggerEventSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleTriggerEventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleTriggerEventSourceProperty {
            private final java.lang.String eventSourceName;
            private final java.lang.String integrationAssociationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventSourceName = software.amazon.jsii.Kernel.get(this, "eventSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integrationAssociationArn = software.amazon.jsii.Kernel.get(this, "integrationAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventSourceName = java.util.Objects.requireNonNull(builder.eventSourceName, "eventSourceName is required");
                this.integrationAssociationArn = builder.integrationAssociationArn;
            }

            @Override
            public final java.lang.String getEventSourceName() {
                return this.eventSourceName;
            }

            @Override
            public final java.lang.String getIntegrationAssociationArn() {
                return this.integrationAssociationArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventSourceName", om.valueToTree(this.getEventSourceName()));
                if (this.getIntegrationAssociationArn() != null) {
                    data.set("integrationAssociationArn", om.valueToTree(this.getIntegrationAssociationArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnRule.RuleTriggerEventSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleTriggerEventSourceProperty.Jsii$Proxy that = (RuleTriggerEventSourceProperty.Jsii$Proxy) o;

                if (!eventSourceName.equals(that.eventSourceName)) return false;
                return this.integrationAssociationArn != null ? this.integrationAssociationArn.equals(that.integrationAssociationArn) : that.integrationAssociationArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventSourceName.hashCode();
                result = 31 * result + (this.integrationAssociationArn != null ? this.integrationAssociationArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the send notification action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * SendNotificationActionProperty sendNotificationActionProperty = SendNotificationActionProperty.builder()
     *         .content("content")
     *         .contentType("contentType")
     *         .deliveryMethod("deliveryMethod")
     *         .recipient(NotificationRecipientTypeProperty.builder()
     *                 .userArns(List.of("userArns"))
     *                 .userTags(Map.of(
     *                         "userTagsKey", "userTags"))
     *                 .build())
     *         // the properties below are optional
     *         .subject("subject")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnRule.SendNotificationActionProperty")
    @software.amazon.jsii.Jsii.Proxy(SendNotificationActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SendNotificationActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Notification content.
         * <p>
         * Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <em>Amazon Connect Administrators Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContent();

        /**
         * Content type format.
         * <p>
         * <em>Allowed value</em> : <code>PLAIN_TEXT</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContentType();

        /**
         * Notification delivery method.
         * <p>
         * <em>Allowed value</em> : <code>EMAIL</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeliveryMethod();

        /**
         * Notification recipient.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRecipient();

        /**
         * The subject of the email if the delivery method is `EMAIL` .
         * <p>
         * Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <em>Amazon Connect Administrators Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubject() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SendNotificationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SendNotificationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SendNotificationActionProperty> {
            java.lang.String content;
            java.lang.String contentType;
            java.lang.String deliveryMethod;
            java.lang.Object recipient;
            java.lang.String subject;

            /**
             * Sets the value of {@link SendNotificationActionProperty#getContent}
             * @param content Notification content. This parameter is required.
             *                Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <em>Amazon Connect Administrators Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder content(java.lang.String content) {
                this.content = content;
                return this;
            }

            /**
             * Sets the value of {@link SendNotificationActionProperty#getContentType}
             * @param contentType Content type format. This parameter is required.
             *                    <em>Allowed value</em> : <code>PLAIN_TEXT</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Sets the value of {@link SendNotificationActionProperty#getDeliveryMethod}
             * @param deliveryMethod Notification delivery method. This parameter is required.
             *                       <em>Allowed value</em> : <code>EMAIL</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryMethod(java.lang.String deliveryMethod) {
                this.deliveryMethod = deliveryMethod;
                return this;
            }

            /**
             * Sets the value of {@link SendNotificationActionProperty#getRecipient}
             * @param recipient Notification recipient. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recipient(software.amazon.awscdk.services.connect.CfnRule.NotificationRecipientTypeProperty recipient) {
                this.recipient = recipient;
                return this;
            }

            /**
             * Sets the value of {@link SendNotificationActionProperty#getRecipient}
             * @param recipient Notification recipient. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recipient(software.amazon.awscdk.core.IResolvable recipient) {
                this.recipient = recipient;
                return this;
            }

            /**
             * Sets the value of {@link SendNotificationActionProperty#getSubject}
             * @param subject The subject of the email if the delivery method is `EMAIL` .
             *                Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <em>Amazon Connect Administrators Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subject(java.lang.String subject) {
                this.subject = subject;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SendNotificationActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SendNotificationActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SendNotificationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SendNotificationActionProperty {
            private final java.lang.String content;
            private final java.lang.String contentType;
            private final java.lang.String deliveryMethod;
            private final java.lang.Object recipient;
            private final java.lang.String subject;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deliveryMethod = software.amazon.jsii.Kernel.get(this, "deliveryMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recipient = software.amazon.jsii.Kernel.get(this, "recipient", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subject = software.amazon.jsii.Kernel.get(this, "subject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
                this.contentType = java.util.Objects.requireNonNull(builder.contentType, "contentType is required");
                this.deliveryMethod = java.util.Objects.requireNonNull(builder.deliveryMethod, "deliveryMethod is required");
                this.recipient = java.util.Objects.requireNonNull(builder.recipient, "recipient is required");
                this.subject = builder.subject;
            }

            @Override
            public final java.lang.String getContent() {
                return this.content;
            }

            @Override
            public final java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            public final java.lang.String getDeliveryMethod() {
                return this.deliveryMethod;
            }

            @Override
            public final java.lang.Object getRecipient() {
                return this.recipient;
            }

            @Override
            public final java.lang.String getSubject() {
                return this.subject;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("content", om.valueToTree(this.getContent()));
                data.set("contentType", om.valueToTree(this.getContentType()));
                data.set("deliveryMethod", om.valueToTree(this.getDeliveryMethod()));
                data.set("recipient", om.valueToTree(this.getRecipient()));
                if (this.getSubject() != null) {
                    data.set("subject", om.valueToTree(this.getSubject()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnRule.SendNotificationActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SendNotificationActionProperty.Jsii$Proxy that = (SendNotificationActionProperty.Jsii$Proxy) o;

                if (!content.equals(that.content)) return false;
                if (!contentType.equals(that.contentType)) return false;
                if (!deliveryMethod.equals(that.deliveryMethod)) return false;
                if (!recipient.equals(that.recipient)) return false;
                return this.subject != null ? this.subject.equals(that.subject) : that.subject == null;
            }

            @Override
            public final int hashCode() {
                int result = this.content.hashCode();
                result = 31 * result + (this.contentType.hashCode());
                result = 31 * result + (this.deliveryMethod.hashCode());
                result = 31 * result + (this.recipient.hashCode());
                result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the task action.
     * <p>
     * This field is required if <code>TriggerEventSource</code> is one of the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * TaskActionProperty taskActionProperty = TaskActionProperty.builder()
     *         .contactFlowArn("contactFlowArn")
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .references(Map.of(
     *                 "referencesKey", ReferenceProperty.builder()
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnRule.TaskActionProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the flow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContactFlowArn();

        /**
         * The name.
         * <p>
         * Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <em>Amazon Connect Administrators Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The description.
         * <p>
         * Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <em>Amazon Connect Administrators Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Information about the reference when the `referenceType` is `URL` .
         * <p>
         * Otherwise, null. <code>URL</code> is the only accepted type. (Supports variable injection in the <code>Value</code> field.)
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReferences() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TaskActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskActionProperty> {
            java.lang.String contactFlowArn;
            java.lang.String name;
            java.lang.String description;
            java.lang.Object references;

            /**
             * Sets the value of {@link TaskActionProperty#getContactFlowArn}
             * @param contactFlowArn The Amazon Resource Name (ARN) of the flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactFlowArn(java.lang.String contactFlowArn) {
                this.contactFlowArn = contactFlowArn;
                return this;
            }

            /**
             * Sets the value of {@link TaskActionProperty#getName}
             * @param name The name. This parameter is required.
             *             Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <em>Amazon Connect Administrators Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TaskActionProperty#getDescription}
             * @param description The description.
             *                    Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <em>Amazon Connect Administrators Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link TaskActionProperty#getReferences}
             * @param references Information about the reference when the `referenceType` is `URL` .
             *                   Otherwise, null. <code>URL</code> is the only accepted type. (Supports variable injection in the <code>Value</code> field.)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder references(software.amazon.awscdk.core.IResolvable references) {
                this.references = references;
                return this;
            }

            /**
             * Sets the value of {@link TaskActionProperty#getReferences}
             * @param references Information about the reference when the `referenceType` is `URL` .
             *                   Otherwise, null. <code>URL</code> is the only accepted type. (Supports variable injection in the <code>Value</code> field.)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder references(java.util.Map<java.lang.String, ? extends java.lang.Object> references) {
                this.references = references;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskActionProperty {
            private final java.lang.String contactFlowArn;
            private final java.lang.String name;
            private final java.lang.String description;
            private final java.lang.Object references;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contactFlowArn = software.amazon.jsii.Kernel.get(this, "contactFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.references = software.amazon.jsii.Kernel.get(this, "references", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contactFlowArn = java.util.Objects.requireNonNull(builder.contactFlowArn, "contactFlowArn is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
                this.references = builder.references;
            }

            @Override
            public final java.lang.String getContactFlowArn() {
                return this.contactFlowArn;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getReferences() {
                return this.references;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("contactFlowArn", om.valueToTree(this.getContactFlowArn()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getReferences() != null) {
                    data.set("references", om.valueToTree(this.getReferences()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnRule.TaskActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskActionProperty.Jsii$Proxy that = (TaskActionProperty.Jsii$Proxy) o;

                if (!contactFlowArn.equals(that.contactFlowArn)) return false;
                if (!name.equals(that.name)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.references != null ? this.references.equals(that.references) : that.references == null;
            }

            @Override
            public final int hashCode() {
                int result = this.contactFlowArn.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.references != null ? this.references.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnRuleProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnRuleProps.Builder();
        }

        /**
         * A list of actions to be run when the rule is triggered.
         * <p>
         * @return {@code this}
         * @param actions A list of actions to be run when the rule is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final software.amazon.awscdk.services.connect.CfnRule.ActionsProperty actions) {
            this.props.actions(actions);
            return this;
        }
        /**
         * A list of actions to be run when the rule is triggered.
         * <p>
         * @return {@code this}
         * @param actions A list of actions to be run when the rule is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final software.amazon.awscdk.core.IResolvable actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * The conditions of the rule.
         * <p>
         * @return {@code this}
         * @param function The conditions of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder function(final java.lang.String function) {
            this.props.function(function);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the instance.
         * <p>
         * @return {@code this}
         * @param instanceArn The Amazon Resource Name (ARN) of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final java.lang.String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        /**
         * The name of the rule.
         * <p>
         * @return {@code this}
         * @param name The name of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The publish status of the rule.
         * <p>
         * <em>Allowed values</em> : <code>DRAFT</code> | <code>PUBLISHED</code>
         * <p>
         * @return {@code this}
         * @param publishStatus The publish status of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishStatus(final java.lang.String publishStatus) {
            this.props.publishStatus(publishStatus);
            return this;
        }

        /**
         * The event source to trigger the rule.
         * <p>
         * @return {@code this}
         * @param triggerEventSource The event source to trigger the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerEventSource(final software.amazon.awscdk.services.connect.CfnRule.RuleTriggerEventSourceProperty triggerEventSource) {
            this.props.triggerEventSource(triggerEventSource);
            return this;
        }
        /**
         * The event source to trigger the rule.
         * <p>
         * @return {@code this}
         * @param triggerEventSource The event source to trigger the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerEventSource(final software.amazon.awscdk.core.IResolvable triggerEventSource) {
            this.props.triggerEventSource(triggerEventSource);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * <p>
         * @return {@code this}
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.connect.CfnRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnRule build() {
            return new software.amazon.awscdk.services.connect.CfnRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
